package cn.yw.nhyw.nhywjtxcrzgl.action;


import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.DateUtil;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptuserrole.model.PtyhBean;
import cn.yw.nhyw.nhywjtxcrzgl.service.NhywjtssxcdService;

@SuppressWarnings({"all"})
@Component("nhywjtssxcdAction")
public class NhywjtssxcdAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(NhywjtssxcdAction.class);
	
	@Autowired
	private NhywjtssxcdService service;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listNhywjtssxcdByPage")
	public void listNhywjtssxcdByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listNhywjtssxcdByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjtssxcdAction-listNhywjtssxcdByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Nhywjtssxcd")
	public void count_Nhywjtssxcd(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Nhywjtssxcd(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjtssxcdAction-count_Nhywjtssxcd-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ Nhywjtssxcd
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Nhywjtssxcd")
	public void query_Nhywjtssxcd(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Nhywjtssxcd(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjtssxcdAction-query_Nhywjtssxcd-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ һNhywjtssxcd
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Nhywjtssxcd")
	public void get_Nhywjtssxcd(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Nhywjtssxcd(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjtssxcdActionquery_Nhywjtssxcd-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteNhywjtssxcd")
	public void delete_Nhywjtssxcd(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Nhywjtssxcd(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjtssxcdAction-delete_Nhywjtssxcd-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Nhywjtssxcd")
	public void insert_Nhywjtssxcd(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.checkEmpty(map.get("xh"))){
				map.put("xh",StringUtil.getUUID());
			}
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Nhywjtssxcd(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					service.insert_Nhywjtssxcd(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				service.insert_Nhywjtssxcd(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjtssxcdAction-insert_Nhywjtssxcd()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Nhywjtssxcd")
	public void update_Nhywjtssxcd(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Nhywjtssxcd(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					int result = service.update_Nhywjtssxcd(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				int result = service.update_Nhywjtssxcd(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjtssxcdAction-update_Nhywjtssxcd-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="appraise_Nhywjtssxcd")
	public void appraise_Nhywjtssxcd(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			PtyhBean ptyh = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo"));
			String userName = ptyh.getYhzh();
			String bmbh = ptyh.getBmbh();
			map.put("xcpjr", userName);
			map.put("xcpjdw", bmbh);
			map.put("xcpjsj", DateUtil.currentDateTime());
			map.put("xgry", userName);
			map.put("xgrq", DateUtil.currentDateTime());
			System.out.println(map);
			service.update_Nhywjtssxcd(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjtssxcdAction-appraise_Nhywjtssxcd-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Nhywjtssxcd")
	public void batch_delete_Nhywjtssxcd(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Nhywjtssxcd(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjtssxcdAction-batch_delete_Nhywjtssxcd-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Nhywjtssxcd")
	public void exp_Nhywjtssxcd(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_Nhywjtssxcd(map);		
			List<HashMap> expList = new ArrayList<HashMap>();
			for(Map m : sList){
				Map exportMap = new HashMap();
				exportMap.put("yhzh", m.get("yhzh"));
				expList.add((HashMap) exportMap);
			}
			int excelNum = 2;
			ExcelCol[] cells = new ExcelCol[excelNum];
			String[] zdbm = {"yhzh", "yhmc",};
			String[] zdmc = {"û˺", "û"};
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}		
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
        	String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "ͨʩѲ鵥-"+dateTime);
			params.put("sheetName", "ͨʩѲ鵥");
			params.put("header", "ͨʩѲ鵥");	
			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywjtssxcdAction-exoprtExcel-error:" +e);
			
		}
	}
	*/
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_IMPORT ,info ="imp_Nhywjtssxcd")
	public String imp_Nhywjtssxcd(String excelFile,Object user) {
		String rs = "ʽ!";
		int rowNum = 0;
		int dataCount = 0;
		int successNum = 0;
		int repeatNum = 0;
		int failNum = 0;
		try {
		
			ExcelReader readExcel = new ExcelReader();
			readExcel.openFile(excelFile);
			readExcel.setSheetNum(0);
			int count = readExcel.getRowCount();
			iLog.info("count--->" + count);
			rs = " ݳɹܹ"+ dataCount +",ظ"+repeatNum+"ݣʧ"+failNum+"!";
			File file = new File(excelFile);
			if(file.exists()){
				file.delete();
			}
		} catch (Exception e) {
			if (rowNum > 3) {
				rs = "Դֵ()ʧܣExcel" + rowNum + "δ()ɹ";
			} else {
				rs = "Դ()ʧܣ";
			}
			iLog.error("NhywjtssxcdAction-imp_Nhywjtssxcd-error:" +e);
			e.printStackTrace();
		}		
		return rs;
	}
	*/
}
