package cn.im.operation;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.Struts2Utils;

@SuppressWarnings({"all"})
@Component("operationAction")
public class OperationAction extends BaseAction{

	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(OperationAction.class);
	
	@Autowired
	private OperationService service;
	
	
	// ѯڵ·Ϣҳ	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="getNodeServerStatus")
	public void getNodeServerStatus() { 		
		Map res = new HashMap();
		try {
			Map obj = Struts2Utils.getRequestParameterMap();
			res = service.getNodeServerStatus(obj);
			Struts2Utils.renderJson(res);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("OperationAction-getNodeServerStatus-error: " +e);
			Struts2Utils.renderJson(Constants.FAIL);
		}
	}
	
	// ѯҳ
	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_CaVideoSourcePage")
	public void query_CaVideoSourcePage() throws SQLException{ 
		Map resMap = new HashMap();
		try {
			Map obj = Struts2Utils.getRequestParameterMap();
			resMap = service.query_CaVideoSourcePage(obj);
			Struts2Utils.renderJson(resMap);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("OperationAction-query_CaVideoSourcePage-error: " +e);
			Struts2Utils.renderJson(Constants.FAIL);
		}
	}
	
	// ѯϢҳ
	@OperateType(value = LogConstants.LOG_QUERY ,info ="getServers")
	public void getServers(){ 
		Map map = new HashMap();
		try {
			Map obj = Struts2Utils.getRequestParameterMap();
			map = service.getServers(obj);
			Struts2Utils.renderJson(map);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("OperationAction-getServers-error: " +e);
			Struts2Utils.renderJson(Constants.FAIL);
		}
	}
	
	// ѯ쳣ҳ
	@OperateType(value = LogConstants.LOG_QUERY ,info ="getAbnormalCamera")
	public void getAbnormalCamera() {
		Map map = new HashMap();
		try {
			Map obj = Struts2Utils.getRequestParameterMap();
			map = service.getAbnormalCamera(obj);
			Struts2Utils.renderJson(map);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("OperationAction-getAbnormalCamera-error: " +e);
			Struts2Utils.renderJson(Constants.FAIL);
		}
	}
	
	// ѯҳ
	@OperateType(value = LogConstants.LOG_QUERY ,info ="getNormalCamera")
	public void getNormalCamera() {
		Map map = new HashMap();
		try {
			Map obj = Struts2Utils.getRequestParameterMap();
			map = service.getNormalCamera(obj);
			Struts2Utils.renderJson(map);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("OperationAction-getNormalCamera-error: " +e);
			Struts2Utils.renderJson(Constants.FAIL);
		}
	}
	
	//  id  type ѯĳһϸϢ
	@OperateType(value = LogConstants.LOG_QUERY ,info ="getServerInfoById")
	public void getServerInfoById() {
		Map map = new HashMap();
		try {
			Map obj = Struts2Utils.getRequestParameterMap();
			map = service.getServerInfoById(obj);
			Struts2Utils.renderJson(map);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("OperationAction-getServerInfoById-error: " +e);
			Struts2Utils.renderJson(Constants.FAIL);
		}
	}
	
}
