package cn.im.che.action;

 import cn.im.che.service.ClxxgpsService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;

@SuppressWarnings({"all"})
@Component("clxxgpsAction")
public class ClxxgpsAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(ClxxgpsAction.class);
	
	@Autowired
	private ClxxgpsService service;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listClxxgpsByPage")
	public void listClxxgpsByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listClxxgpsByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("ClxxgpsAction-listClxxgpsByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteClxxgps")
	public void delete_Clxxgps(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Clxxgps(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("ClxxgpsAction-delete_Clxxgps-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Clxxgps")
	public void insert_Clxxgps(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.checkEmpty(map.get("xh"))){
				map.put("xh",StringUtil.getUUID());
			}
			service.insert_Clxxgps(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("ClxxgpsAction-listClxxgpsByPage()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Clxxgps")
	public void update_Clxxgps(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int result = service.update_Clxxgps(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("ClxxgpsAction-update_Clxxgps-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯȫб
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_Clxxgps")
	public void query_Clxxgps(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Clxxgps(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("ClxxgpsAction-query_Clxxgps-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
}
