;(function ($) {
	var history = function (options) {
		this.opt = {
			limit: '10',
			maxHeight: '155',
			panelWidth: '148',
			storeKey: 'history',
			itemClick: function () {}
		};
		this.$input = $('#' + options.containerId).siblings().children('.textbox-text');
		this.$btn = $('#' + options.triggerId);
		this.contentDiv = $('<div id=' + options.storeKey + '></div>');
		this.contexteasyUIDiv = $('<div id=' + options.storeKey + ' class="panel combo-p"></div>');
		this.opt = $.extend({}, this.opt, options);
		this.checkId();
	}
	history.prototype = {
		constructor: history,
		checkId: function () {
			if (typeof(this.opt.triggerId) != 'string' || typeof(this.opt.containerId) != 'string') {
				$.log('ȱٲtriggerId or containerId')
				return;
			} else {
				this.initDiv();
			}
		},
		initDiv: function () {
			var thiz = this,
			htmlStr = '',
			top,
			left,
			len = thiz.opt.limit,
			arr = thiz.getArr(),
			ul = $('<ul class="historyBox"></ul>');
			thiz.contexteasyUIDiv.html('').remove();
			len = len > arr.length ? arr.length : len;
			if (len) {
				for (var i = 0; i < len; i++) {
					ul.append('<li><a data-time="'+ arr[i].time +'">' + arr[i].value + '<span class="delItem"></a></li>');
				}
				ul.append('<li id="clear" style="text-align:center;width:80px;margin:0 auto;padding:5px 0px;cursor:pointer;">ʷ¼</li>');
			}
			thiz.contexteasyUIDiv.append(ul);
			$('body').append(thiz.contexteasyUIDiv);
			top = thiz.$input.offset().top + thiz.$input.height() - 2;
			left = thiz.$input.offset().left - 1;
			thiz.contexteasyUIDiv.css({
				'width': thiz.opt.panelWidth + 'px',
				'position': 'absolute',
				'border': '1px solid #ccc',
				'z-index': '11000',
				'background-color': '#fff',
				'display': 'none',
				'font-size': '12px',
				'overflow-y': 'auto',
				'top': top,
				'left': left,
				'max-height': thiz.opt.maxHeight + 'px'
			});
			thiz.$btn.on('click', function () {
				thiz.setSearchHistoty();
			});
			thiz.$input.on('click', function () {
				thiz.reload();
				thiz.contexteasyUIDiv.show();
			}).blur(function () {
				thiz.contexteasyUIDiv.hide();
			});
			thiz.contexteasyUIDiv.on('mousedown', 'a', function () {
				thiz.$input.val($(this).text());
				thiz.opt.itemClick.call($(this).text());
				thiz.contexteasyUIDiv.hide();
			}).on('mousedown', '#clear', function () {
				thiz.clearHistory();
			});
			ul.on('mousedown','.delItem',function(e){
				e.stopPropagation();
				var item = [];
				item.time = $(this).parent().attr('data-time');
				item.value = $(this).parent().text();
				thiz.deleteItem(item)
			})
		},
		reload: function () {
			var arr = this.getArr(),
			len = this.opt.limit,
			_ul = this.contexteasyUIDiv.find('ul');
			_ul.html('');
			if (arr.length == 0) {
				this.contexteasyUIDiv.css('border', 'none');
				return;
			}
			this.contexteasyUIDiv.css('border', '1px solid #ccc');
			len = len > arr.length ? arr.length : len;
			if (len) {
				for (var i = 0; i < len; i++) {
					_ul.append('<li><a data-time="'+ arr[i].time +'">' + arr[i].value + '<span class="delItem"></span></a></li>');
				}
				_ul.append('<li id="clear" style="text-align:center;width:80px;margin:0 auto;padding:5px 0px;cursor:pointer;">ʷ¼</li>');
			}
			return;
		},
		deleteItem:function(item){
			var _arr = this.getArr();
			var i = _arr.length;
			while (i--) {
				if (_arr[i].time == item.time && _arr[i].value == item.value) {
					_arr.splice(i, 1);
					localStorage.setItem(this.opt.storeKey, JSON.stringify(_arr));
					return
				}
			}
			this.reload();
		},
		getArr: function () {
			var arr = localStorage.getItem(this.opt.storeKey);
			return !!arr ? JSON.parse(arr) : [];
		},
		setSearchHistoty: function () {
			var rs = {},
			arr = this.getArr();
			rs.value = this.$input.val();
			if (rs.value.substr(0, 1) === '*') {
				if (rs.value.substr(rs.value.length - 1, 1) === '*') {
					rs.value = rs.value.substr(1, rs.value.length - 2);
				} else {
					rs.value = rs.value.substr(1, rs.value.length - 1);
				}
			}else if(rs.value.substr(rs.value.length - 1, 1) === '*'){
				rs.value = rs.value.substr(0, rs.value.length - 1);
			}
			rs.time = (new Date()).getTime();
			var f = this.contains(arr, rs.value);
			if (rs.value.trim() != "") {
				if (f.flag) {
					arr.splice(f.idx, 1);
				}
				arr.unshift(rs);
			}
			localStorage.setItem(this.opt.storeKey, JSON.stringify(arr));
			this.reload();
		},
		contains: function (arr, obj) {
			var i = arr.length;
			while (i--) {
				if (arr[i].value.toLowerCase() === obj.toLowerCase()) {
					return {
						flag: true,
						idx: i
					};
				}
			}
			return {
				flag: false
			};
		},
		clearHistory: function () {
			localStorage.removeItem(this.opt.storeKey);
			this.reload();
		}
	};
	$.fn.history = function (opt) {
		return new history(opt || null);
	};
})($, document);