!(function($, win, top) {
	var VIDEOBLOCK = function(options) {
		
		if(!options){throw new Error('ȡƵʧ!'); return ;}
		
		if(!options.serverConnection){throw new Error('serverConnection Ϊ!'); return ;}

		this.$content = null;
		this.title      = '';
		this.hideTitle      = '';
		this.cssClass   = 'num-1';
		this.$baseContainer = $("#video-container"); 
		this.onRightClick = $.noop();
		this.index = 0;
		this.uuid = null;
		this.monid = null;
		this.serverConnection=null;
		this.peerConnection=null;
		this.isRunning=false;
		this.fdId=null;
		this.channelId=null;
		$.extend(this, options);
		
		this.videoId = $.uniqueId();
		
	}
	
	VIDEOBLOCK.prototype.startMonitor=function(fdid,channelid,subid,channelname){
		this.setHideTitle(channelname||this.getHideTitle());
		this.serverConnection.send(JSON.stringify({'startmonitor': {'fdid':fdid||this.getFdId(), 'channelid':channelid||this.getChannelId(), 'subid':( subid || 0)}, 'uuid': channelname||this.uuid}));
	}
	
	VIDEOBLOCK.prototype.init=function(){
		var ts = this ;
		this.$content = $("<div name='video-folder' index="+this.index+" class='"+ts.cssClass+"'></div>");
		this.$content.append("<div class=\"con-head\"><span class=\"icon-currentRecord\"></span>"+ts.title+"</div>"); 
		this.$content.append("<div class='con-content' ondblclick='BlockUtil.fullScreen("+this.index+")'><video  id='"+this.videoId +"' autoplay onplay='BlockUtil.changeBlockStatus("+this.index+");' emptied='alert(\"emptied\")' error='alert(\"error\")' style='width:100%;height:100%;object-fit:fill;' ></video></div>");
		this.$content.append("<div class='con-foot'> <a href='#' class='ahref videohref' onclick='BlockUtil.fullScreen("+this.index+")'>ȫ</a>&nbsp;<a href='#' class='ahref videohref' onclick='BlockUtil.stopMonitor(\""+this.index+"\",this);'>ֹͣ</a>&nbsp;<a href='#' class='ahref videohref' onmousedown='BlockUtil.changeDirection(\""+this.index+"\",\"up\",this);' onmouseup='BlockUtil.stopChangeDirection(\""+this.index+"\",\"up\",this);'></a>&nbsp;<a href='#' class='ahref videohref' onmousedown='BlockUtil.changeDirection(\""+this.index+"\",\"down\",this);' onmouseup='BlockUtil.stopChangeDirection(\""+this.index+"\",\"down\",this);'></a>&nbsp;<a href='#' class='ahref videohref' onmousedown='BlockUtil.changeDirection(\""+this.index+"\",\"left\",this);' onmouseup='BlockUtil.stopChangeDirection(\""+this.index+"\",\"left\",this);'></a>&nbsp;<a href='#' class='ahref videohref' onmousedown='BlockUtil.changeDirection(\""+this.index+"\",\"right\",this);' onmouseup='BlockUtil.stopChangeDirection(\""+this.index+"\",\"right\",this);'></a>&nbsp;</div>");
		this.$content.append('<div class="loading">' +this.index+ '</div>');
		this.$content.bind("click",function(){
			$(this).siblings().find(".con-head").removeClass("current").end().end().find(".con-head").addClass("current");
		});
		this.$content.appendTo(ts.$baseContainer);
		return this;
	}
	
	VIDEOBLOCK.prototype.fullScreen=function(dom){
		dom.requestFullScreen();
	}
	
	
	VIDEOBLOCK.prototype.getIndex=function(undefined){
		return this.index;
	}
	
	VIDEOBLOCK.prototype.getUuId=function(undefined){
		return this.uuid;
	}
	
	VIDEOBLOCK.prototype.getMonId=function(undefined){
		return this.monid;
	}

	VIDEOBLOCK.prototype.setMonId=function(monid){
		this.monid = monid;
		return this;
	}
	
	VIDEOBLOCK.prototype.getFdId=function(undefined){
		return this.fdId;
	}

	VIDEOBLOCK.prototype.setFdId=function(fdId){
		this.fdId = fdId;
		return this;
	}
	
	VIDEOBLOCK.prototype.getChannelId=function(undefined){
		return this.channelId;
	}

	VIDEOBLOCK.prototype.setChannelId=function(channelId){
		this.channelId = channelId - 1 ;
		return this;
	}
	VIDEOBLOCK.prototype.setHideTitle = function(title){
		this.$content.find("div.con-head").eq(0).attr("hidetitle",title);
		return this;
	}
	
	VIDEOBLOCK.prototype.getHideTitle = function(){
		return this.$content.find("div.con-head").eq(0).attr("hidetitle");
	}
	
	
	VIDEOBLOCK.prototype.setTitle = function(title){
		this.$content.find("div.con-head").eq(0).html(title+"<span class=\"icon-currentRecord\"></span>");
		return this;
	}
	
	VIDEOBLOCK.prototype.getTitle = function(){
		return this.$content.find("div.con-head").eq(0).text();
	}
	
	VIDEOBLOCK.prototype.stopMonitor=function(){
		this.serverConnection.send(JSON.stringify({'stopmonitor': {'monid':this.getMonId() }, 'uuid': this.getUuId()}));
		return this;
	}
	
	VIDEOBLOCK.prototype.setPeerConnection=function(peerConnection){
		this.peerConnection = peerConnection;
		return this;
	}
	
	VIDEOBLOCK.prototype.getContent=function(undefined){
		return this.$content;
	}
	
	VIDEOBLOCK.prototype.setRunning=function(f){
		 this.isRunning = !!f;
		 return this;
	}
	
	VIDEOBLOCK.prototype.onloading = function(n){
		this.$content.find("div.loading").show(n||200);
		return this;
	}
	VIDEOBLOCK.prototype.unloading = function(){
		this.$content.find("div.loading").hide(n||200);
		return this;
	}
	
	VIDEOBLOCK.prototype.getVideoComp = function(){
		return this.$content.find("#"+this.videoId)[0];
	}
	
	VIDEOBLOCK.prototype.changeDirection = function(directcode) {
		var ts  = this;
		ts.serverConnection.send(JSON.stringify({'ptzaction': {'fdid':ts.getFdId(), 'channelid':ts.getChannelId(), 'actionid':directcode, 'param1':0, 'param2':0}, 'uuid': ts.getUuId()}));
	}
	VIDEOBLOCK.prototype.stopChangeDirection = function(undefined) {
		var ts  = this;
		ts.serverConnection.send(JSON.stringify({'ptzaction': {'fdid':ts.getFdId(), 'channelid':ts.getChannelId(), 'actionid':0, 'param1':0, 'param2':0}, 'uuid': ts.getUuId()}));
	}
	
	$.videoBlock = function(_) {
		return !$.isEmptyObject(_) ? new VIDEOBLOCK(_) : null;
	};

})(jQuery, window, top);