function LayerBase(seq ,conf){
	conf = conf || {};
	this.config = conf || {};
	this.seq = seq;
 	this.layerType = conf.layerType || -1;
	this.layerName = conf.layerName || "";
    this.isChecked = conf.isChecked || false;
	this.markerArray = [];
	this.markerIndex = {};
	this.markerObj = {};
	this.SelectedMarkerArray = [];
	this.HiddenMarkerArray = [];
	this.showTitle = false;
	this.iconWidth=null;
	this.iconHeight=null;
}

//ȡmarker
LayerBase.prototype.getMarkerBy = function (key) {
	if (this.markerObj)
		return this.markerObj[key] || null;
	return null;
}

//marker
LayerBase.prototype.addMarkerToMarkerObj = function (key, marker) {
	if (this.markerObj) 
		this.markerObj[key] = marker;
}

//abstract method 
LayerBase.prototype.OnMapChange = function(){
	$.showMsg("ͼ㹦δʵ֣");
	return ;
} 
LayerBase.prototype.getLayerSeq = function(){
	return this.seq ;
} 

LayerBase.prototype.setChecked = function(checked){
	if(this.isChecked != checked){
		this.isChecked = checked;
		if(checked){
			this.OnMapChange();
			this.seq == MapConst.LAYER_CHEGPS && PushletData.init();
		}else{
			this.seq == MapConst.LAYER_CHEGPS && PushletData.leave();
			this.removeMarkers();
		}
	}
}

//ɾͼϵĵλ
LayerBase.prototype.removeMarkers=function(){
	
  for(var i=0,len = this.markerArray;i<len.length;i++){
     var marker = this.markerArray[i];
//     if(marker.map) marker.closeInfoWindowHtml();
     MapAPI.removeOverlay(marker);
 }
  this.markerArray.length=0;
};

LayerBase.prototype.closeCurrPopUpHtmlWindow=function() {
	var that = this , currobj = MapMain.getCurrPupUpObject();
	if(currobj && currobj.length){
		var index = that.markerIndex[currobj[1]];
		 try{
			var oldpopupmarker = that.markerArray[index];
			if(oldpopupmarker){
				oldpopupmarker.closeInfoWindowHtml();
				 MapMain.setCurrPupUpObject([]);
			}
		 }catch(ex){}
	}
}

//ƶͼʱ жPopUpwindowǷѾԽ磬
LayerBase.prototype.tryCloseCurrPopUpHtmlWindow=function(data) {
	var that = this, closeCurrPupUpwindow = false;
	if(MapMain.getCurrPupUpObject().length>0){
			var currobj = MapMain.getCurrPupUpObject();
			if( that.getLayerSeq() == currobj[0] ){
				 var id =  currobj[1];
				 if(data && data.length > 0){
					 for(var i = 0 ; i <data.length;i++)
					 {
						if(data[i] && data[i].id && data[i].id == id ){
							closeCurrPupUpwindow = true ;
							break;
						}
					 }
				 }
				 if(! (data && data.length && closeCurrPupUpwindow)){
					 that.closeCurrPopUpHtmlWindow();
				 } 
			}
		} 
}

//ܹڵͼϽжλҴϢ
LayerBase.prototype.locateMarker=function (data) {
 	var lng = data.jd|| 0;
	var lat = data.wd|| 0; 	
	if (lng < 1 || lat < 1) {
		$.showMsg("γȲȷ");
		return;
	}
	if(this.seq == MapConst.LAYER_MONITOR || this.seq == MapConst.LAYER_CHETRAVEL){
		data.id = data.sbbh + '-' +  data.tdbh;
	}
	else if(this.seq == MapConst.LAYER_JKLK){
		data.id = data.lkbh;
	}
	var index = this.markerIndex[data.id];
	if (1*index >= 0) {
		var marker = this.markerArray[index];
    	if(marker){
    		MapAPI.removeOverlay(marker);
    		this.markerArray.splice(index,1);
    	}
	}
	var type = this.layerType;
	if (MapMain.layerDataArray.length) {
		MapMain.RemoveLayerDataArray(type);
	}	
	var marker = this.getMark(data);	
	marker.setZIndex(110);	
	if(!this.showTitle){
		marker.hideTitle();
	}	
	MapMain.setCurrPupUpObject([ this.seq , data.id , data.jd,data.wd ]);	
	var latlng = new Point(lng,lat);
   	MapAPI.centerAndZoom(latlng, top.ditu.mapLevel);   	
	MapAPI.addOverlay(marker);
	console.log(data);
	marker.openInfoWindowHtml(this.createPopUp(data));	
	MapMain.layerDataArray.push([type,marker]);	
	this.markerArray.push(marker); 
    this.markerIndex[data.id] = this.markerArray.length-1;    
    this.HiddenMarkerArray.length = 0 ;
    this.HiddenMarkerArray.push(data.id);     
   	console.log(89)
	return marker;
}
//õͼmarker
LayerBase.prototype.getMark = function(data){};

LayerBase.prototype.getIcon = function(iconPath , width , height){
	var pIcon		=	new Icon(); 
	pIcon.width		=	width;
	pIcon.height	=	height;
	pIcon.image 	= 	iconPath;
	return pIcon ;
};
LayerBase.prototype.getTitle = function(text) {
	return new Title(( text|| "" ), 12, 7, "", "black", '#EBEBEB',"#76A9A9", 1);
};
//ͳһPopUpBaseʵ
LayerBase.prototype.createPopUp = function(data){
	$.showMsg("ͼ㹦δʵ֣");
	return "";
};
LayerBase.prototype.drawMarker=function(data,i){
	var that = this ,marker = this.getMark(data);//μʵ	
	MapAPI.addOverlay(marker);	
	marker.hideTitle();	
	if(this.showTitle){
		marker.showTitle();
	}	
    this.markerArray.push(marker);
    this.markerIndex[data.id]=i;    
	if(LayerBase.isExistsInArray(this.HiddenMarkerArray,data.id)){
		marker.setOpacity(0);
	}
	return marker;
};

LayerBase.getBaseQueryCondition = function(layerseq){
	var obj =  MapMain.getCurrPupUpObject(),rangetModel = MapAPI.getCurrentBoundsLatLng();		
	rangetModel.layerSeq = layerseq;
	rangetModel.mapLevel = MapAPI.getZoomLevel();
	rangetModel.maxLevel = MapAPI.getMaxLevel();
	
	if(obj && obj.length == 4){
		rangetModel.currentPopUpMarkerSeq = obj[0];
		rangetModel.currentPopUpMarkerId  = obj[1];
		rangetModel.popUpMarkerLongitude  	= obj[2];
		rangetModel.popUpMarkerLatitude  	= obj[3];
	}		
	return rangetModel;
}

LayerBase.isExistsInArray = function(array,value,key){
	if(!array || array.length ==0 ) return false;
  	for(var i=0,len = array.length; i<len; i++){
 		if(key){
 	 		if(array[i][key]==value){
 	 			return true;
 	 		}
 		}else{
 			if(array[i]==value){
 	 			return true;
 	 		}
 		}
 	}
	return false;
}


LayerBase.prototype.addMarker = function(data){
	if(this.seq == MapConst.LAYER_JKLK){
		data.id = data.lkbh;
	}
	var index = this.markerIndex[data.id];
	if (!!index) {
		var marker = this.markerArray[index];
    	if(marker){
    		MapAPI.removeOverlay(marker);
    		this.markerArray.splice(index,1);
    	}
	}	
	var marker = this.getMark(data);	
	marker.setZIndex(MapConst.MARKER_ZINDEX_MONITOR);	
	if(!this.showTitle){
		marker.hideTitle();
	}	
	MapAPI.addOverlay(marker);	
	this.markerArray.push(marker);
    this.markerIndex[data.id] = this.markerArray.length-1;	
	return marker;
}