;(function($){
	var panelSwitcher = function(ele, option) {
		this.$el  	  = $(ele);
		this.$picEle  = this.$el.find("a.icon-album");	 
		this.$listEle = this.$el.find("a.icon-table");	
		this.$imgContainer = null;
		this.container = null;
		
		this.setting  = {
			index 			: 1,//ǰĬѡеڼ
			picFunction 	: $.noop(),//ͼƬʽú
			listHolder		: null,
			picHolder		: null,
			listFunction 	: $.noop()//бʽú
		};
		
		this.setting = $.extend(true ,this.setting,option);
		
		if(this.setting.index > 1 ) this.setting.index  = 1;
		
		this.$el.show();
		this.initEvents();
		this.switchType(this.setting.index);
		
	};
	
	panelSwitcher.prototype = {
		constructor	: panelSwitcher,
		getCurrIndex: function(o){
			return  this.$el.find('a').index($(o));
		},
		renderImgContainer : function(){
			var holder =  document.getElementById(this.setting.picHolder);
			this.container = $("#"+this.setting.listHolder).parent(".datagrid-view:eq(0)");
			var defaultHeight = this.container.parent().height();
			var defaultWidth  = this.container.parent().width();
			this.$imgContainer = $("<div class='img-container' style='width:"+
								( defaultWidth+1)+"px;height:"+
								( defaultHeight-38 )+"px;display:none;'></div>").attr("id",this.setting.picHolder).html('<div class="img-box"></div>');
			this.container.after(this.$imgContainer);
			return this;
		},
		initEvents : function(){
			var thiz = this ;
			
			this.$imgContainer  || this.renderImgContainer();
			
			thiz.$picEle.bind('click',function(){
				var currIndex = thiz.getCurrIndex(this);
				thiz.switchType(currIndex);
				thiz.setting.picFunction.call(this);
				thiz.container.css('display','none');
				thiz.$imgContainer.css('display','block');
			});
			
			thiz.$listEle.bind('click',function(){
				var currIndex = thiz.getCurrIndex(this);
				thiz.switchType(currIndex);
				
				thiz.$imgContainer.css('display','none');
				setTimeout(function(){
					thiz.container.css('display','block').height(thiz.$imgContainer.height()).fadeIn(200);
				},0);
			});
			
			return this;
		},
		switchType : function(index){
			this.$el.children('a').removeClass("viewType-curr").eq(index).addClass("viewType-curr");
		},
		renderSwitcher : function(){
		},
		renderData : function(data){
			if(!data){
				return ;
			}
			var i = 0,a = [],img,color,that = this;
			for(; (data.rows[i] && data.rows[i].GROUPNAME) ; i ++){
				
				if(data.rows[i].AREASEQ>1){
					if(data.rows[i].STATUS==1
							&&data.rows[i].DEGRADED==0
							&&data.rows[i].NICSTATE==1){
						img='spare_node.png';
						color="black";
					}else{
						img='spare_node.png';
						color="red";
					}
					
				}else{
					if(data.rows[i].STATUS==1
							&&data.rows[i].DEGRADED==0
							&&data.rows[i].NICSTATE==1){
						img='main_node.png';
						color="black";
					}else{
						img='main_node.png';
						color="red";
					}
				}
				a.push('<div class="view-item">'+
						'<img  src="../common/configbtn/img/'+img+'"><div>'+
						'<p title="'+data.rows[i].GROUPNAME+'" style="color:'+color+';">'+ (data.rows[i].GROUPNAME  || '') +'</p>'+
						'<div title="'+data.rows[i].SIZEUSED+'%" name="'+data.rows[i].SIZEUSED+'" class="img-progressBar"><span>'+data.rows[i].SIZEUSED+'%</span><div style="width:0px">'+
						'</div></div></div></div>');		
				
			}
			if(this.$imgContainer) { 
				this.$imgContainer.find('.img-box').html(a.join(''));
				setTimeout(that.renderProgressBar,1000);
			}
		},
		renderProgressBar : function(){
			$("div.img-progressBar").each(function () {
			    var this_sizeUsed = $(this).attr("name");
			    $(this).children("div").animate({"width":this_sizeUsed+"px"},2000);
			});
		}
	};
	
	$.fn.panelSwitcher = function(option) {
	    return new panelSwitcher(this, option).initEvents();
	};
})($,document);
