package cn.yw.machinemanage.action;


import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.yw.machinemanage.service.YwmachinehistorystateService;

@SuppressWarnings({"all"})
@Component("ywmachinehistorystateAction")
public class YwmachinehistorystateAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(YwmachinehistorystateAction.class);
	
	@Autowired
	private YwmachinehistorystateService service;
	
	/**
	 * ҳ
	 */	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listYwmachinehistorystateByPage")
	public void listYwmachinehistorystateByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listYwmachinehistorystateByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwmachinehistorystateAction-listYwmachinehistorystateByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ywmachinehistorystate")
	public void count_Ywmachinehistorystate(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Ywmachinehistorystate(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwmachinehistorystateAction-count_Ywmachinehistorystate-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ Ywmachinehistorystate
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Ywmachinehistorystate")
	public void query_Ywmachinehistorystate(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Ywmachinehistorystate(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwmachinehistorystateAction-query_Ywmachinehistorystate-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ һYwmachinehistorystate
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Ywmachinehistorystate")
	public void get_Ywmachinehistorystate(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Ywmachinehistorystate(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwmachinehistorystateActionquery_Ywmachinehistorystate-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	

	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Ywmachinehistorystate")
	public void exp_Ywmachinehistorystate(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_Ywmachinehistorystate(map);		
			List<HashMap> expList = new ArrayList<HashMap>();
			for(Map m : sList){
				Map exportMap = new HashMap();
				exportMap.put("yhzh", m.get("yhzh"));
				expList.add((HashMap) exportMap);
			}
			int excelNum = 2;
			ExcelCol[] cells = new ExcelCol[excelNum];
			String[] zdbm = {"yhzh", "yhmc",};
			String[] zdmc = {"û˺", "û"};
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}		
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
        	String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "άʷ״̬-"+dateTime);
			params.put("sheetName", "άʷ״̬");
			params.put("header", "άʷ״̬");	
			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwmachinehistorystateAction-exoprtExcel-error:" +e);
			
		}
	}
	*/
	
	
}
