package cn.bsystem.ptConst.action;

 import cn.bsystem.ptConst.service.XtbbxxService;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;

@SuppressWarnings({"all"})
@Component("xtbbxxAction")
public class XtbbxxAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(XtbbxxAction.class);
	
	@Autowired
	private XtbbxxService service;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listXtbbxxByPage")
	public void listXtbbxxByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listXtbbxxByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("XtbbxxAction-listXtbbxxByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteXtbbxx")
	public void delete_Xtbbxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Xtbbxx(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("XtbbxxAction-delete_Xtbbxx-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Xtbbxx")
	public void insert_Xtbbxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.checkEmpty(map.get("xh"))){
				map.put("xh",StringUtil.getUUID());
			}
			service.insert_Xtbbxx(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("XtbbxxAction-listXtbbxxByPage()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Xtbbxx")
	public void update_Xtbbxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int result = service.update_Xtbbxx(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("XtbbxxAction-update_Xtbbxx-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * Aweb
	 */
	public void restartAweb(){
		try {
			Map cmdMap = new HashMap();
			cmdMap = stopService("impAweb");
			//iLog.info("رշ"+cmdMap);
			cmdMap = startService("impAweb");
			//iLog.info(""+cmdMap);
			Struts2Utils.renderJson(cmdMap);
		} catch (Exception e) {
			//iLog.error("impAwebʧܣ");
			e.printStackTrace();
			iLog.error("XtbbxxAction-restartAweb-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	
	/**
     * 
     * @param serviceName Ҽ ָ- -
     * @return
     * @throws IOException 
     */
    public static Map<String, Object> startService(String serviceName) throws IOException {
        String[] cmdStr = { "cmd", "/C", " net start " + serviceName };
        iLog.info("impAweb: "+Arrays.toString(cmdStr));
        try {
            return execCommand(cmdStr);
        } catch (IOException e) {
        	iLog.error("ʧܣ== "+ e);
            throw e;
        }
    }

    /**
     * رշ
     * @param serviceName Ҽ ָ- -
     * @return
     * @throws IOException 
     */
    public static Map<String, Object> stopService(String serviceName) throws IOException {
        String[] cmdStr = { "cmd", "/C", "net stop " + serviceName }; 
        iLog.info("رimpAweb: "+Arrays.toString(cmdStr));
        try {
            return execCommand(cmdStr);
        } catch (IOException e) {
        	iLog.error("رշʧܣ"+ e);
            throw e;
        }
    }

    private static Map<String, Object> execCommand(String[] cmdStr) throws IOException {
        Process p = null;
        Map<String, Object> map = new HashMap<>();
        try {
            p = Runtime.getRuntime().exec(cmdStr);
            map = printStream(p.getInputStream());
        } catch (IOException e) {
        	iLog.error("ʧܣ"+ e);
            throw e;
        } catch (Exception e) {
        	iLog.error("ȡִнʧܣ"+ e);
            throw e;
        } finally {
            if (p != null) {
                p.destroy();
            }
        }
        return map;
    }
    
    private static Map<String, Object> printStream(InputStream input) throws IOException { 
        InputStreamReader isr = new InputStreamReader(input); 
        BufferedReader br = new BufferedReader(isr);
        Map<String, Object> map = new HashMap<String, Object>();
        String str = null;
        String[] arrStr = null;
        try {
            while ((str = br.readLine()) != null) {
                if (StringUtil.isNotEmpty(str)) {
                    if (str.contains("=")) {
                        arrStr = str.split("=");
                        str = str.endsWith("=") ? "" : arrStr[1];
                        map.put(arrStr[0], str);
                    } else {
                        map.put(str, null);
                    }
                }
            }
        } catch (IOException e) {
            System.err.println("رļʧܣ "+ e);
            throw e;
        } finally {
            try {
                if (br != null) {
                    br.close();
                }
                if (isr != null) {
                    isr.close();
                }
                if (input != null) {
                    input.close();
                }
            } catch (IOException e) {
            	System.err.println("رļʧܣ"+ e);
                throw e;
            }
        }
        return map;
    }
}
