function Map(linkItems) {   
    this.current = undefined;   
    this._size = 0;   
    if(linkItems === false){  
        this.disableLinking();   
    }   
}  
/** 
 * ȡǰmap 
 * @return ǰ 
 */  
Map.noop = function() {   
    return this;   
};   
/** 
 * Ƿ 
 * @return 
 */  
Map.illegal = function() {   
    throw new Error("ǷMapѾ");   
};   
/** 
 *  
 * @param obj 
 * @param foreignKeys 
 * @return 
 */  
Map.from = function(obj, foreignKeys) {   
    var map = new Map;   
    for(var prop in obj) {   
        if(foreignKeys || obj.hasOwnProperty(prop)){  
            map.put(prop, obj[prop]);   
        }   
    }   
    return map;   
};   
/** 
 * map 
 * @return 
 */  
Map.prototype.disableLinking = function() {   
    this.link = Map.noop;   
    this.unlink = Map.noop;   
    this.disableLinking = Map.noop;   
    this.next = Map.illegal;   
    this.key = Map.illegal;   
    this.value = Map.illegal;   
    this.clear = Map.illegal;   
    return this;   
};   
/** 
 * hashֵ 磺number 123 
 * @param value key/value 
 * @return 
 */  
Map.prototype.hash = function(value) {   
    return (typeof value) + ' ' + (value instanceof Object ? (value.__hash || (value.__hash = ++arguments.callee.current)) : value.toString());   
};   
/** 
 * mapĳ 
 * @return 
 */  
Map.prototype.size = function() {   
    return this._size;  
};   
  
Map.prototype.hash.current = 0;   
/** 
 * ͨkeyȡvalue 
 * @param key 
 * @return 
 */  
Map.prototype.get = function(key) {   
    var item = this[this.hash(key)];   
    return item === undefined ? undefined : item.value;   
};   
/** 
 * map 
 * @param key  
 * @param value ֵ 
 * @return 
 */  
Map.prototype.put = function(key, value) {   
    var hash = this.hash(key);   
    if(this[hash] === undefined) {   
        var item = { key : key, value : value };   
        this[hash] = item;   
        this.link(item);   
        ++this._size;   
    }else{  
        this[hash].value = value;  
    }   
    return this;   
};   
/** 
 * ͨkeyɾ 
 * @param key 
 * @return 
 */  
Map.prototype.remove = function(key) {   
    var hash = this.hash(key);   
    var item = this[hash];   
    if(item !== undefined) {   
        --this._size;   
        this.unlink(item);   
        delete this[hash];   
    }   
    return this;   
};   
/** 
 * map 
 * @return 
 */  
Map.prototype.clear = function() {   
    while(this._size){  
        this.remove(this.key());   
    }   
    return this;   
};   
/** 
 *  
 * @param item 
 * @return 
 */  
Map.prototype.link = function(item) {   
    if(this._size == 0) {   
        item.prev = item;   
        item.next = item;   
        this.current = item;   
    }else {   
        item.prev = this.current.prev;   
        item.prev.next = item;   
        item.next = this.current;   
        this.current.prev = item;  
    }   
};   
Map.prototype.unlink = function(item) {   
    if(this._size == 0){   
        this.current = undefined;  
    }else {   
        item.prev.next = item.next;   
        item.next.prev = item.prev;   
        if(item === this.current){  
            this.current = item.next;   
        }   
    }   
};   
/** 
 * ȡһ 
 * @return 
 */  
Map.prototype.next = function() {   
    this.current = this.current.next;   
    return this;  
};   
/** 
 * ȡkey 
 * @return 
 */  
Map.prototype.key = function() {   
    return this.current.key;   
};   
/** 
 * ȡvalue 
 * @return 
 */  
Map.prototype.value = function() {   
    return this.current.value;   
};   

//ltx ϵ㾭 minLng С  
//lty ϵγ maxLat γ   
//rbx µ㾭  maxLng 󾭶 
//rby µγ  minLat Сγ
//row 
//col 
//vdeviceData ͷ
//defaultPoint Ĭϴ
function mapShowByXY(ltx,lty,rbx,rby,row,col,vdeviceData,status){
	//
	var jd  = 0; 
	//γ
	var wd  = 0;
	//ܵͷList
	var vdeviceList = new Array();  
	var vdeviceOnLineList = new Array();
	var vdeviceUnLineList = new Array();
	//ֵ
	var result = {}; 
	//map
	var cell = new Map(); 
	/*
	//ҪĬϴ
	//defaultPointΪ Ϊ丳ֵ100
	if(defaultPoint==null||defaultPoint==""||defaultPoint==undefined||defaultPoint=="null"){
		defaultPoint = 100;
	}
	*/
	//try {
		//еһλ
		var cardinalx = (rbx-ltx)/row;
		//еһλ
		var cardinaly = (lty-rby)/col; 
		//ͷ
		var vdeviceNum = 0 ; 
		var tmpVdeviceData = null;		
		for (var i=0;i<vdeviceData.length;i++ ){			
			tmpVdeviceData = vdeviceData[i];						
			jd = tmpVdeviceData.jd;
			wd  = tmpVdeviceData.wd;
			//жǷڷΧ
			if(jd>=ltx && jd<=rbx && wd>=rby && wd<=lty){
				vdeviceNum++; 
				vdeviceList.push(tmpVdeviceData);
				/*
				//ȫʾ
				if(status == 0){
					break;
				}
				//ȫʾ 
				if(status == 1){
					
				}
				//ʾ߲ʾ
				if(status == 2||tmpVdeviceData.isOnline==1){
					vdeviceOnLineList.push(tmpVdeviceData);
					continue;
				}
				//߲ʾʾ
				if(status == 3||tmpVdeviceData.isOnline==0){
					vdeviceUnLineList.push(tmpVdeviceData);
					continue;
				}				
				*/
				//ͷ
				row = parseInt((jd - ltx) / cardinalx)+1; 
				//ͷ
				col = parseInt((wd - rby) / cardinaly )+1;  
				if(cell.get(row+""+col)==null||cell.get(row+""+col)==""||cell.get(row+""+col)==undefined||cell.get(row+""+col)=="null"){
					var tmp = {};
					tmp.count = 1;
					tmp.vdChannelId = row+""+col;
					tmp.id = tmp.vdChannelId;
					tmp.jd = jd;
					tmp.wd = wd;
					tmp.list = new Array();
					tmp.list.push(tmpVdeviceData);
					cell.put(row+""+col,tmp);
				}else{
					var tmp = cell.get(row+""+col);
					tmp.count = parseInt(tmp.count)+1;
					//alert("=tmp.list="+tmp.list);
					tmp.list.push(tmpVdeviceData);
					cell.put(row+""+col,tmp);
				}
			}else{
				//ڷΧ
			}
		}
		//ΧڵĬʱڸ
		if(vdeviceNum == 0){
			result.showMap = new Map();
		}else{
			result.showMap = cell;
		}
		result.showList = vdeviceList;
		//result.vdeviceOnLineList = vdeviceOnLineList;
		//result.vdeviceUnLineList = vdeviceUnLineList;
	//} catch(e){
		
	//}	
	return result;	
}
//ltx ϵ㾭 minLng С  
//lty ϵγ maxLat γ   
//rbx µ㾭  maxLng 󾭶 
//rby µγ  minLat Сγ
//row 
//col 
//vdeviceData ͷ
//defaultPoint Ĭϴ
function mapShowCaseByXY(ltx,lty,rbx,rby,row,col,vdeviceData,status){
	//
	var jd  = 0; 
	//γ
	var wd  = 0;
	//ܵͷList
	var vdeviceList = new Array();  
	var vdeviceOnLineList = new Array();
	var vdeviceUnLineList = new Array();
	//ֵ
	var result = {}; 
	//map
	var cell = new Map(); 
	/*
	//ҪĬϴ
	//defaultPointΪ Ϊ丳ֵ100
	if(defaultPoint==null||defaultPoint==""||defaultPoint==undefined||defaultPoint=="null"){
		defaultPoint = 100;
	}
	*/
	//try {
		//еһλ
		var cardinalx = (rbx-ltx)/row;
		//еһλ
		var cardinaly = (lty-rby)/col; 
		//ͷ
		var vdeviceNum = 0 ; 
		var tmpVdeviceData = null;		
		for (var i=0;i<vdeviceData.length;i++ ){			
			tmpVdeviceData = vdeviceData[i];						
			jd = tmpVdeviceData.jd;
			wd  = tmpVdeviceData.wd;
			//жǷڷΧ
			if(jd>=ltx && jd<=rbx && wd>=rby && wd<=lty){
				vdeviceNum++; 
				vdeviceList.push(tmpVdeviceData);
				/*
				//ȫʾ
				if(status == 0){
					break;
				}
				//ȫʾ 
				if(status == 1){
					
				}
				//ʾ߲ʾ
				if(status == 2||tmpVdeviceData.isOnline==1){
					vdeviceOnLineList.push(tmpVdeviceData);
					continue;
				}
				//߲ʾʾ
				if(status == 3||tmpVdeviceData.isOnline==0){
					vdeviceUnLineList.push(tmpVdeviceData);
					continue;
				}				
				*/
				//ͷ
				row = parseInt((jd - ltx) / cardinalx)+1; 
				//ͷ
				col = parseInt((wd - rby) / cardinaly )+1;  
				if(cell.get(row+""+col)==null||cell.get(row+""+col)==""||cell.get(row+""+col)==undefined||cell.get(row+""+col)=="null"){
					var tmp = {};
					tmp.count = 1;
					tmp.vdChannelId = row+""+col;
					tmp.caseId = tmpVdeviceData.caseId;
					tmp.jd = jd;
					tmp.wd = wd;
					tmp.list = new Array();
					tmp.list.push(tmpVdeviceData);
					cell.put(row+""+col,tmp);
				}else{
					var tmp = cell.get(row+""+col);
					tmp.count = parseInt(tmp.count)+1;
					//alert("=tmp.list="+tmp.list);
					tmp.list.push(tmpVdeviceData);
					cell.put(row+""+col,tmp);
				}
			}else{
				//ڷΧ
			}
		}
		//ΧڵĬʱڸ
		if(vdeviceNum == 0){
			result.showMap = new Map();
		}else{
			result.showMap = cell;
		}
		result.showList = vdeviceList;
		//result.vdeviceOnLineList = vdeviceOnLineList;
		//result.vdeviceUnLineList = vdeviceUnLineList;
	//} catch(e){
		
	//}	
	return result;	
}