package cn.map.szmap.action;

import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.bean.BeanHelper;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.yw.video.videochannelset.dao.SbtdspsrDao;
import cn.map.szmap.LayerConstant;
import cn.map.szmap.cache.CacheManager;
import cn.map.szmap.cache.ICache;
import cn.map.szmap.cache.impl.MonitorCacheImpl;
import cn.map.szmap.service.SzMapHttpService;

@SuppressWarnings({"all"})
@Component("szMapHttpAction")
public class SzMapHttpAction extends BaseAction{
	private static Log logger = LogFactory.getLog(SzMapHttpAction.class);
	private static final String ENCODING = "gbk";
	
	@Autowired
	private SzMapHttpService service;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="readMenuResource")
	public void readMenuResource(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.readMenuResource());
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("SzMapHttpAction - readMenuResource() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	@OperateType(value = LogConstants.LOG_GET ,info ="getMapPropertyByKey")
	public void getMapPropertyByKey(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String key = map.get("key").toString();
			Struts2Utils.renderJson(this.service.getMapPropertyByKey(key));
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("SzMapHttpAction - readMenuResource() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	@OperateType(value = LogConstants.LOG_GET ,info ="getMapDataByLayerSeq")
	public void getMapDataByLayerSeq(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(CacheManager.getIntance().getCacheLayerDate(map));
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("SzMapHttpAction - getMapDataByLayerSeq() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ͼλʼ
	 * @param map 4key:minLng, minLat, maxLng, maxLat, layerSeq
	 * @return
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="getMapData")
	public void getMapData(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(service.getMapData(map));
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("SzMapHttpAction - getMapData() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ͼλʼ
	 * @param map 4key:minLng, minLat, maxLng, maxLat, layerSeq
	 * @return
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="getMapGridData")
	public void getMapGridData(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(service.getMapGridData(map));
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("SzMapHttpAction - getMapGridData() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѡ
	 * @param map 3key:longitude, latitude, layerSeq
	 * @return
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="getListByPoint")
	public void getListByPoint() {
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(service.getListByPoint(map));
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("SzMapHttpAction - getListByPoint() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * Ȧѡ
	 * @param map 4key:radius, longitude, latitude, layerSeq
	 * @return
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="getListByCircle")
	public  void getListByCircle() {
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(service.getListByCircle(map));
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("SzMapHttpAction - getListByCircle() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѡ
	 * @param map 2key:points,layerSeq
	 * @return
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="getListByLine")
	public  void getListByLine() {
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(service.getListByLine(map));
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("SzMapHttpAction - getListByLine() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѡ
	 * @param map 4key:minLng, minLat, maxLng, maxLat, layerSeq
	 * @return
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="getListByRec")
	public void getListByRec(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(service.getListByRec(map));
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("SzMapHttpAction - getListByRec() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ޸ľγ
	 * @param obj
	 * @return
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="update_sbtd_jwd")
	public void update_sbtd_jwd(){
		Map obj = Struts2Utils.getRequestParameterMap();
		try {
			String result = "";
			SbtdspsrDao sbtdspsrDao  = (SbtdspsrDao)BeanHelper.getBean("sbtdspsrDao");
			if(StringUtil.checkEmpty(obj)){
				result = Constants.ERROR;
			}else{
				if(!StringUtil.checkEmpty(obj.get("sbbh"))&&!StringUtil.checkEmpty(obj.get("sbbh"))){
					Integer ret = sbtdspsrDao.update_Sbtdspsr(obj);
					if(ret == 1){
						ICache iCache = CacheManager.getIntance().getLayer(LayerConstant.LAYER_TYPE_MONITOR.intValue());
						((MonitorCacheImpl)iCache).updateMonitorInfo(obj);
						result = Constants.SUCCESS;
					}else{
						result = Constants.ERROR;
					}
				}
			}
			Struts2Utils.renderJson(result);
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("SzMapHttpService update_sbtd_jwd:" + e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ȡVpMap
	 * @param obj
	 * @return
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="getVpMap")
	public void getVpMap(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(BeanHelper.getModuleConfFactory().getDitu());
		} catch (Exception e) {
			e.printStackTrace();
			logger.error("SzMapHttpAction - getVpMap() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
}
