package cn.yw.machinemanage.service;

 import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;
import cn.yw.machinemanage.dao.YwmachinecurrentstateDao;

@Service("ywmachinecurrentstateService")
public class YwmachinecurrentstateService extends BaseService {
	
	private static Log log = LogFactory.getLog(YwmachinecurrentstateService.class);
	
	@Autowired
	private YwmachinecurrentstateDao ywmachinecurrentstateDao;
	
	/**
	 * ¼
	 */
	/*
	public void insert_Ywmachinecurrentstate(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		ywmachinecurrentstateDao.insert_Ywmachinecurrentstate(map);
	}
	*/

	
	/**
	 * ޸ļ¼
	 */
	public Integer update_Ywmachinecurrentstate(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return ywmachinecurrentstateDao.update_Ywmachinecurrentstate(map);
	}
	
	
	/**
	 * ɾ¼
	 */
	/*
	public Integer delete_Ywmachinecurrentstate(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return ywmachinecurrentstateDao.delete_Ywmachinecurrentstate(map);
	}
	*/
	
	/**
	 * ɾ¼
	 */
	/*
	public Integer batch_delete_Ywmachinecurrentstate(Map map) throws SQLException{
		return ywmachinecurrentstateDao.batch_delete_Ywmachinecurrentstate(map);
	}
	*/
	
	/**
	 * ѯ
	 */
	public Integer count_Ywmachinecurrentstate(Map map) throws SQLException{
		return ywmachinecurrentstateDao.count_Ywmachinecurrentstate(map);
	}
	
	/**
	 * ѯб¼SELECT
	 */
	public List<Map> query_Ywmachinecurrentstate(Map map) throws SQLException{
		return ywmachinecurrentstateDao.query_Ywmachinecurrentstate(map);
	}
	
	/**
	 * ѯһ
	 */
	 
	
	public Map get_Ywmachinecurrentstate(Map map) throws SQLException{
		return ywmachinecurrentstateDao.get_Ywmachinecurrentstate(map);
	}
	/**
	 * ҳͳ
	 * @return
	 * @throws SQLException
	 */
	public Map statisticsMachineOnlineRate() throws SQLException{
		Map<String,Object> result = new HashMap<String,Object>();
		List<Map> list = ywmachinecurrentstateDao.statisticsMachineOnlineRate();
		if(list!=null && list.size()>0){
			for(Map m : list){
				String name = m.get("name")+"";
				result.put(name, m.get("totalcount"));
			}
		}
		return result;
	}
	public Map listStatisticsMachineIntactRate() throws SQLException{
		Map<String,Object> result = new HashMap<String,Object>();
		List<Map> list = ywmachinecurrentstateDao.listStatisticsMachineIntactRate();
		if(list!=null && list.size()>0){
			for(Map m : list){
				String name = m.get("name")+"";
				result.put(name, m.get("totalcount"));
			}
		}
		return result;
	}
	
	/**
	 * EXCEL
	 */
	 
	/*
	public Map exportYwmachinecurrentstate(Map map) throws SQLException{
		return this.listYwmachinecurrentstateByPage(map);
	}
	*/
	
	/**
	 * Ywmachinecurrentstate ҳ
	 */
	public Map listYwmachinecurrentstateByPage(Map map) throws SQLException {
		List<Map> list = ywmachinecurrentstateDao.query_Ywmachinecurrentstate(map);
		Integer totalCount = ywmachinecurrentstateDao.count_Ywmachinecurrentstate(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
	public List<Map> listMachineInfo(Map map) throws SQLException {
		return ywmachinecurrentstateDao.listMachineInfo(map);
	}
}
