package cn.im.ptlxstore.action;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.im.ptlxstore.service.PtlxccqzService;

@SuppressWarnings({"all"})
@Component("ptlxccqzAction")
public class PtlxccqzAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(PtlxccqzAction.class);
	
	@Autowired
	private PtlxccqzService service;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listPtlxccqzByPage")
	public void listPtlxccqzByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listPtlxccqzByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtlxccqzAction - listPtlxccqzByPage() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ptlxccqz")
	public void count_Ptlxccqz(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Ptlxccqz(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtlxccqzAction - count_Ptlxccqz() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ Ptlxccqz
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_Ptlxccqz")
	public void query_Ptlxccqz(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Ptlxccqz(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtlxccqzAction - query_Ptlxccqz() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ һPtlxccqz
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="get_Ptlxccqz")
	public void get_Ptlxccqz(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Ptlxccqz(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtlxccqzAction - query_Ptlxccqz() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deletePtlxccqz")
	public void delete_Ptlxccqz(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Ptlxccqz(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtlxccqzAction - delete_Ptlxccqz() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Ptlxccqz")
	public void insert_Ptlxccqz(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			map.put("zbh", StringUtil.getUUID());
			service.insert_Ptlxccqz(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtlxccqzAction - listPtlxccqzByPage() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Ptlxccqz")
	public void update_Ptlxccqz(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int result = service.update_Ptlxccqz(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtlxccqzAction - update_Ptlxccqz() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Ptlxccqz")
	public void batch_delete_Ptlxccqz(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Ptlxccqz(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtlxccqzAction - batch_delete_Ptlxccqz() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * Excel
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="exoprtExcel")
	public void exoprtExcel(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			map = service.exportPtlxccqz(map);
			ExcelCol[] cells = new ExcelCol[2];
			cells[0] = new ExcelCol();
			cells[0].setColKey("ֶ");
			cells[0].setColName("ֶ");
			cells[1] = new ExcelCol();
			cells[1].setColKey("ֶ");
			cells[1].setColName("ֶ");
			Map params = new HashMap();
			params.put("fileName", "");
			params.put("sheetName", "");
			params.put("header", "");	
			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			iLog.error("PtlxccqzAction - exoprtExcel() : error === " +e);
			e.printStackTrace();
		}
	}
}
