package cn.base.bean;

import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import cn.acx.IcxDacClient;
import cn.amq.safetyhat.AmqSafetyHatAlarmService;
import cn.amq.safetyhat.SafetyHatAlarmDateService;
import cn.amq.traffic.Alarm2AlarmWorkTableService;
import cn.amq.traffic.AmqTrafficEventAlarmService;
import cn.amq.traffic.AmqVdLinkageRecordService;
import cn.amq.traffic.AmqXdPtzDefinedService;
import cn.amq.traffic.AmqXdPtzMovedNotifyService;
import cn.amq.traffic.CacheExecStateDataService;
import cn.amq.traffic.CacheMonitorMovedDataService;
import cn.amq.traffic.PresetPointDateService;
import cn.amq.traffic.TrafficAlarmStateDataService;
import cn.amq.traffic.TrafficEventAlarmStateDataService;
import cn.amq.videotask.AmqVideoTaskAlarmService;
import cn.amq.videotask.VideoTaskAlarmDateService;
import cn.base.conf.ModuleConfFactory;
import cn.bsystem.ptuserrole.dao.PtyhDao;
import cn.im.trafficalarm.dao.TrafficdevicemessagelogDao;
import cn.im.trafficlinkage.dao.TrafficdevicecurrstateDao;
import cn.im.trafficlinkage.dao.TrafficdevicehisstateDao;

@SuppressWarnings("all")
public class BeanHelper implements ApplicationContextAware {
 
	@Autowired
    private static ApplicationContext applicationContext;
    
     
    public static Object getBean(String beanName) {
        return applicationContext.getBean(beanName);
    }
    
	public static Object getBean(Class<?> serviceClass) {
		String serviceName = serviceClass.getSimpleName();
		String serviceId = serviceName.substring(0,1).toLowerCase()+serviceName.substring(1);
 		return applicationContext.getBean(serviceId);
	}
 
    public static <T> T getBean(String beanName, Class<T> clazz) {
        return clazz.cast(getBean(beanName));
    }
    
    @Override
    public void setApplicationContext(ApplicationContext applicationContext)
            throws BeansException {
        this.applicationContext = applicationContext;
    }
    
    public static IcxDacClient getIcxDacClient(){
  		return (IcxDacClient)getBean("IcxDacClient");
  	}
    
    public static ModuleConfFactory getModuleConfFactory(){
  		return (ModuleConfFactory)getBean("moduleConfFactory");
  	}
    
    public static AmqSafetyHatAlarmService getAmqSafetyHatAlarmService() {
		return (AmqSafetyHatAlarmService)getBean("AmqSafetyHatAlarmService");
	}
    public static SafetyHatAlarmDateService getSafetyHatAlarmDateService() {
    	return (SafetyHatAlarmDateService)getBean("SafetyHatAlarmDateService");
    }
    //ԤõλƶϢservice
    public static AmqXdPtzMovedNotifyService getAmqXdPtzMovedNotifyService() {
    	return (AmqXdPtzMovedNotifyService)getBean("amqXdPtzMovedNotifyService");
    }
    //ԤõλϢservice
    public static AmqXdPtzDefinedService getAmqXdPtzDefinedService() {
    	return (AmqXdPtzDefinedService)getBean("amqXdPtzDefinedService");
    }
    //λ״̬
    public static CacheMonitorMovedDataService getCacheMonitorMovedDataService(){
    	return (CacheMonitorMovedDataService)getBean("cacheMonitorMovedDataService");
    }
    //λservice
    public static PresetPointDateService getPresetPointDateService(){
    	return (PresetPointDateService)getBean("presetPointDateService");
    }
    //սͨ¼澯Ϣamqservice
    public static AmqTrafficEventAlarmService getAmqTrafficEventAlarmService() {
		return (AmqTrafficEventAlarmService)getBean("amqTrafficEventAlarmService");
	}
    //ͨ澯¼service
    public static TrafficEventAlarmStateDataService getTrafficEventAlarmStateDataService(){
  		return (TrafficEventAlarmStateDataService)getBean("trafficEventAlarmStateDataService");
  	}
    //Ӧֵظ澯¼service
    public static Alarm2AlarmWorkTableService getAlarm2AlarmWorkTableService(){
    	return (Alarm2AlarmWorkTableService)getBean("alarm2AlarmWorkTableService");
    }
    //ͨ澯¼service
    public static TrafficAlarmStateDataService getTrafficAlarmStateDataService(){
  		return (TrafficAlarmStateDataService)getBean("trafficAlarmStateDataService");
  	}
    //͡Ƶ豸¼Ϣamqservice
    public static AmqVdLinkageRecordService getAmqVdLinkageRecordService() {
		return (AmqVdLinkageRecordService)getBean("amqVdLinkageRecordService");
    }
    //豸ִ״̬
    public static CacheExecStateDataService getCacheExecStateDataService(){
  		return (CacheExecStateDataService)getBean("cacheExecStateDataService");
  	}
    public static TrafficdevicemessagelogDao getTrafficDeviceMessageLogDao() {
		return (TrafficdevicemessagelogDao)getBean("trafficdevicemessagelogDao");
	}
    public static TrafficdevicecurrstateDao getTrafficdevicecurrstateDao() {
		return (TrafficdevicecurrstateDao)getBean("trafficdevicecurrstateDao");
	}
    public static TrafficdevicehisstateDao getTrafficdevicehisstateDao() {
		return (TrafficdevicehisstateDao)getBean("trafficdevicehisstateDao");
	}
    public static AmqVideoTaskAlarmService getAmqVideoTaskAlarmService() {
    	return (AmqVideoTaskAlarmService)getBean("AmqVideoTaskAlarmService");
    }
    public static VideoTaskAlarmDateService getVideoTaskAlarmDateService() {
    	return (VideoTaskAlarmDateService)getBean("VideoTaskAlarmDateService");
    }
    
    public static PtyhDao getPtyhDao() {
		return (PtyhDao)getBean("ptyhDao");
	}
}