package cn.map.szmap.cache;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

import org.apache.log4j.Logger;

import cn.base.util.RHUtil;
import cn.map.szmap.LayerConstant;
import cn.map.szmap.cache.impl.CheGpsLayerImpl;
import cn.map.szmap.cache.impl.JKLKCacheImpl;
import cn.map.szmap.cache.impl.MonitorCacheImpl;
import cn.map.szmap.service.ConfigHelper;

public class CacheManager{
	private static final Logger iLog = Logger.getLogger(CacheManager.class);
	private ConcurrentHashMap<Long, ICache> layerMap = new ConcurrentHashMap<Long, ICache>();
	private final List<Long> cacheKeyList = new ArrayList<Long>();
	private static CacheManager intance = new CacheManager();

	public static CacheManager getIntance() {
		return intance;
	}

	public void init() {
		cacheKeyList.clear();
		iLog.info(ConfigHelper.getInstance().showLayer("szmap.showLayer.showMonitorLayer"));
		if (ConfigHelper.getInstance().showLayer("szmap.showLayer.showMonitorLayer")) {
			layerMap.put(LayerConstant.LAYER_TYPE_MONITOR, new MonitorCacheImpl(LayerConstant.LAYER_TYPE_MONITOR));
		}
		
		if (ConfigHelper.getInstance().showLayer("szmap.showLayer.showMonitorLocationLayer")) {
			layerMap.put(LayerConstant.LAYER_TYPE_MONITORLOCATION, new JKLKCacheImpl(LayerConstant.LAYER_TYPE_MONITORLOCATION));
		}
		
		if (ConfigHelper.getInstance().showLayer("szmap.showLayer.showCheGpsLayer")) {
			layerMap.put(LayerConstant.LAYER_TYPE_CHEGPS, new CheGpsLayerImpl(LayerConstant.LAYER_TYPE_CHEGPS));
		}
	}

	public ICache getLayer(int type) {
		return layerMap.get(Long.valueOf(type));
	}

	public long putDataInCache(Long layerSeq ,List<HashMap> list) {
		if (list == null) {
			return -1;
		}
		
		ICache layer = null;
		iLog.info("layerSeq cache :" + layerSeq +" ,list size:"+ list.size());
		if(layerMap.containsKey( layerSeq)){
			layer = layerMap.get(layerSeq);
			System.out.println(layer.getClass().getName());
			layer.refreshAll(list);
		}
		return layerSeq;
	}

	public ConcurrentHashMap<Long, ICache> getLayCache() {
		return layerMap;
	}
	
	public List<Map> getCacheLayerDate(Map map){
		try {
			Long layerSeq = Long.parseLong(map.get("layerSeq").toString());//Long
			ICache iCache = (ICache)layerMap.get(layerSeq);
			if (RHUtil.isNotEmpty(iCache)) 
				return iCache.getAllData();
		} catch (Exception e) {
			e.printStackTrace();
			iLog.info("CacheManager getCacheLayerDate error:" + e );
		}
		return null;
	}
}
