package cn.base.util;


import org.apache.log4j.Logger;
import java.io.*;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

/**
 * ṩһЩõļصķ
 */
public final class PropertiesUtil {
    public static Logger logger = Logger.getLogger(PropertiesUtil.class);

    /**
     * ϵͳļлȡӦֵ
     *
     * @param key key
     * @return value
     */
    public final static String key(String key) {
        return System.getProperty(key);
    }

    /**
     * KeyȡValue
     *
     * @param filePath ļ
     * @param key      Ҫȡ
     */
    public final static String GetValueByKey(String filePath, String key) {
        Properties pps = new Properties();
        try (InputStream in = new BufferedInputStream(new FileInputStream(filePath))) {
            pps.load(in);
            return pps.getProperty(key);
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public final static Map<String,String> properties(InputStream in){
        Map<String,String> map = new HashMap<>();
        Properties pps = new Properties();
        try {
            pps.load(in);
        } catch (IOException e) {
            logger.error("load properties error:"+e.getMessage());
        }
        Enumeration en = pps.propertyNames();
        while (en.hasMoreElements()) {
            String strKey = (String) en.nextElement();
            String strValue = pps.getProperty(strKey);
            map.put(strKey,strValue);
        }
        return map;
    }
    /**
     * ȡPropertiesȫϢ
     *
     * @param filePath ȡļ
     * @return е key:value<>key:value
     */
    public final static Map<String,String> GetAllProperties(String filePath) throws IOException {
        Map<String,String> map = new HashMap<>();
        Properties pps = new Properties();
        try (InputStream in = new BufferedInputStream(new FileInputStream(filePath))) {
            return properties(in);
        }catch (IOException e){
            logger.error("load properties error");
        }
        return map;
    }

    /**
     * дPropertiesϢ
     *
     * @param filePath дļ
     * @param pKey     
     * @param pValue   ֵ
     */
    public final static void WriteProperties(String filePath, String pKey, String pValue) throws IOException {
        Properties props = new Properties();

        props.load(new FileInputStream(filePath));
        //  Hashtable ķ putʹ getProperty ṩԡ
        // ǿҪΪԵļֵʹֵַ Hashtable  put Ľ
        OutputStream fos = new FileOutputStream(filePath);
        props.setProperty(pKey, pValue);
        // ʺʹ load ص Properties еĸʽ
        //  Properties ебԪضԣд
        props.store(fos, "Update '" + pKey + "' value");

    }

}
