package cn.yw.alarmtaskmanage.action;


import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.DateUtil;
import cn.base.util.LogConstants;
import cn.base.util.RHUtil;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptuserrole.model.PtyhBean;
import cn.yw.alarmtaskmanage.service.YwalarmrulefortimeService;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;

@SuppressWarnings({"all"})
@Component("ywalarmrulefortimeAction")
public class YwalarmrulefortimeAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(YwalarmrulefortimeAction.class);
	
	@Autowired
	private YwalarmrulefortimeService service;
	
	/**
	 * ҳ
	 */
	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listYwalarmrulefortimeByPage")
	public void listYwalarmrulefortimeByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listYwalarmrulefortimeByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmrulefortimeAction-listYwalarmrulefortimeByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ
	 */
	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ywalarmrulefortime")
	public void count_Ywalarmrulefortime(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Ywalarmrulefortime(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmrulefortimeAction-count_Ywalarmrulefortime-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ Ywalarmrulefortime
	 */
	
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Ywalarmrulefortime")
	public void query_Ywalarmrulefortime(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Ywalarmrulefortime(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmrulefortimeAction-query_Ywalarmrulefortime-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ һYwalarmrulefortime
	 */
	
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Ywalarmrulefortime")
	public void get_Ywalarmrulefortime(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Ywalarmrulefortime(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmrulefortimeActionquery_Ywalarmrulefortime-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ɾ
	 */
	
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteYwalarmrulefortime")
	public void delete_Ywalarmrulefortime(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Ywalarmrulefortime(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmrulefortimeAction-delete_Ywalarmrulefortime-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	

	/**
	 * 
	 */
	
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Ywalarmrulefortime")
	public void insert_Ywalarmrulefortime(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhbh();
			String time = DateUtil.getDateTimeStr(new Date());
			map.put("createaccount", username);
			map.put("createtime", time);
			map.put("modifyaccount", username);
			map.put("modifytime", time);
			if(StringUtil.checkEmpty(map.get("timeid"))){
				map.put("timeid",StringUtil.getUUID());
			}
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywalarmrulefortime(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					service.insert_Ywalarmrulefortime(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				service.insert_Ywalarmrulefortime(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmrulefortimeAction-insert_Ywalarmrulefortime()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ޸
	 */
	
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Ywalarmrulefortime")
	public void update_Ywalarmrulefortime(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhbh();
			String time = DateUtil.getDateTimeStr(new Date());
			map.put("modifyaccount", username);
			map.put("modifytime", time);
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywalarmrulefortime(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					int result = service.update_Ywalarmrulefortime(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				int result = service.update_Ywalarmrulefortime(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmrulefortimeAction-update_Ywalarmrulefortime-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	// 
	@OperateType(value = LogConstants.LOG_ADD ,info ="batch_insert")
	public void batch_insert(){
		List paramList = new ArrayList();
		Map map = Struts2Utils.getRequestParameterMap();
//		System.out.println("====map=======: "+map);
		try {
			if(RHUtil.isNotEmpty(map)) {
				String timeid = null;
				String alarmruleid = null;
				String weekday = null;
				String starttime = null;
				String endtime = null;
				String alarmgrade = null;
			
				String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhmc();
				
				String res = map.toString();
//				System.out.println("===res==="+res);
				int first = res.indexOf("{");
				int end = res.lastIndexOf("=}");
				String str = res.substring(first+1,end);
				JSONArray jsonArr = JSONArray.fromObject(str);
				for(int i=0; i<jsonArr.size(); i++) {
					JSONObject json = jsonArr.getJSONObject(i);
					
					if(RHUtil.isNotEmpty(json)) {
						alarmruleid = json.getString("alarmruleid");
						weekday = json.getString("xqj");
						starttime = json.getString("kssj");
						endtime = json.getString("jssj");
						alarmgrade = json.getString("bjjb");
		
						Map daMap = new HashMap();
						daMap.put("timeid", StringUtil.getUUID());
						daMap.put("alarmruleid", alarmruleid);
						daMap.put("weekday", weekday);
						daMap.put("starttime", starttime);
						daMap.put("endtime",endtime);
						daMap.put("alarmgrade", alarmgrade);
						
						daMap.put("createaccount", username);
						daMap.put("modifytime", DateUtil.currentDateTime());
						daMap.put("modifyaccount", username);
						daMap.put("createtime", DateUtil.currentDateTime());
					
						paramList.add(daMap);
					}
				}
				
				this.service.batch_insert_Ywalarmrulefortime(paramList);

				Struts2Utils.renderJson(Constants.SUCCESS);
			}
			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("TrafficdevicerelateAction-road_batch_insert_Trafficdevicerelate()-error:" +e);
			Struts2Utils.renderJson(null);
		}
		
		
	}
	
	
	/**
	 * ɾ
	 */
	/*
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Ywalarmrulefortime")
	public void batch_delete_Ywalarmrulefortime(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Ywalarmrulefortime(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmrulefortimeAction-batch_delete_Ywalarmrulefortime-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	*/
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Ywalarmrulefortime")
	public void exp_Ywalarmrulefortime(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_Ywalarmrulefortime(map);		
			List<HashMap> expList = new ArrayList<HashMap>();
			for(Map m : sList){
				Map exportMap = new HashMap();
				exportMap.put("yhzh", m.get("yhzh"));
				expList.add((HashMap) exportMap);
			}
			int excelNum = 2;
			ExcelCol[] cells = new ExcelCol[excelNum];
			String[] zdbm = {"yhzh", "yhmc",};
			String[] zdmc = {"û˺", "û"};
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}		
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
        	String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "ά澯ʱμ-"+dateTime);
			params.put("sheetName", "ά澯ʱμ");
			params.put("header", "ά澯ʱμ");	
			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwalarmrulefortimeAction-exoprtExcel-error:" +e);
			
		}
	}
	*/
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_IMPORT ,info ="imp_Ywalarmrulefortime")
	public String imp_Ywalarmrulefortime(String excelFile,Object user) {
		String rs = "ʽ!";
		int rowNum = 0;
		int dataCount = 0;
		int successNum = 0;
		int repeatNum = 0;
		int failNum = 0;
		try {
		
			ExcelReader readExcel = new ExcelReader();
			readExcel.openFile(excelFile);
			readExcel.setSheetNum(0);
			int count = readExcel.getRowCount();
			iLog.info("count--->" + count);
			rs = " ݳɹܹ"+ dataCount +",ظ"+repeatNum+"ݣʧ"+failNum+"!";
			File file = new File(excelFile);
			if(file.exists()){
				file.delete();
			}
		} catch (Exception e) {
			if (rowNum > 3) {
				rs = "Դֵ()ʧܣExcel" + rowNum + "δ()ɹ";
			} else {
				rs = "Դ()ʧܣ";
			}
			iLog.error("YwalarmrulefortimeAction-imp_Ywalarmrulefortime-error:" +e);
			e.printStackTrace();
		}		
		return rs;
	}
	*/
	
	 public static void main(String[] args) {
		String aa = "{[{\"kssj\":\"03:00\",\"jssj\":\"04:00\",\"xqj\":2,\"bjjb\":3,\"alarmruleid\":\"27d4db8568d848a4b477d548f35f7b51\"},{\"kssj\":\"03:00\",\"jssj\":\"04:00\",\"xqj\":3,\"bjjb\":3,\"alarmruleid\":\"27d4db8568d848a4b477d548f35f7b51\"},{\"kssj\":\"02:00\",\"jssj\":\"03:00\",\"xqj\":4,\"bjjb\":3,\"alarmruleid\":\"27d4db8568d848a4b477d548f35f7b51\"},{\"kssj\":\"06:00\",\"jssj\":\"07:00\",\"xqj\":5,\"bjjb\":4,\"alarmruleid\":\"27d4db8568d848a4b477d548f35f7b51\"},{\"kssj\":\"06:00\",\"jssj\":\"07:00\",\"xqj\":6,\"bjjb\":4,\"alarmruleid\":\"27d4db8568d848a4b477d548f35f7b51\"}]=}\r\n" ;
		int first = aa.indexOf("{");
		int end = aa.indexOf("=}");
		String str = aa.substring(first+1,end);
		System.out.println(first);
		System.out.println(end);
		System.out.println(str);
		JSONArray jsonArr = JSONArray.fromObject(str);
		for(int i=0; i<jsonArr.size(); i++) {
			JSONObject json = jsonArr.getJSONObject(i);
			String kssj = json.getString("kssj");
			System.out.println(json);
			System.out.println(kssj);
		}
		System.out.println("json");
	}
}
