package cn.amq.videotask;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import cn.amq.basis.AmqBasisEvent;
import cn.amq.basis.AmqConst;
import cn.amq.business.AmqMainPoint;
import cn.amq.peas.VideoTaskAlarmHolder;
import cn.amq.peas.VideoTaskAlarmPeas;
import cn.base.bean.BeanHelper;

/**
 * Ѳ澯Ϣamq
 * 
 * */
public class AmqVideoTaskAlarmService {

static Logger logger = Logger.getLogger(AmqVideoTaskAlarmService.class);
	
	/**
	 * Ѳ澯Ϣ AMQ
	 * return msg 0AMQʧܣ1AMQͳɹ
	 * 
	*/
	public String publishVideoTaskAlarmAction(VideoTaskAlarmHolder holder) {
		String msg = "1";
		try {
			AmqMainPoint.publishJob.publishGeneralEvent(holder, AmqConst.AMQ_SUBJECT_videoTaskAlarm);//AMQϢ
			//logger.info("******AMQϢ******Ѳ澯ϢAMQ澯Ϊ"+holder.getList().size());
		}catch(Exception e) {
			e.printStackTrace();
			msg = "0";
			logger.error("******AMQϢerror******Ѳ澯ϢAMQ쳣澯Ϊ"+holder.getList().size());
		}
		return msg;
	}
	
	/**
	 * ȡ Ѳ澯ϢAMQϢ<br>
	 * return msg 0ʧܣ1ɹ
	 */
	public void doVideoTaskAlarmAction(AmqBasisEvent amqBasisMsg) {
		VideoTaskAlarmHolder entity = (VideoTaskAlarmHolder)amqBasisMsg;
		List<VideoTaskAlarmPeas> list = entity.getList();
		try {
			List<VideoTaskAlarmPeas> list_alarm = new ArrayList<VideoTaskAlarmPeas>();
			VideoTaskAlarmPeas info = null;
			
			for (VideoTaskAlarmPeas peas : list) {
				info = new VideoTaskAlarmPeas();
				info.setGjxh(peas.getGjxh());
				info.setGjbh(peas.getGjbh());
				info.setAlarmEventId(peas.getAlarmEventId());
	 			info.setAlarmRuleName(peas.getAlarmRuleName());
	 			info.setAlarmDeviceName(peas.getAlarmDeviceName());
	 			info.setAlarmDeviceId(peas.getAlarmDeviceId());
	 			info.setChannelNum(peas.getChannelNum());
	 			info.setAlarmGrade(peas.getAlarmGrade());
	 			info.setAlarmReason(peas.getAlarmReason());
	 			info.setAlarmTime(peas.getAlarmTime());
	 			System.out.println("---------------"+info);
	 			list_alarm.add(info);
			}
			// ȫñ澯Ϣ棨͸ǰˣ
			BeanHelper.getVideoTaskAlarmDateService().setVideoTaskAlarmDataList(list_alarm);
		}catch(Exception e) {
			e.printStackTrace();
		}
	}
	
}
