function CheGpsLayer(seq,config){
	
	var gpsCache = {};
	
	this.getGpsObj = function(vdchid){		
		return gpsCache[vdchid] || null;		
	}
	
	this.setGpsObj = function(vdchid,obj){		
		gpsCache[vdchid]  = obj;	
	}
	
	this.getObjGpsTime = function(vdchid,objprop){		 
		if(!gpsCache[vdchid]) return null;		
		return gpsCache[vdchid][objprop] || null;		
	}	
	LayerBase.call(this,seq,config);
}

CheGpsLayer.prototype = Object.create(LayerBase.prototype);  
CheGpsLayer.prototype.OnMapChange = function(){
	if(this.isChecked) this.loadLayerData();
}
CheGpsLayer.prototype.loadLayerData = function(){
	var that = this ,layers = MapToolBar.getLayerCollection();
	if(layers){
		var model = LayerBase.getBaseQueryCondition(that.getLayerSeq());
		$.ajax({
			type:'post',
			dataType : 'json',
			data:model,
			url:'szMapHttpAction!getMapData.do',
			success:function(data){
				that.tryCloseCurrPopUpHtmlWindow(data);
			 	if(data && data.length ){
			 		console.log( "CheGpsLayer data length"+data.length);
			 		var i = 0 ;
			 		that.removeMarkers();
			 		while(data[i] && data[i].id){
				 		var marker = that.drawMarker(data[i], i);
				 		that.setGpsObj(data[i].id, data[i]);
				 		that.addMarkerToMarkerObj(data[i].id, marker);
				 		i++;
			 		}
			 	}
			 }
	    });
	}
	
}

CheGpsLayer.prototype.getMark = function(result,iconSource, withTitle){
	if(!result) return ;
	var pIcon = this.getIcon(iconSource, MapConst.LAYER_ICON_WIDTH ,MapConst.LAYER_ICON_HEIGHT);
	var point=new Point(result.jd,result.wd);	
	var resultMsg = PopUpBase.createChePopUp(result);
	var title = new Title(result.plateNo || '', 12, 7, '', null, null, "", "");
	var markerObj = [ this.seq , result.id , result.jd,result.wd ];	
	var marker = new Marker(point,pIcon) ;
	marker.addListener("click", function () {
		MapMain.setCurrPupUpObject(markerObj);
		marker.openInfoWindowHtml(resultMsg);
	});	
	marker.setZIndex(MapConst.MARKER_ZINDEX_CAR);
	return marker;
}

CheGpsLayer.prototype.createPopUp = function(data){
	  return PopUpBase.createChePopUp(data);
}

CheGpsLayer.prototype.locateMarker=function (data) {
	var id = data.id;
	var marker = this.getMarkerBy(id);
	if (marker) {
		marker.setZIndex(MapConst.MARKER_ZINDEX_CAR);
		marker.hideTitle();
		if(this.showTitle){
			marker.showTitle();
		}
		MapAPI.centerAndZoom(marker.point, top.ditu.mapLevel);
		marker.openInfoWindowHtml(this.createPopUp(data));
		var markerObj = [this.seq, data.id, data.jd, data.wd];
		MapMain.setCurrPupUpObject(markerObj);
	} else {
		$.showMsg("ǰ޷λ뿪ͼ㣡");
		return;
	}
	return marker;
}

CheGpsLayer.prototype.drawMarker=function(data,i){
	var marker = this.getMark(data, MapConst.MARKER_ICON_CHEGPS);	 
	MapAPI.addOverlay(marker);
	marker.hideTitle();	
	if(this.showTitle){
		marker.showTitle();
	}
    this.markerArray.push(marker);
    this.markerIndex[data.id]=i;
	if(LayerBase.isExistsInArray(this.markerHidden,data.id)){
		marker.setOpacity(0);
	}
	return marker;
};


CheGpsLayer.prototype.tryOpenWindowHtml = function(marker, data){
	var pop = MapMain.getCurrPupUpObject();
	if (pop && pop.length > 1 && data.id == pop[1] && this.seq == pop[0]) {
		marker.openInfoWindowHtml(this.createPopUp(data));
	}
};
CheGpsLayer.prototype.tryCloseWindowHtml = function(marker, data){
	var pop = MapMain.getCurrPupUpObject();
	if (pop && pop.length > 1 && data.id == pop[1] && this.seq == pop[0]) {
		marker.closeInfoWindowHtml();
	}
};
//ɾͼϵĵλ
CheGpsLayer.prototype.removeMarkers=function(){
	var markerObj = this.markerObj;
	var pop = MapMain.getCurrPupUpObject();
	for (var key in markerObj) {
		var marker = markerObj[key];
		if (pop && pop.length > 1  && this.seq == pop[0]) {
			marker.closeInfoWindowHtml();
		}
		MapAPI.removeOverlay(marker);
	}
	MapMain.setCurrPupUpObject([]);
	this.markerObj = {};
};