package cn.yw.ywuserrolerelation.action;


import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.yw.ywuserrolerelation.service.YwuserrolerelationService;

@SuppressWarnings({"all"})
@Component("ywuserrolerelationAction")
public class YwuserrolerelationAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(YwuserrolerelationAction.class);
	
	@Autowired
	private YwuserrolerelationService service;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listYwuserrolerelationByPage")
	public void listYwuserrolerelationByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listYwuserrolerelationByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwuserrolerelationAction-listYwuserrolerelationByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * ȡȨ޵
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="getALlUserByPower")
	public void getALlUserByPower(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			
			Struts2Utils.renderJson(this.service.getALlUserByPower());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwuserrolerelationAction-getALlUserByPower-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ywuserrolerelation")
	public void count_Ywuserrolerelation(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Ywuserrolerelation(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwuserrolerelationAction-count_Ywuserrolerelation-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ Ywuserrolerelation
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Ywuserrolerelation")
	public void query_Ywuserrolerelation(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Ywuserrolerelation(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwuserrolerelationAction-query_Ywuserrolerelation-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ һYwuserrolerelation
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Ywuserrolerelation")
	public void get_Ywuserrolerelation(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Ywuserrolerelation(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwuserrolerelationActionquery_Ywuserrolerelation-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteYwuserrolerelation")
	public void delete_Ywuserrolerelation(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Ywuserrolerelation(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwuserrolerelationAction-delete_Ywuserrolerelation-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Ywuserrolerelation")
	public void insert_Ywuserrolerelation(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.checkEmpty(map.get("relationid"))){
				map.put("relationid",StringUtil.getUUID());
			}
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywuserrolerelation(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					service.insert_Ywuserrolerelation(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				service.insert_Ywuserrolerelation(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwuserrolerelationAction-insert_Ywuserrolerelation()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Ywuserrolerelation")
	public void update_Ywuserrolerelation(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywuserrolerelation(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					int result = service.update_Ywuserrolerelation(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				int result = service.update_Ywuserrolerelation(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwuserrolerelationAction-update_Ywuserrolerelation-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	
}
