package cn.yw.machinemanage.service;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import cn.base.bean.BaseService;
import cn.base.util.CommUtils;
import cn.yw.machinemanage.dao.YwmachineinfoDao;

@Service("ywmachineinfoService")
public class YwmachineinfoService extends BaseService {
	
	private static Log log = LogFactory.getLog(YwmachineinfoService.class);
	
	@Autowired
	private YwmachineinfoDao ywmachineinfoDao;
	
	/**
	 * ¼
	 */
	
	public void insert_Ywmachineinfo(Map map) throws SQLException{
//		CommUtils.addParams(map, false);
		ywmachineinfoDao.insert_Ywmachineinfo(map);
	}
	

	
	/**
	 * ޸ļ¼
	 */
	
	public Integer update_Ywmachineinfo(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, false);
		return ywmachineinfoDao.update_Ywmachineinfo(map);
	}
	
	
	/**
	 * ɾ¼
	 */
	
	public Integer delete_Ywmachineinfo(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return ywmachineinfoDao.delete_Ywmachineinfo(map);
	}
	
	
	/**
	 * ɾ¼
	 */
	
	public Integer batch_delete_Ywmachineinfo(Map map) throws SQLException{
		return ywmachineinfoDao.batch_delete_Ywmachineinfo(map);
	}
	
	
	/**
	 * ѯ
	 */
	
	public Integer count_Ywmachineinfo(Map map) throws SQLException{
		return ywmachineinfoDao.count_Ywmachineinfo(map);
	}
	
	
	/**
	 * ѯб¼SELECT
	 */
	
	public List<Map> query_Ywmachineinfo(Map map) throws SQLException{
		return ywmachineinfoDao.query_Ywmachineinfo(map);
	}
	
	
	/**
	 * ѯһ
	 */
	 
	
	public Map get_Ywmachineinfo(Map map) throws SQLException{
		return ywmachineinfoDao.get_Ywmachineinfo(map);
	}
	
	
	/**
	 * EXCEL
	 */
	 
	/*
	public Map exportYwmachineinfo(Map map) throws SQLException{
		return this.listYwmachineinfoByPage(map);
	}
	*/
	
	/**
	 * Ywmachineinfo ҳ
	 */
	
	public Map listYwmachineinfoByPage(Map map) throws SQLException {
		List<Map> list = ywmachineinfoDao.query_Ywmachineinfo(map);
		Integer totalCount = ywmachineinfoDao.count_Ywmachineinfo(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
	
	// 
	public Integer edit_Ywmachineinfo(Map map) throws SQLException{
		return ywmachineinfoDao.edit_Ywmachineinfo(map);
	}
	
//  ҳ    άݿ ͳ
	public Map count_HomepageDeviceCount(Map map) throws SQLException{
		List<Map> list = ywmachineinfoDao.count_HomepageDeviceCount(map);
		Map res = new HashMap();
		if(list != null && list.size()>0) {
			for(Map m : list) {
				String name = (String) m.get("name");
				res.put(name, m.get("zs"));
			}
		}
		return res;
	}
}
