package cn.im.operation;

import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import cn.base.bean.BaseService;

@Service("operationService")
public class OperationService extends BaseService{
	
	@Autowired
	private OperationDao operationDao;
	
	
	// ѯڵ·Ϣҳ	
	public Map getNodeServerStatus(Map obj) throws SQLException{ 
		Map res = new HashMap();
		List<Map> list = operationDao.getNodeServerStatus(obj);
		int totalCount = operationDao.getNodeServerStatusCount(obj);
		res.put("data", list);
		res.put("totalCount", totalCount);
		return res;
	}
	
	// ѯҳ
	public Map query_CaVideoSourcePage(Map map) throws SQLException{ 
		Map resMap = new HashMap();
		List<Map> list = operationDao.query_CaVideoSource(map);
		int totalSize = operationDao.query_CaVideoSourceCount(map);
		
		resMap.put("totalSize", totalSize);
		resMap.put("dataList", list);
		return resMap;
	}
	
	// ѯϢҳ
	public Map getServers(Map obj) throws SQLException{ 
		Map map = new HashMap();
		//	쳣Ϣ
		List<Map> abnormalList = operationDao.getAbnormalServers(obj);
		// 쳣	
		int abnormalCount = operationDao.getAbnormalCameraCount(obj);
		map.put("abnormalService", abnormalList);
		map.put("abnormalCount", abnormalCount);
		// Ϣ
		List<Map> normalList = operationDao.getNormalServers(obj);
		// 	
		int normalCount = operationDao.getNormalCameraCount(obj);
		map.put("normalList", normalList);
		map.put("normalCount",normalCount);
		return map;
	}
	
	// ѯ쳣ҳ
	public Map getAbnormalCamera(Map obj) throws SQLException{ 
		Map map = new HashMap();
		List<Map> list = operationDao.getAbnormalCamera(obj);
		int totalCount = operationDao.getAbnormalCameraCount(obj);
		map.put("abnormalCamera", list);
		map.put("totalCount", totalCount);
		return map;
	}
	
	// ѯҳ
	public Map getNormalCamera(Map obj) throws SQLException{ 
		Map map = new HashMap();
		List<Map> list = operationDao.getNormalCamera(obj);
		int totalCount = operationDao.getNormalCameraCount(obj);
		map.put("abnormalCamera", list);
		map.put("totalCount", totalCount);
		return map;
	}
	
	//  id  type ѯĳһϸϢ
	public Map getServerInfoById(Map obj) throws SQLException{
		String type = (String) obj.get("type");
		Map map = new HashMap();
		if("ҵ".equals(type)) {
			map = operationDao.getServerInfoById(obj);
		}else if("Ƶҵ".equals(type)) {
			map = operationDao.getCaVideoSourceById(obj);
		}
		return map;
	}
}
