package cn.bsystem.ptuserrole.service;

 import cn.bsystem.ptuserrole.dao.PtyhscbfDao;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;

@Service("ptyhscbfService")
public class PtyhscbfService extends BaseService {
	
	private static Log log = LogFactory.getLog(PtyhscbfService.class);
	
	@Autowired
	private PtyhscbfDao ptyhscbfDao;
	
	/**
	 * ¼
	 */
	public void insert_Ptyhscbf(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		ptyhscbfDao.insert_Ptyhscbf(map);
	}

	
	/**
	 * ޸ļ¼
	 */
	public Integer update_Ptyhscbf(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return ptyhscbfDao.update_Ptyhscbf(map);
	}
	
	/**
	 * ɾ¼
	 */
	public Integer delete_Ptyhscbf(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return ptyhscbfDao.delete_Ptyhscbf(map);
	}

	/**
	 * Ptyhscbf ҳ
	 */
	public Map listPtyhscbfByPage(Map map) throws SQLException {
		List<Map> list = ptyhscbfDao.query_Ptyhscbf(map);
		Integer totalCount = ptyhscbfDao.count_Ptyhscbf(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
}
