package cn.yw.nhyw.sbxx.service;

 import cn.yw.nhyw.sbxx.dao.SbxxDao;

import java.sql.SQLException;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import cn.base.bean.BaseService;
import cn.base.util.CommUtils;

@Service("sbxxService")
public class SbxxService extends BaseService {
	
	private static Log log = LogFactory.getLog(SbxxService.class);
	
	@Autowired
	private SbxxDao sbxxDao;
	
	/**
	 * ¼
	 */
	public void insert_Sbxx(Map map) throws SQLException{
		CommUtils.addParams(map, false);
		sbxxDao.insert_Sbxx(map);
	}

	
	/**
	 * ޸ļ¼
	 */
	public Integer update_Sbxx(Map map) throws SQLException{
		CommUtils.validateUpdateParams(map);
		CommUtils.addParams(map, true);
		return sbxxDao.update_Sbxx(map);
	}
	
	/**
	 * ɾ¼
	 */
	public Integer delete_Sbxx(Map map) throws SQLException{
		CommUtils.validateDeleteParams(map);
		return sbxxDao.delete_Sbxx(map);
	}
	
	/**
	 * ɾ¼
	 */
	public Integer batch_delete_Sbxx(Map map) throws SQLException{
		return sbxxDao.batch_delete_Sbxx(map);
	}
	
	/**
	 * ѯ
	 */
	/*
	public Integer count_Sbxx(Map map) throws SQLException{
		return sbxxDao.count_Sbxx(map);
	}
	*/
	
	/**
	 * ѯб¼SELECT
	 */
	public List<Map> query_Sbxx(Map map) throws SQLException{
		return sbxxDao.query_Sbxx(map);
	}
	
	/**
	 * ѯһ
	 */
	 
	/*
	public Map get_Sbxx(Map map) throws SQLException{
		return sbxxDao.get_Sbxx(map);
	}
	*/
	
	/**
	 * EXCEL
	 */
	 
	/*
	public Map exportSbxx(Map map) throws SQLException{
		return this.listSbxxByPage(map);
	}
	*/
	
	/**
	 * Sbxx ҳ
	 */
	public Map listSbxxByPage(Map map) throws SQLException {
		List<Map> list = sbxxDao.query_Sbxx(map);
		Integer totalCount = sbxxDao.count_Sbxx(map);
		map.clear();
		map.put("total", totalCount);
		map.put("rows", list);
		return map;
	}
}
