package cn.yw.machinemanage.action;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.DateUtil;
import cn.base.util.LogConstants;
import cn.base.util.RHUtil;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptuserrole.model.PtyhBean;
import cn.yw.machinemanage.service.YwmachineinfoService;

@SuppressWarnings({"all"})
@Component("ywmachineinfoAction")
public class YwmachineinfoAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(YwmachineinfoAction.class);
	
	@Autowired
	private YwmachineinfoService service;
	
	/**
	 * ҳ
	 */
	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listYwmachineinfoByPage")
	public void listYwmachineinfoByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listYwmachineinfoByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwmachineinfoAction-listYwmachineinfoByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ
	 */
	
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ywmachineinfo")
	public void count_Ywmachineinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Ywmachineinfo(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwmachineinfoAction-count_Ywmachineinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ Ywmachineinfo
	 */
	
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Ywmachineinfo")
	public void query_Ywmachineinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Ywmachineinfo(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwmachineinfoAction-query_Ywmachineinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ һYwmachineinfo
	 */
	
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Ywmachineinfo")
	public void get_Ywmachineinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Ywmachineinfo(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwmachineinfoActionquery_Ywmachineinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ɾ
	 */
	
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteYwmachineinfo")
	public void delete_Ywmachineinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Ywmachineinfo(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwmachineinfoAction-delete_Ywmachineinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	

	/**
	 * 
	 */
	
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Ywmachineinfo")
	public void insert_Ywmachineinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.checkEmpty(map.get("machineid"))){
				map.put("machineid",StringUtil.getUUID());
			}
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhbh();
			String time = DateUtil.getDateTimeStr(new Date());
			map.put("createaccount", username);
			map.put("createtime", time);
			map.put("modifyaccount", username);
			map.put("modifytime", time);
			service.insert_Ywmachineinfo(map);
			Struts2Utils.renderJson(Constants.SUCCESS);		
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwmachineinfoAction-insert_Ywmachineinfo()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ޸
	 */
	
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Ywmachineinfo")
	public void update_Ywmachineinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhbh();
			String time = DateUtil.getDateTimeStr(new Date());
			map.put("modifyaccount", username);
			map.put("modifytime", time);
			
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Ywmachineinfo(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					int result = service.update_Ywmachineinfo(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				int result = service.update_Ywmachineinfo(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwmachineinfoAction-update_Ywmachineinfo-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	// 
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="edit_Ywmachineinfo")
	public void edit_Ywmachineinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String username = ((PtyhBean)Struts2Utils.getSession().getAttribute("userInfo")).getYhbh();
			String time = DateUtil.getDateTimeStr(new Date());
			map.put("modifyaccount", username);
			map.put("modifytime", time);
			String ids = (String) map.get("ids");
			if(RHUtil.isNotEmpty(ids)) {
				String[] keys = ids.split(",");
				map.put("keys", keys);
			}				
			int result = service.edit_Ywmachineinfo(map);
			Struts2Utils.renderJson(Constants.SUCCESS);			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwmachineinfoAction-edit_Ywmachineinfo-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Ywmachineinfo")
	public void batch_delete_Ywmachineinfo(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			String keys = map.get("keyword").toString();
			if(RHUtil.isNotEmpty(keys)) {
				String[] ids = keys.split(",");
				map.put("ids", ids);
			}
			int result = service.batch_delete_Ywmachineinfo(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwmachineinfoAction-batch_delete_Ywmachineinfo-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Ywmachineinfo")
	public void exp_Ywmachineinfo(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_Ywmachineinfo(map);		
			List<HashMap> expList = new ArrayList<HashMap>();
			for(Map m : sList){
				Map exportMap = new HashMap();
				exportMap.put("yhzh", m.get("yhzh"));
				expList.add((HashMap) exportMap);
			}
			int excelNum = 2;
			ExcelCol[] cells = new ExcelCol[excelNum];
			String[] zdbm = {"yhzh", "yhmc",};
			String[] zdmc = {"û˺", "û"};
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}		
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
        	String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "άϢ-"+dateTime);
			params.put("sheetName", "άϢ");
			params.put("header", "άϢ");	
			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwmachineinfoAction-exoprtExcel-error:" +e);
			
		}
	}
	*/
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_IMPORT ,info ="imp_Ywmachineinfo")
	public String imp_Ywmachineinfo(String excelFile,Object user) {
		String rs = "ʽ!";
		int rowNum = 0;
		int dataCount = 0;
		int successNum = 0;
		int repeatNum = 0;
		int failNum = 0;
		try {
		
			ExcelReader readExcel = new ExcelReader();
			readExcel.openFile(excelFile);
			readExcel.setSheetNum(0);
			int count = readExcel.getRowCount();
			iLog.info("count--->" + count);
			rs = " ݳɹܹ"+ dataCount +",ظ"+repeatNum+"ݣʧ"+failNum+"!";
			File file = new File(excelFile);
			if(file.exists()){
				file.delete();
			}
		} catch (Exception e) {
			if (rowNum > 3) {
				rs = "Դֵ()ʧܣExcel" + rowNum + "δ()ɹ";
			} else {
				rs = "Դ()ʧܣ";
			}
			iLog.error("YwmachineinfoAction-imp_Ywmachineinfo-error:" +e);
			e.printStackTrace();
		}		
		return rs;
	}
	*/
	
	// ҳ    άݿ ͳ
	public void count_HomepageDeviceCount(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_HomepageDeviceCount(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("YwmachineinfoAction - count_HomepageDeviceCount - error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
}
