package cn.nhyw.gysgl.action;


import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;
import cn.nhyw.gysgl.service.NhywgysxxService;
import cn.yw.nhyw.nhywjtbxgl.service.NhywjtbxglService;
import cn.yw.nhyw.nhywjtbzgl.service.NhywjtbzglService;
import cn.yw.nhyw.nhywjthlgl.service.NhywjthlglService;
import cn.yw.nhyw.nhywjtledydpgl.service.NhywjtledydpglService;
import cn.yw.nhyw.nhywjtxhdgl.service.NhywjtxhdglService;

@SuppressWarnings({"all"})
@Component("nhywgysxxAction")
public class NhywgysxxAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(NhywgysxxAction.class);
	
	@Autowired
	private NhywgysxxService service;
	@Autowired
	private NhywjtbzglService jtbzService;
	@Autowired
	private NhywjtbxglService jtbxService;
	@Autowired
	private NhywjthlglService jthlService;
	@Autowired
	private NhywjtxhdglService jtxhdService;
	@Autowired
	private NhywjtledydpglService jtydpService;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listNhywgysxxByPage")
	public void listNhywgysxxByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listNhywgysxxByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywgysxxAction-listNhywgysxxByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Nhywgysxx")
	public void count_Nhywgysxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.count_Nhywgysxx(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywgysxxAction-count_Nhywgysxx-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ѯ Nhywgysxx
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="query_Nhywgysxx")
	public void query_Nhywgysxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_Nhywgysxx(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywgysxxAction-query_Nhywgysxx-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	
	/**
	 * ѯ һNhywgysxx
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="get_Nhywgysxx")
	public void get_Nhywgysxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.get_Nhywgysxx(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywgysxxActionquery_Nhywgysxx-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deleteNhywgysxx")
	public void delete_Nhywgysxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Nhywgysxx(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywgysxxAction-delete_Nhywgysxx-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	

	/**
	 * 빩ӦϢ
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Nhywgysxx")
	public void insert_Nhywgysxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.checkEmpty(map.get("xh"))){
				map.put("xh",StringUtil.getUUID());
			}
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Nhywgysxx(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					service.insert_Nhywgysxx(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				service.insert_Nhywgysxx(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}			
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywgysxxAction-insert_Nhywgysxx()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Nhywgysxx")
	public void update_Nhywgysxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!StringUtil.checkEmpty(map.get("checkparam"))){
				Map sMap = new HashMap();
				sMap.put("tableparam", map.get("checkparam"));
				List ls = service.query_Nhywgysxx(sMap);
				if(!StringUtil.checkEmpty(ls)||ls.size()>0){
					Struts2Utils.renderJson(Constants.SAME);
				}else{
					int result = service.update_Nhywgysxx(map);
					Struts2Utils.renderJson(Constants.SUCCESS);
				}
			}else{
				int result = service.update_Nhywgysxx(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywgysxxAction-update_Nhywgysxx-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ѯ  Nhywgysxx ҳ
	 */
	@OperateType(value = LogConstants.LOG_GET ,info ="query_NhywgysxxList")
	public void query_NhywgysxxList(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_NhywgysxxList(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywgysxxActionquery_Nhywgysxx-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * ɾ
	 */
	/*
	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Nhywgysxx")
	public void batch_delete_Nhywgysxx(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Map m = new HashMap();
			m.put("keyword", map.get("keyword").toString());
			int result = service.batch_delete_Nhywgysxx(m);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywgysxxAction-batch_delete_Nhywgysxx-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	*/
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_EXPORT ,info ="exp_Nhywgysxx")
	public void exp_Nhywgysxx(){
		try {
			Map map = Struts2Utils.getRequestParameterMap();
			map.put("start",0 );
			map.put("limit",5000);
			List<Map> sList = service.query_Nhywgysxx(map);		
			List<HashMap> expList = new ArrayList<HashMap>();
			for(Map m : sList){
				Map exportMap = new HashMap();
				exportMap.put("yhzh", m.get("yhzh"));
				expList.add((HashMap) exportMap);
			}
			int excelNum = 2;
			ExcelCol[] cells = new ExcelCol[excelNum];
			String[] zdbm = {"yhzh", "yhmc",};
			String[] zdmc = {"û˺", "û"};
			for(int i=0;i<excelNum;i++){
				cells[i] = new ExcelCol();
				cells[i].setColKey(zdbm[i]);
				cells[i].setColName(zdmc[i]);
			}		
			SimpleDateFormat formart = new SimpleDateFormat("yyyy-MM-dd");   
        	String dateTime=formart.format(new Date()); 
			Map params = new HashMap();
			params.put("fileName", "ӦϢ-"+dateTime);
			params.put("sheetName", "ӦϢ");
			params.put("header", "ӦϢ");	
			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywgysxxAction-exoprtExcel-error:" +e);
			
		}
	}
	*/
	
	/**
	 * Excel
	 */
	/*
	//@OperateType(value = LogConstants.LOG_IMPORT ,info ="imp_Nhywgysxx")
	public String imp_Nhywgysxx(String excelFile,Object user) {
		String rs = "ʽ!";
		int rowNum = 0;
		int dataCount = 0;
		int successNum = 0;
		int repeatNum = 0;
		int failNum = 0;
		try {
		
			ExcelReader readExcel = new ExcelReader();
			readExcel.openFile(excelFile);
			readExcel.setSheetNum(0);
			int count = readExcel.getRowCount();
			iLog.info("count--->" + count);
			rs = " ݳɹܹ"+ dataCount +",ظ"+repeatNum+"ݣʧ"+failNum+"!";
			File file = new File(excelFile);
			if(file.exists()){
				file.delete();
			}
		} catch (Exception e) {
			if (rowNum > 3) {
				rs = "Դֵ()ʧܣExcel" + rowNum + "δ()ɹ";
			} else {
				rs = "Դ()ʧܣ";
			}
			iLog.error("NhywgysxxAction-imp_Nhywgysxx-error:" +e);
			e.printStackTrace();
		}		
		return rs;
	}
	*/
	
	
	// ѯӦϢӼ
	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_dzsbjh")
	public void query_dzsbjh(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			List<Map> list = service.query_dzsbjh(map);
			Integer totalCount = service.count_dzsbjh(map);
			map.clear();
			map.put("total", totalCount);
			map.put("rows", list);
			Struts2Utils.renderJson(map);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywgysxxAction-query_dzsbjh-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	//Ӧ̵Ϣ   ȫϢ  ѡļϢ
	public void query_All_Chosed_Set() {
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			List<Map> list = service.query_All_Chosed_Set(map);
			Integer totalCount = service.count_All_Chosed_Set(map);
			map.clear();
			map.put("total", totalCount);
			map.put("rows", list);
			Struts2Utils.renderJson(map);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywgysxxAction-query_All_Chosed_Set-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	// Ӧ̵Ϣ 
	public void query_Jtsb() {
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			List<Map> list = service.query_Jtsb(map);
			Integer totalCount = service.count_Jtsb(map);
			map.clear();
			map.put("total", totalCount);
			map.put("rows", list);
			Struts2Utils.renderJson(map);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywgysxxAction-query_Jtsb-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	
	// Ӧ -- ͨ豸
	public void query_JtsbByType() {
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );			
			List<Map> list = service.query_Jtsb(map);
			Integer totalCount = service.count_Jtsb(map);
			map.clear();
			map.put("total", totalCount);
			map.put("rows", list);
			Struts2Utils.renderJson(map);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywgysxxAction-query_JtsbByType-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	// Ӧ -- ͨ豸
	public void update_JtsbByType() {
		Map map = Struts2Utils.getRequestParameterMap();
		try {
						
			String type = (String) map.get("type");
			
			if("1".equals(type)) {									//־
				jtbzService.update_Nhywjtbzgl(map);
 			}else if("2".equals(type)) {							//
				jtbxService.update_Nhywjtbxgl(map);
			}else if("3".equals(type)) {							//
				 jthlService.update_Nhywjthlgl(map);
			}else if("4".equals(type)) {							//źŵ
				 jtxhdService.update_Nhywjtxhdgl(map);
			}else if("5".equals(type)) {							//յ
				 jtydpService.update_Nhywjtledydpgl(map);
			}

			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("NhywgysxxAction-query_JtsbByType-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
}
