package cn.bsystem.ptuserrole.action;

 import cn.bsystem.ptuserrole.service.PtyhhmdlService;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.excel.ExcelCol;
import cn.base.excel.ExportEngine;
import cn.base.util.CommUtils;
import cn.base.util.Constants;
import cn.base.util.LogConstants;
import cn.base.util.StringUtil;
import cn.base.util.Struts2Utils;

@SuppressWarnings({"all"})
@Component("ptyhhmdlAction")
public class PtyhhmdlAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(PtyhhmdlAction.class);
	
	@Autowired
	private PtyhhmdlService service;
	
	/**
	 * ҳ
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="listPtyhhmdlByPage")
	public void listPtyhhmdlByPage(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
			map.put("start",start );
			map.put("limit",rows );
			Struts2Utils.renderJson(this.service.listPtyhhmdlByPage(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhhmdlAction-listPtyhhmdlByPage-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ɾ
	 */
	@OperateType(value = LogConstants.LOG_DELETE ,info ="deletePtyhhmdl")
	public void delete_Ptyhhmdl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(!CommUtils.isEmpty(map)){
				int result = service.delete_Ptyhhmdl(map);
				Struts2Utils.renderJson(Constants.SUCCESS);
			}else{
				 throw new Exception("ȷѡɾ¼!!!");
			}
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhhmdlAction-delete_Ptyhhmdl-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}

	/**
	 * 
	 */
	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Ptyhhmdl")
	public void insert_Ptyhhmdl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			if(StringUtil.checkEmpty(map.get("yhzh"))){
				map.put("yhzh",StringUtil.getUUID());
			}
			service.insert_Ptyhhmdl(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhhmdlAction-listPtyhhmdlByPage()-error:" +e);
			Struts2Utils.renderJson(null);
		}
	}
	
	/**
	 * ޸
	 */
	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Ptyhhmdl")
	public void update_Ptyhhmdl(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			int result = service.update_Ptyhhmdl(map);
			Struts2Utils.renderJson(Constants.SUCCESS);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("PtyhhmdlAction-update_Ptyhhmdl-error: " +e);
			Struts2Utils.renderJson(null);
		}
	}
}
