package cn.bsystem.ptmenu.action;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import cn.base.aspect.OperateType;
import cn.base.bean.BaseAction;
import cn.base.bean.BeanHelper;
import cn.base.util.LogConstants;
import cn.base.util.Struts2Utils;
import cn.bsystem.ptmenu.model.MenuNode;
import cn.bsystem.ptmenu.service.MenuRoleService;
import cn.bsystem.ptmenu.util.MenuXml;
import cn.bsystem.ptuserrole.model.PtyhBean;

@SuppressWarnings({"all"})
@Component("menuRoleAction")
public class MenuRoleAction extends BaseAction{
	private static final long serialVersionUID = 1L;
	private static Logger iLog = Logger.getLogger(MenuRoleAction.class);
	
	@Autowired
	private MenuRoleService service;
	
	public String getUserFirstMenuNode(){
		try {
			Map map = new HashMap();
			PtyhBean userInfo =  (PtyhBean) Struts2Utils.getSession().getAttribute("userInfo");
			//String userId = userInfo.getYhbh();
			String projName = MenuXml.getInstance().getMenuType();
			map.put("yhbh", userInfo.getYhbh());
			if(StringUtils.isNotBlank(projName)){
				map.put("projName", projName);
			}else{
				throw new Exception("menu.xmlöӦmenuType!");
			}
			//List result = getFirstMenuNode() ;//service.getCurrentUserOfTopMenuList(map);
			//Struts2Utils.renderDeepJson(result);
			/*  ޸Ȩ
			List items = MenuXml.getInstance().getFirstMenuNode();
			items = MenuXml.getInstance().menuNodeFilter(items);
			Struts2Utils.renderDeepJson(items);
			*/
			List result =service.query_PtcdjsqxByYhbh(map);
			Struts2Utils.renderDeepJson(result);
		} catch (Exception e) {
			iLog.error("getCurrentUserOfTopMenuList"+e);
			e.printStackTrace();
			Struts2Utils.renderText(e.getMessage());
		}
		return null;
	}
	
	public void getFirstMenuNode(){
		List<MenuNode> items = MenuXml.getInstance().getFirstMenuNode();
		items = MenuXml.getInstance().menuNodeFilter(items);
		Struts2Utils.renderJson(items);
	}
	
	public void getSecondMenuNodeByFirstId(){
		List<MenuNode> items = MenuXml.getInstance().geSecondMenuNodeByFirstId(Struts2Utils.getParameter("menuId"));
		items = MenuXml.getInstance().menuNodeFilter(items);
		Struts2Utils.renderJson(items);
	}
	
	public void getThirdMenuNodeBySecond(){
		List<MenuNode> items = MenuXml.getInstance().geThirdMenuNodeBySecond(Struts2Utils.getParameter("menuId"));
		items = MenuXml.getInstance().menuNodeFilter(items);
		Struts2Utils.renderJson(items);
	}
	
	public void getProjectMenuType(){
		Struts2Utils.renderText(MenuXml.getInstance().getMenuType());
	}
	
	/**
	 * ȡǰûв˵
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_ptyhmenu")
	public void query_ptyhmenu(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			Struts2Utils.renderJson(this.service.query_ptyhmenu(map));
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("MenuRoleAction - query_Ptyhcdjs() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	/**
	 * ȡǰûв˵
	 */
	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_allMenuFromXML")
	public void query_ptyhAllMenu(){
		Map map = Struts2Utils.getRequestParameterMap();
		try {
			List list = this.service.query_allMenuFromXML(map);
			Struts2Utils.renderJson(list);
		} catch (Exception e) {
			e.printStackTrace();
			iLog.error("MenuRoleAction - query_Ptyhcdjs() : error === " +e);
			Struts2Utils.renderJson(null);
		}
	}
	
//	/**
//	 * ҳ
//	 */
//	@OperateType(value = LogConstants.LOG_QUERY ,info ="listPtyhcdjsByPage")
//	public void listPtyhcdjsByPage(){
//		Map map = Struts2Utils.getRequestParameterMap();
//		try {
//			int page = Integer.parseInt(Struts2Utils.getParameter("page"));
//			int rows = Integer.parseInt(Struts2Utils.getParameter("rows"));
//			int start = ( (page == 0 ?  1 : page ) - 1) * rows ;
//			int limit =  start+rows ;
//			map.put("start",start );
//			map.put("limit",limit );
//			Struts2Utils.renderJson(this.service.listPtyhcdjsByPage(map));
//		} catch (Exception e) {
//			e.printStackTrace();
//			iLog.error("MenuRoleAction - listPtyhcdjsByPage() : error === " +e);
//			Struts2Utils.renderJson(null);
//		}
//	}
//	
//	/**
//	 * ѯ
//	 */
//	@OperateType(value = LogConstants.LOG_QUERY ,info ="count_Ptyhcdjs")
//	public void count_Ptyhcdjs(){
//		Map map = Struts2Utils.getRequestParameterMap();
//		try {
//			Struts2Utils.renderJson(this.service.count_Ptyhcdjs(map));
//		} catch (Exception e) {
//			e.printStackTrace();
//			iLog.error("MenuRoleAction - count_Ptyhcdjs() : error === " +e);
//			Struts2Utils.renderJson(null);
//		}
//	}
//	
//	/**
//	 * ѯ Ptyhcdjs
//	 */
//	@OperateType(value = LogConstants.LOG_QUERY ,info ="query_Ptyhcdjs")
//	public void query_Ptyhcdjs(){
//		Map map = Struts2Utils.getRequestParameterMap();
//		try {
//			Struts2Utils.renderJson(this.service.query_Ptyhcdjs(map));
//		} catch (Exception e) {
//			e.printStackTrace();
//			iLog.error("MenuRoleAction - query_Ptyhcdjs() : error === " +e);
//			Struts2Utils.renderJson(null);
//		}
//	}
//	
//	/**
//	 * ѯ һPtyhcdjs
//	 */
//	@OperateType(value = LogConstants.LOG_QUERY ,info ="get_Ptyhcdjs")
//	public void get_Ptyhcdjs(){
//		Map map = Struts2Utils.getRequestParameterMap();
//		try {
//			Struts2Utils.renderJson(this.service.get_Ptyhcdjs(map));
//		} catch (Exception e) {
//			e.printStackTrace();
//			iLog.error("MenuRoleAction - query_Ptyhcdjs() : error === " +e);
//			Struts2Utils.renderJson(null);
//		}
//	}
//	
//	/**
//	 * ɾ
//	 */
//	@OperateType(value = LogConstants.LOG_DELETE ,info ="deletePtyhcdjs")
//	public void delete_Ptyhcdjs(){
//		Map map = Struts2Utils.getRequestParameterMap();
//		try {
//			if(!CommUtils.isEmpty(map)){
//				int result = service.delete_Ptyhcdjs(map);
//				Struts2Utils.renderJson(Constants.SUCCESS);
//			}else{
//				 throw new Exception("ȷѡɾ¼!!!");
//			}
//		} catch (Exception e) {
//			e.printStackTrace();
//			iLog.error("MenuRoleAction - delete_Ptyhcdjs() : error === " +e);
//			Struts2Utils.renderJson(null);
//		}
//	}
//	
//
//	/**
//	 * 
//	 */
//	@OperateType(value = LogConstants.LOG_ADD ,info ="insert_Ptyhcdjs")
//	public void insert_Ptyhcdjs(){
//		Map map = Struts2Utils.getRequestParameterMap();
//		try {
//			service.insert_Ptyhcdjs(map);
//			Struts2Utils.renderJson(Constants.SUCCESS);
//		} catch (Exception e) {
//			e.printStackTrace();
//			iLog.error("MenuRoleAction - listPtyhcdjsByPage() : error === " +e);
//			Struts2Utils.renderJson(null);
//		}
//	}
//	
//	/**
//	 * ޸
//	 */
//	@OperateType(value = LogConstants.LOG_UPDATE ,info ="update_Ptyhcdjs")
//	public void update_Ptyhcdjs(){
//		Map map = Struts2Utils.getRequestParameterMap();
//		try {
//			int result = service.update_Ptyhcdjs(map);
//			Struts2Utils.renderJson(Constants.SUCCESS);
//		} catch (Exception e) {
//			e.printStackTrace();
//			iLog.error("MenuRoleAction - update_Ptyhcdjs() : error === " +e);
//			Struts2Utils.renderJson(null);
//		}
//	}
//	
//	/**
//	 * ɾ
//	 */
//	@OperateType(value = LogConstants.LOG_DELETE ,info ="batch_delete_Ptyhcdjs")
//	public void batch_delete_Ptyhcdjs(){
//		Map map = Struts2Utils.getRequestParameterMap();
//		try {
//			Map m = new HashMap();
//			m.put("keyword", map.get("keyword").toString());
//			int result = service.batch_delete_Ptyhcdjs(m);
//			Struts2Utils.renderJson(Constants.SUCCESS);
//		} catch (Exception e) {
//			e.printStackTrace();
//			iLog.error("MenuRoleAction - batch_delete_Ptyhcdjs() : error === " +e);
//			Struts2Utils.renderJson(null);
//		}
//	}
//	
//	
//	/**
//	 * Excel
//	 */
//	@OperateType(value = LogConstants.LOG_QUERY ,info ="exoprtExcel")
//	public void exoprtExcel(){
//		try {
//			Map map = Struts2Utils.getRequestParameterMap();
//			map.put("start",0 );
//			map.put("limit",5000);
//			map = service.exportPtyhcdjs(map);
//			ExcelCol[] cells = new ExcelCol[2];
//			cells[0] = new ExcelCol();
//			cells[0].setColKey("ֶ");
//			cells[0].setColName("ֶ");
//			cells[1] = new ExcelCol();
//			cells[1].setColKey("ֶ");
//			cells[1].setColName("ֶ");
//			Map params = new HashMap();
//			params.put("fileName", "");
//			params.put("sheetName", "");
//			params.put("header", "");	
//			new ExportEngine().exportCommData(params, cells, (ArrayList)map.get("rows"), Struts2Utils.getResponse());
//		} catch (Exception e) {
//			iLog.error("MenuRoleAction - exoprtExcel() : error === " +e);
//			e.printStackTrace();
//		}
//	}
}
