package cn.amq.traffic;

import java.util.ArrayList;
import java.util.List;

import org.apache.commons.lang.xwork.StringUtils;
import org.apache.log4j.Logger;

import cn.amq.basis.AmqBasisEvent;
import cn.amq.basis.AmqConst;
import cn.amq.business.AmqMainPoint;
import cn.amq.peas.XdPtzMovedNotifyHolder;
import cn.amq.peas.XdPtzMovedNotifyPeas;
import cn.base.bean.BeanHelper;
/**
 * Ԥõλƶ֪ͨamq
 * */
public class AmqXdPtzMovedNotifyService {

	static Logger logger = Logger.getLogger(AmqXdPtzMovedNotifyService.class);
	
	/**
	 * ԤõλϢ AMQ
	 */
	public void publishXdPtzMovedNotifyAction(List<XdPtzMovedNotifyPeas> list) {
		XdPtzMovedNotifyHolder holder = new XdPtzMovedNotifyHolder();
		holder.setList(list);
		AmqMainPoint.publishJob.publishGeneralEvent(holder, AmqConst.AMQ_SUBJECT_xdPtzMovedNotify);//ԤõλϢ
	}
	
	/**
	 * ԤõλϢamq
	 * @param amqBasisMsg
	 */
	public void doAmqXdPtzMovedNotifyServiceAction(AmqBasisEvent amqBasisMsg) {
		XdPtzMovedNotifyHolder holder = (XdPtzMovedNotifyHolder) amqBasisMsg;
		List<XdPtzMovedNotifyPeas> list = holder.getList();
		if(list!=null && list.size()>0){
//			logger.info("λ֪ͨ,λλ"+list.size());
			List<XdPtzMovedNotifyPeas> l = new ArrayList<XdPtzMovedNotifyPeas>();
			for(int i=0;i<list.size();i++){
				String key = list.get(i).getSbbh()+"-"+(list.get(i).getTdbh()+1);
				String zt = String.valueOf(list.get(i).getZt());
				if(StringUtils.isEmpty(zt)){
					continue;
				}
				if(BeanHelper.getCacheMonitorMovedDataService().getCacheMonitorMovedDataMap().get(key)==null){
					//ûлλϢ
					l.add(list.get(i));
					BeanHelper.getCacheMonitorMovedDataService().setCacheMonitorMovedDataMap(key, zt);
				}else if(!zt.equals(BeanHelper.getCacheMonitorMovedDataService().getCacheMonitorMovedDataMap().get(key))){
					//λϢ䶯λ->ָ ָ->λ
					l.add(list.get(i));
					BeanHelper.getCacheMonitorMovedDataService().setCacheMonitorMovedDataMap(key, zt);
				}
			}
			BeanHelper.getPresetPointDateService().setPresetPointDataList(l);
		}
		
	}
	
}
