package im.zhaojun.system.controller;

import im.zhaojun.common.annotation.OperationLog;
import im.zhaojun.common.shiro.ShiroActionProperties;
import im.zhaojun.common.util.ResultBean;
import im.zhaojun.common.util.TreeUtil;
import im.zhaojun.system.model.Dept;
import im.zhaojun.system.model.DeptVideo;
import im.zhaojun.system.service.DeptService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.UUID;

@Controller
@RequestMapping("/dept")
public class DeptController {

    @Resource
    private DeptService deptService;

    @Resource
    private ShiroActionProperties shiroActionProperties;

    @Value("${managername}")
    private String managername;



    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");

    @GetMapping("/index")
    public String index() {
        return "dept/dept-list";
    }

    @OperationLog("获取部门列表")
    @GetMapping("/list")
    @ResponseBody
    public ResultBean getList(@RequestParam(value="parentId",required = false) Integer parentId) {
        List<Dept> deptList = deptService.selectByParentId(parentId);
        return ResultBean.success(deptList);
    }

    @GetMapping("/tree/root")
    @ResponseBody
    public ResultBean treeAndRoot() {
        return ResultBean.success(deptService.selectAllTreeAndRoot());
    }

    @GetMapping("/tree")
    @ResponseBody
    public ResultBean tree() {
        return ResultBean.success(deptService.selectAllTree());
    }

    @GetMapping
    public String add() {
        return "dept/dept-add";
    }

    @OperationLog("新增部门")
    @ResponseBody
    @RequestMapping(value = "/add", method = RequestMethod.POST)
    public ResultBean add(Dept dept) {
        if(null==dept.getDeptId() ||dept.getDeptId().equals(""))
        {
            dept.setDeptId(deptService.selectMaxOrderNum()+1);
        }
        dept.setCreateTime(sdf.format(new Date()));
        dept.setModifyTime(dept.getCreateTime());
        return ResultBean.success(deptService.insert(dept));
    }

    @OperationLog("删除部门")
    @DeleteMapping("/{deptId}")
    @ResponseBody
    public ResultBean delete(@PathVariable("deptId") Integer deptId) {
        deptService.deleteCascadeByID(deptId);
        return ResultBean.success();
    }

    @OperationLog("修改部门")
    @ResponseBody
    @RequestMapping(value = "/update", method = RequestMethod.POST)
    public ResultBean update(Dept dept) {
        dept.setModifyTime(sdf.format(new Date()));
        deptService.updateByPrimaryKey(dept);
        return ResultBean.success();
    }

    @GetMapping("/{deptId}")
    public ResultBean update(@PathVariable("deptId") String deptId) {
        List<Map> dept = deptService.selectByPrimaryKey(deptId);
        return ResultBean.success(dept);
    }


    @GetMapping("/getDeptParent/{deptId}")
    @ResponseBody
    public ResultBean getDeptParent(@PathVariable("deptId") String deptId) {
        List<Map> dept = deptService.selectByPrimaryKey(deptId);
        return ResultBean.success(dept);
    }

    @OperationLog("调整部门排序")
    @PostMapping("/swap")
    @ResponseBody
    public ResultBean swapSort(Integer currentId, Integer swapId) {
        deptService.swapSort(currentId, swapId);
        return ResultBean.success();
    }


    @OperationLog("查询部门及監控")
    @GetMapping("/listvideo")
    @ResponseBody
    public ResultBean listvideo( @RequestParam("deptId") String  deptId,@RequestParam("username") String username,@RequestParam("tdmc")String tdmc) {
        if (null!=username && (shiroActionProperties.getSuperAdminUsername().equals(username)
                ||username.equalsIgnoreCase(managername))) {
            deptId = "0";
            username=null;
        }
        List<DeptVideo> deptlist=deptService.listvideo(deptId, username,tdmc);
       return ResultBean.success(deptlist);
    }


    @OperationLog("查询部门及監控")
    @GetMapping("/listvideotree")
    @ResponseBody
    public ResultBean listvideotree( @RequestParam("deptId") String  deptId,@RequestParam("username") String username,@RequestParam("tdmc")String tdmc) {
        if (null!=username && (shiroActionProperties.getSuperAdminUsername().equals(username)
                ||username.equalsIgnoreCase(managername))) {
            deptId = "0";
            username=null;
        }
        List<DeptVideo> deptlist=deptService.listvideo(deptId, username,tdmc);
        List<DeptVideo> list= TreeUtil.toTree(deptlist,"deptId","parentId","nodes",DeptVideo.class,deptId);
        return ResultBean.success(list);
    }



    @OperationLog("查询部门及其子節點")
    @GetMapping("/listChildDept")
    @ResponseBody
    public ResultBean listChildDept( @RequestParam("deptId") Integer  deptId,@RequestParam("username") String username) {
        if (null!=username && (shiroActionProperties.getSuperAdminUsername().equals(username)
        ||username.equalsIgnoreCase(managername))) {
            deptId =0;
            username=null;
        }
        List<Dept> deptlist=deptService.selectDeptChildren(deptId, username);
      return ResultBean.success(deptlist);
    }

    @OperationLog("更新部門默認監控")
    @PostMapping("/updateDefaultVideo")
    @ResponseBody
    public ResultBean updateDefaultVideo( @RequestParam("deptId") String  deptId,@RequestParam("videoId") String videoId) {
        int result=deptService.updateDefaultVideoByDeptId(deptId, videoId);
        if(result>0) {
            return ResultBean.success();
        }else {
            return ResultBean.error("更新失敗");
        }
    }

    @OperationLog("查詢部門默認監控")
    @GetMapping("/queryDefaultVideoId")
    @ResponseBody
    public ResultBean queryDefaultVideo( @RequestParam("deptId") String  deptId) {
       return ResultBean.success(deptService.selectDefaultVideoByDeptId(deptId));

    }


    @OperationLog("查詢所有部門默認監控")
    @GetMapping("/queryAllDefaultVideo")
    @ResponseBody
    public ResultBean queryAllDefaultVideo( @RequestParam("deptId") String  deptId) {
        return ResultBean.success(deptService.selectAllDefaultVideo(deptId));

    }


    @OperationLog("新增部門默認監控")
    @PostMapping("/insertDefaultVideo")
    @ResponseBody
    public ResultBean insertDefaultVideo( @RequestParam("deptId") String  deptId,
                                          @RequestParam("videoId[]") List<String>   videoId) {
        for(String videoid:videoId)
        {
            //判断是否存在
            int result= deptService.selectExistsDefaultVideo(deptId,videoid);
            if(result==0){
                deptService.insertDefaultVideo(deptId,videoid);
            }

        }
        return ResultBean.success();

    }


    @OperationLog("查询所有监控")
    @GetMapping("/listAllvideoIdsByDeptid")
    @ResponseBody
    public ResultBean listAllvideoIdsByDeptid(@RequestParam("deptid") String deptid) {

        List<Map> deptList = deptService.listAllvideoIdsByDeptid(deptid);
        return ResultBean.success(deptList);
    }



}
