package im.zhaojun.system.controller;

import com.github.pagehelper.PageInfo;
import im.zhaojun.common.util.PageResultBean;
import im.zhaojun.common.util.ResultBean;
import im.zhaojun.system.model.*;
import im.zhaojun.system.service.TraffdevicewriteresultService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.client.RestTemplate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

@RestController
@RequestMapping("/traffresult")
public class TraffdevicewriteresultController {
    @Autowired
    private TraffdevicewriteresultService traffdevicewriteresultService;

    @Value("${eventsend.url}")
    String eventsendurl;

    @Value("${devicesend.url}")
    String devicesendurl;


    @Value("${devicesend.timeout}")
    private Integer timeout;

    @Autowired
    private RestTemplate restTemplate;
    /**
     * ѯͳɹҳ
     */
    @PostMapping("/queryTraffdevicewriteresultByPage")
    public PageResultBean<Traffdevicewriteresult> queryTraffdevicewriteresultByPage(TraffdevicewriteresultParams traffdevicewriteresult) {

        List<Traffdevicewriteresult> list= traffdevicewriteresultService.queryTraffdevicewriteresultByPage(traffdevicewriteresult);
        PageInfo<Traffdevicewriteresult> rolePageInfo = new PageInfo<>(list);
        return new  PageResultBean<>(rolePageInfo.getTotal(), rolePageInfo.getList());
    }

    /**
     * ѯм״̬ҳ
     */
    @PostMapping("/querySbtdspsrResultByPage")
    public PageResultBean<SbtdspsrResult>  querySbtdspsrResultByPage(SbtdspsrParams sbtdspsr) {
        List<SbtdspsrResult> list=traffdevicewriteresultService.querySbtdspsrResultByPage(sbtdspsr);
        PageInfo<SbtdspsrResult> rolePageInfo = new PageInfo<>(list);
        return new PageResultBean<>(rolePageInfo.getTotal(), rolePageInfo.getList());
    }
    /**
     * ݵƽ̨     */
    @PostMapping("/sendEvents")
    public List<ResultObj> sendEvents(@RequestParam("recordid") String recordid){
        List<ResultObj> resultObj =new ArrayList<>();
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<String, Object>();
        paramMap.add("recordid", recordid);
        try {
            resultObj =(List<ResultObj> ) CompletableFuture.supplyAsync(() -> restTemplate.postForObject(eventsendurl, paramMap, List.class)).get(timeout, TimeUnit.SECONDS);

        }catch (TimeoutException e) {
            resultObj.add(ResultObj.error(ResponseEnum.E_1008.getCode(), ResponseEnum.E_1008.getMsg()));
        } catch (Exception e) {
            resultObj.add(ResultObj.error(ResponseEnum.E_9999.getCode(), e.toString()));
        }
        return resultObj;

    }

    /**
     * ݵƽ̨     */
    @PostMapping("/sendDevices")
    public List<ResultObj> sendDevices(@RequestParam("xhs") String xhs){
        List<ResultObj> resultObj =new ArrayList<>();
        MultiValueMap<String, Object> paramMap = new LinkedMultiValueMap<String, Object>();
        paramMap.add("xhs", xhs);
        try {
            resultObj =(List<ResultObj> ) CompletableFuture.supplyAsync(() -> restTemplate.postForObject(devicesendurl, paramMap, List.class)).get(timeout, TimeUnit.SECONDS);

        }catch (TimeoutException e) {
            resultObj.add(ResultObj.error(ResponseEnum.E_1008.getCode(), ResponseEnum.E_1008.getMsg()));
        } catch (Exception e) {
            resultObj.add(ResultObj.error(ResponseEnum.E_9999.getCode(), e.toString()));
        }
        return resultObj;
    }



    /**
     * 
     */
    @PostMapping("/saveTraffdevicewriteresult")
    public ResultObj saveTraffdevicewriteresult(Traffdevicewriteresult traffdevicewriteresult) {
        return traffdevicewriteresultService.saveTraffdevicewriteresult(traffdevicewriteresult);
    }

    /**
     * 
     */
    @PostMapping("/saveTraffdevicewriteresultList")
    public  ResultBean saveTraffdevicewriteresultList(List<Traffdevicewriteresult> traffdevicewriteresultList) {
         traffdevicewriteresultService.saveTraffdevicewriteresultList(traffdevicewriteresultList);
        return ResultBean.success();
    }

    /**
     * 
     */
    @PostMapping("/updateTraffdevicewriteresult")
    public ResultBean updateTraffdevicewriteresult(Traffdevicewriteresult traffdevicewriteresult) {
         traffdevicewriteresultService.updateTraffdevicewriteresult(traffdevicewriteresult);
         return ResultBean.success();
    }

    /**
     * ɾ
     */
    @PostMapping("/deleteTraffdevicewriteresult")
    public ResultBean deleteTraffdevicewriteresult(Traffdevicewriteresult traffdevicewriteresult) {
        traffdevicewriteresultService.deleteTraffdevicewriteresult(traffdevicewriteresult);
        return ResultBean.success();
    }

    /**
     * ɾ
     */
    @PostMapping("/deleteTraffdevicewriteresultList")
    public ResultBean deleteTraffdevicewriteresultList(List<Traffdevicewriteresult> traffdevicewriteresultList) {
        traffdevicewriteresultService.deleteTraffdevicewriteresultList(traffdevicewriteresultList);
        return ResultBean.success();
    }




}