package im.zhaojun.system.service;

import com.github.pagehelper.PageHelper;
import im.zhaojun.common.exception.DuplicateNameException;
import im.zhaojun.common.shiro.ShiroActionProperties;
import im.zhaojun.common.util.TreeUtil;
import im.zhaojun.system.mapper.CodeMapper;
import im.zhaojun.system.mapper.UserMapper;
import im.zhaojun.system.mapper.UserRoleMapper;
import im.zhaojun.system.model.Code;
import im.zhaojun.system.model.Menu;
import im.zhaojun.system.model.User;
import org.apache.shiro.authz.UnauthorizedException;
import org.apache.shiro.crypto.hash.Md5Hash;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.mgt.eis.SessionDAO;
import org.apache.shiro.subject.SimplePrincipalCollection;
import org.apache.shiro.subject.support.DefaultSubjectContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.*;

@Service
public class CodeService {

    private static final Logger log = LoggerFactory.getLogger(CodeService.class);

    @Resource
    private CodeMapper codeMapper;


    public List<Code> selectAllWithKey(int page, int rows) {
        PageHelper.startPage(page, rows);
        return codeMapper.selectAllWithKey();
    }

    public int updatecode(List<Code>  code){
        return codeMapper.updatecode(code);
    }


    public int updatetime(List<Code>  code){
        return codeMapper.updatetime(code);
    }
    public List<Code> selectAllWithType(String typeid) {
        return codeMapper.selectAllWithType(typeid);
    }


    public boolean disableCodeByCodeID(String codeid) {
//        offlineByUserId(id); // 加上这段代码, 禁用用户后, 会将当前在线的用户立即踢出.
        return codeMapper.updateNameByCodeID(codeid, "0") == 1;
    }

    public boolean enableCodeByCodeID(String codeid) {
        return codeMapper.updateNameByCodeID(codeid, "1") == 1;
    }

    public boolean updatemanualcode(String name,String alarmlevel) {
        return codeMapper.updatemanualcode(name, alarmlevel) == 1;
    }



}