//行政目录
let vue_tree = new Vue({
    el: '.left-nav',
    data: {
        searchText: '',
    },
    methods: {
        fastSearch: function () {
            $("#tree-xzxq").treeview('search', [this.searchText, {
                ignoreCase: true,      // case insensitive
                exactMatch: false,     // like or equals
                revealResults: true,   // reveal matching nodes
            }]);
        }
    },
    mounted(){
        $.ajax({
            url: "/dept/getDeptParent/" + getCookie("bjpt_deptId"),
            dataType: "json",
            type: "GET",
            data: {},
            success: function (result) {
                if (result.code == 0) {
                    let parIds = result.data[0].parentId;
                    $.ajax({
                        url: "/dept/listvideo",
                        dataType: "json",
                        type: "GET",
                        data: {
                            deptId: getCookie("bjpt_deptId"),
                            username: getCookie("bjpt_realName"),
                            tdmc:'',
                        },
                        success: function (result) {
                            let defaultData = [];
                            if (result.code == 0) {
                                defaultData = toTree(result.data, parIds + '');
                                $('#tree-xzxq').treeview({
                                    expandIcon: 'glyphicon glyphicon-triangle-right selected-span',
                                    collapseIcon: 'glyphicon glyphicon-triangle-bottom selected-span',
                                    nodeIcon: 'glyphicon glyphicon-folder-open selected-span',
                                    selectedBackColor: '#ff000000',
                                    selectedColor: '#368ff3',
                                    onhoverColor: '#73a5ff26',
                                    showBorder: false,
                                    data: defaultData
                                });
                                $('#tree-xzxq').on('nodeSelected', function (event, data) {
                                    vue_right.xz_jg = data.href;
                                    vue_right.level = data.level;
                                    vue_myModal1.data_s.qybh = data.href;
                                    vue_myModal1.data_s.qymc = data.text;
                                    // alert('点击选中');
                                });
                                $('#tree-xzxq').on('nodeUnselected', function (event, data) {

                                    // alert('取消选择');
                                });
                            }
                        }
                    });
                }
            }
        });
        // $.ajax({
        //     url: "/dept/tree",
        //     dataType: "json",
        //     type: "GET",
        //     data: {
        //         parentId: getCookie("bjpt_deptId"),
        //     },
        //     success: function (result) {
        //         let defaultData = [];
        //         if (result.code == 0) {
        //             defaultData = result.data;
        //             $('#tree-xzxq').treeview({
        //                 expandIcon: 'glyphicon glyphicon-triangle-right selected-span',
        //                 collapseIcon: 'glyphicon glyphicon-triangle-bottom selected-span',
        //                 selectedBackColor: '#ff000000',
        //                 selectedColor: '#368ff3',
        //                 onhoverColor: '#73a5ff26',
        //                 showBorder: false,
        //                 data: defaultData,
        //             });
        //             $('#tree-xzxq').on('nodeSelected', function (event, data) {
        //                 vue_right.xz_jg = data.href;
        //                 vue_right.level = data.level;
        //                 vue_myModal1.data_s.qybh = data.href;
        //                 vue_myModal1.data_s.qymc = data.text;
        //                 // alert('点击选中');
        //             });
        //             $('#tree-xzxq').on('nodeUnselected', function (event, data) {
        //                 vue_right.xz_jg = '';
        //                 // alert('取消选择');
        //             });
        //         }
        //     }
        // });
    }
});

let vue_right = new Vue({
    el: '.right-nav',
    data: {
        data_table_monitor: [],
        xz_jg: getCookie("bjpt_deptId"),
        count: '',
        level: '',
        fy_select:20,
    },
    methods: {
        add: function () {
            if (this.xz_jg != '') {
                //this.xz_jg为当前机构的id
                // alert(this.xz_jg);
                if (this.level == '2') {
                    $("#myModal1").modal("show");
                } else {
                    info_new("监控只属于大队，请选择大队");
                    window.setTimeout("$('#info-warning-new').modal('hide')", 2000);
                }
            } else {
                alert('未选择部门')
            }
        },
        edit: function (item) {
            vue_myModal1_edit.data_s.id = item.id,
                vue_myModal1_edit.data_s.videoId = item.videoId,
                vue_myModal1_edit.data_s.videoName = item.name,
                vue_myModal1_edit.data_s.qybh = item.qybh,
                vue_myModal1_edit.data_s.qymc = item.qymc,
                vue_myModal1_edit.data_s.rtsp = item.rtsp,
                vue_myModal1_edit.data_s.chargeman = item.chargeman,
                vue_myModal1_edit.data_s.chargemanlxdh = item.chargemanlxdh,
                $("#myModal1_edit").modal("show");
        },
        del: function (item) {
            if (!confirm("确认删除监控吗？")) {
                return;
            }
            $.ajax({
                url: "/video/delete/" + item.id,
                dataType: "json",
                type: "GET",
                data: {},
                success: function (result) {
                    vue_right.queryRY(1, true);
                    info_new("监控删除成功");
                    window.setTimeout("$('#info-warning-new').modal('hide')", 2000);

                }
            });
        },
        queryRY: function (pages, items) {
            $.ajax({
                url: "/video/list",
                dataType: "json",
                type: "get",
                data: {
                    page: pages,
                    pageSize: this.fy_select,
                    deptId: this.xz_jg,
                    videoName: $("#ryxm").val(),
                },
                success: function (result) {
                    vue_right.data_table_monitor = [];
                    if (result.code == 0) {
                        let a_sum = result.count;
                        vue_right.count = result.count;
                        vue_right.data_table_monitor = result.data;
                        if (items) {
                            $("#fy4").bootstrapPaginator({
                                bootstrapMajorVersion: 3, //版本，这里设置为3，大于2即可
                                currentPage: 1,//当前页
                                totalPages: Math.ceil(((a_sum > 0) ? a_sum : 1) / vue_right.fy_select),//总页数
                                // numberofPages: this.fy_select,//显示的页数
                                itemTexts: function (type, page, current) { //修改显示文字
                                    switch (type) {
                                        case "first":
                                            return "首页";
                                        case "prev":
                                            return "上一页";
                                        case "next":
                                            return "下一页";
                                        case "last":
                                            return "末页";
                                        case "page":
                                            return page;
                                    }
                                }, onPageClicked: function (event, originalEvent, type, page) { //异步换页
                                    //请求加载数据
                                    vue_right.queryRY(page, false);
                                }
                            });
                        }
                    }
                }
            });
        },
        getChange:function () {
            // alert(this.fy_select);
            this.queryRY(1,true);
        }
    },
    mounted(){
        this.queryRY(1, true);
    }
});

let vue_myModal1 = new Vue({
    el: '#myModal1',
    data: {
        data_s: {
            videoId: '',
            videoName: '',
            qybh: '',
            qymc: '',
            x: '',
            y: '',
            rtsp: '',
            factory: '',
            chargeman: '',
            chargemanlxdh: '',
        },
    },
    methods: {
        define: function () {
            $.ajax({
                url: "/video/add",
                dataType: "json",
                type: "POST",
                data: vue_myModal1.data_s,
                success: function (result) {
                    if (result.code == 0) {
                        vue_right.queryRY(1, true);
                        $("#myModal1").modal("hide");
                        info_new("监控新增成功");
                        window.setTimeout("$('#info-warning-new').modal('hide')", 2000);
                    }
                }
            });
        }
    }
});

let vue_myModal1_edit = new Vue({
    el: '#myModal1_edit',
    data: {
        data_s: {
            id: '',
            videoId: '',
            videoName: '',
            qybh: '',
            qymc: '',
            x: '',
            y: '',
            rtsp: '',
            factory: '',
            chargeman: '',
            chargemanlxdh: '',
        },
    },
    methods: {
        define: function () {
            $.ajax({
                url: "/video/edit",
                dataType: "json",
                type: "POST",
                data: vue_myModal1_edit.data_s,
                success: function (result) {
                    if (result.code == 0) {
                        vue_right.queryRY(1, true);
                        $("#myModal1_edit").modal("hide");
                        info_new("监控修改成功");
                        window.setTimeout("$('#info-warning-new').modal('hide')", 2000);
                    }
                }
            });
        }
    }
});

var lastSelectedNodeId = null;
//最后一次触发时间
var lastSelectTime = null;
function customBusiness(data) {
//        alert("双击获得节点名字： "+data.text);
}

function clickNode(event, data) {
    if (lastSelectedNodeId && lastSelectTime) {
        var time = new Date().getTime();
        var t = time - lastSelectTime;
        if (lastSelectedNodeId == data.nodeId && t < 300) {
            customBusiness(data);
        }
    }
    lastSelectedNodeId = data.nodeId;
    lastSelectTime = new Date().getTime();
}

//自定义双击事件
function customDblClickFun() {
    //节点选中时触发
    $('#tree-xzxq').on('nodeSelected', function (event, data) {
        clickNode(event, data)
    });
    //节点取消选中时触发
    $('#tree-xzxq').on('nodeUnselected', function (event, data) {
        clickNode(event, data)
    });
}
$(document).ready(function () {
    customDblClickFun();
});

function toTree(list, parId) {
    let len = list.length;

    function loop(parId) {
        let res = [];
        for (let i = 0; i < len; i++) {
            let item = list[i];
            if (item.parentId === parId) {
                if(item.level!=null){
                    item.nodes = loop(item.href);
                    let arr = {
                        href: item.href,
                        text: item.text,
                        level: item.level,
                        parentId: item.parentId,
                    }
                    if (item.level == 0||item.level == 1) {
                        if (item.nodes.length > 0) {
                            arr.nodes = item.nodes;
                            arr.state = {expanded: true};
                        }
                    }else{

                        arr.selectable = true;
                    }
                    res.push(arr);
                }
            }
        }
        return res
    }

    return loop(parId)
}