package im.zhaojun.system.controller;

import im.zhaojun.common.annotation.OperationLog;
import im.zhaojun.common.shiro.ShiroActionProperties;
import im.zhaojun.common.util.ResultBean;
import im.zhaojun.system.model.DeptTree;
import im.zhaojun.system.service.DeptService;
import im.zhaojun.system.service.DeptTreeService;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;

@Controller
@RequestMapping("/depttree")
public class DeptTreeController {

    @Resource
    private DeptTreeService deptTreeService;

    @Resource
    private ShiroActionProperties shiroActionProperties;

    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    @GetMapping("/index")
    public String index() {
        return "dept/dept-list";
    }

    @OperationLog("获取部门列表")
    @GetMapping("/list")
    @ResponseBody
    public ResultBean getList(@RequestParam(required = false) String parentId) {
        List<DeptTree> deptList = deptTreeService.selectByParentId(parentId);
        return ResultBean.success(deptList);
    }

    @GetMapping("/tree/root")
    @ResponseBody
    public ResultBean treeAndRoot() {
        return ResultBean.success(deptTreeService.selectAllDeptTreeAndRoot());
    }

    @GetMapping("/tree")
    @ResponseBody
    public ResultBean tree() {

        return ResultBean.success(deptTreeService.selectAllDeptTree("0")
        );
    }

    @GetMapping
    public String add() {
        return "dept/dept-add";
    }

//    @OperationLog("新增部门")
//    @PostMapping
//    @ResponseBody
//    public ResultBean add(DeptTree dept) {
//        if(null==dept.getDeptId() ||dept.getDeptId().equals(""))
//        {
//            dept.setDeptId(deptTreeService.selectMaxOrderNum()+1);
//        }
//        dept.setCreateTime(sdf.format(new Date()));
//        dept.setModifyTime(dept.getCreateTime());
//        return ResultBean.success(deptTreeService.insert(dept));
//    }

    @OperationLog("删除部门")
    @DeleteMapping("/{deptId}")
    @ResponseBody
    public ResultBean delete(@PathVariable("deptId") String deptId) {
        deptTreeService.deleteCascadeByID(deptId);
        return ResultBean.success();
    }

    @OperationLog("修改部门")
    @PutMapping
    @ResponseBody
    public ResultBean update(DeptTree dept) {
        dept.setModifyTime(dept.getCreateTime());
        deptTreeService.updateByPrimaryKey(dept);
        return ResultBean.success();
    }

    @GetMapping("/{deptId}")
    public String update(@PathVariable("deptId") String deptId, Model model) {
        DeptTree dept = deptTreeService.selectByPrimaryKey(deptId);
        model.addAttribute("dept", dept);
        return "dept/dept-add";
    }

    @OperationLog("调整部门排序")
    @PostMapping("/swap")
    @ResponseBody
    public ResultBean swapSort(Integer currentId, Integer swapId) {
        deptTreeService.swapSort(currentId, swapId);
        return ResultBean.success();
    }

    @OperationLog("获取部门列表")
    @GetMapping("/listByUsername")
    @ResponseBody
    public ResultBean listByUsername(@RequestParam(required = false) String parentId,String username) {
        if (null!=username && shiroActionProperties.getSuperAdminUsername().equals(username)) {
            parentId = "-1";
        }
        List<DeptTree> deptList = deptTreeService.selectAllDeptTree(parentId);
        return ResultBean.success(deptList);
    }



}
