var countersMap =  new Map(); // 开始时间戳
var offsetsMap = new Map(); // 倒计时时间
var timersMap = new Map();; // js timer id
var maxIndex = 0;
// 初始化添加timer
// count - 添加个数
// offset - timer 倒计时秒数

// 添加一个倒计时Timer 
// offset - 倒计时秒数/
// addMin - 加时时间
function appendTimer(offset, addMin = 5) {
    var index = maxIndex++;
    var number = document.getElementsByClassName("timer").length;
    var timer_div = document.createElement("div");
    timer_div.className = "timer";
    timer_div.id = `timer_${index}`;

    document.getElementById('timer_list').appendChild(timer_div);
	begin(index,offset);
}

// 开始倒计时
// i - Timer索引
// seconds - 要倒计时的秒数
function begin(i, seconds) {
    warning(i, false); // 先清除警示
    countersMap.set(i,(new Date()).valueOf());
    offsetsMap.set(i, vue_sjcx.offset * 1000);
    timersMap.set(i,setInterval(function () {
        checkEnd(i, display(i));
    }, 10));
}

// 停止倒计时
// i - 要停止的Timer索引
function stop(i) {
    if (timersMap.get(i)) clearInterval(timersMap.get(i));
    warning(i, false);
    timersMap.set(i, 0);
    countersMap.set(i, (new Date()).valueOf());
    // display(i);
}

// 加时
// i - Timer索引索引
// seconds - 加时
function addTime(i, seconds) {
    if (!counters[i]) return;
    counters[i] += seconds * 1000;
    display(i);
}

// 显示倒计时
// i - Timer索引
function display(i) {
    var current = (new Date()).valueOf();
    var leave = offsetsMap.get(i) - (current - countersMap.get(i)); // 剩余时间
    var time = "00:00.000";
    if (leave <= 0) {
        clearInterval(timersMap.get(i));
        timersMap.set(i, 0);
    } else {
        var leaveTime = new Date(leave);
        time = `${zero(leaveTime.getMinutes(), 2)}:${zero(leaveTime.getSeconds(), 2)}.${zero(leaveTime.getMilliseconds(), 3)}`;
    }
    if(document.getElementById(`display_${i}`)!=null) {
        document.getElementById(`display_${i}`).innerHTML = time;
    }
    return leave;
}

// 检查是否结束
// i - Timer索引
// time - 剩余时间
function checkEnd(i, time) {
    if (time > 0) return;
    warning(i);
}

// 数字自动补零
// num - 时间
// length - 补足长度
function zero(num, length){              
    return new Array(length - (num + "").length + 1).join("0") + num;             
}

// 警示
// i - Timer索引
// enable - 开启警示与否
function warning(i, enable = true) {
    if (enable) {
        // if(document.getElementById(`display_${i}`)!=null) {
        //     document.getElementById(`display_${i}`).style.color = "red";
        //     document.getElementById(`display_${i}`).style.fontWeight = "bold";
        // }
        console.log(i+"time over")
		//发送该事件
        send(i);
        $("#"+ i).remove();
    } else {
        document.getElementById(`display_${i}`).style.color = "";        
        document.getElementById(`display_${i}`).style.fontWeight = "";        
    }


}


function remove(i) {
    var timer = document.getElementById(`timer_${i}`);
    timer.parentNode.removeChild(timer);
    var numbers = Array.from(document.getElementsByClassName("number"));
    numbers.forEach(function(ele, index) {
        ele.innerHTML = index + 1;
    });
}
