package im.zhaojun.system.service;

import com.github.pagehelper.PageHelper;
import im.zhaojun.common.util.ShiroUtil;
import im.zhaojun.system.mapper.LoginLogMapper;
import im.zhaojun.system.mapper.TrafficStatisticsMapper;
import im.zhaojun.system.model.*;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.*;

/**
 * 通流量统计 Service
 */
@Service
public class TrafficStatisticsService {

    @Resource
    private TrafficStatisticsMapper trafficStatisticsMapper;


    /**
     * 根据时间和监控id 统计当天的车流量数
     */
    public List<Map> selectVehicles(String startmillisecond,String  endmillisecond, String  deptid) {
       return trafficStatisticsMapper.selectVehicles(startmillisecond,endmillisecond,deptid);
    }
    /**
     * 根据时间和监控id 统计流量中车辆类型
     */
    public List<Map> selectVehiclesTypes(String startmillisecond,String endmillisecond,String   deptid) {
        return trafficStatisticsMapper.selectVehiclesTypes(startmillisecond,endmillisecond,deptid);
    }
    /**
     * 根据时间和监控id查询拥堵情况
     */
    public List<Map> selectFlowStatus(String startmillisecond,String endmillisecond ,String  videoid){
        return trafficStatisticsMapper.selectFlowStatus(startmillisecond,endmillisecond,videoid);
    }


    /**
     * 根据时间和监控id查询异常时间段事件数
     */
    public List<Map> selectAlarms(String startmillisecond,String endmillisecond,String  deptid){
        return trafficStatisticsMapper.selectAlarms(startmillisecond,endmillisecond,deptid);
    }
    /**
     * 根据时间和监控id统计不同类别异常事件数
     */
    public List<Map> selectAlarmsTypes(String startmillisecond,String endmillisecond,String  deptid){
        return trafficStatisticsMapper.selectAlarmsTypes(startmillisecond,endmillisecond,deptid);
    }
    /**
     * 根据时间和监控id统计不同类别异常事件数
     */
    public List<Map> selectAlarmsByVideoName(String videoname,String startmillisecond,String endmillisecond,Integer topnum){
        return trafficStatisticsMapper.selectAlarmsByVideoName(videoname,startmillisecond,endmillisecond,topnum);
    }
    /**
     * 按照监控点位分组进行各种车辆同比环比流量数据
     */
    public List<VehiclesStatistic> selectVehiclesByVideoIdAndType(Map map , Integer pageNum, Integer pageSize){
        PageHelper.startPage(pageNum,pageSize);
            return trafficStatisticsMapper.selectVehiclesByVideoIdAndType(map);
    }


    /**
     * 按照监控点位分组进行各种车辆同比环比流量数据
     */
    public List<VehiclesStatisticResult> selectStatisVehiclesByVideoIdAndType(Map map , Integer pageNum, Integer pageSize){
        PageHelper.startPage(pageNum,pageSize);
        return trafficStatisticsMapper.selectStatisVehiclesByVideoIdAndType(map);
    }

    /**
     * 按照监控点位分组进行各种车辆同比环比流量数据
     */
    public List<VehiclesStatisticResult> selectStatisVehiclesByVideoIdAndType(Map map){
        return trafficStatisticsMapper.selectStatisVehiclesByVideoIdAndType(map);
    }
    /**
     * 按照监控点位分组进行各种车辆同比环比流量数据
     */
    public List<VehiclesStatisticResult> selectVehiclesStatisByVideoIdAndType(Map map ){
        return trafficStatisticsMapper.selectVehiclesStatisByVideoIdAndType(map);
    }


    /**
     * 按照监控点位分组进行各种车辆流量数据
     */
    public List<VehiclesStatisticResult> selectVehiclesByMutiParam(Map map , Integer pageNum, Integer pageSize){
        PageHelper.startPage(pageNum,pageSize);
        return trafficStatisticsMapper.selectVehiclesByMutiParam(map);
    }



    /**
     * 按照监控点位分组进行各种车辆同比环比流量数据
     */
    public List<Alarm> selectAlarmsByTime(Map map , Integer pageNum, Integer pageSize){
        PageHelper.startPage(pageNum,pageSize);
        return trafficStatisticsMapper.selectAlarmsByTime(map);
    }



    /**
     * 按照监控点位分组进行各种车辆同比环比流量数据
     */
    public List<CodeData> selectCodeByCodeId(String  codeid,String level){
        return trafficStatisticsMapper.selectCodeByCodeid(codeid,level);
    }

    /**
     * 按照部门查询点位高发排行榜
     */
    public List<Map> selectvideoVehiclesOrAlarms(Map map){
        return trafficStatisticsMapper.selectvideoVehiclesOrAlarms(map);
    }



    public List<TraffalarmrecordResult>  queryTraffalarmrecordByPage( Map map,int page, int limit) {
        PageHelper.startPage(page,limit);
        List<TraffalarmrecordResult> traffalarmrecordResults=trafficStatisticsMapper.queryTraffalarmrecordByPage(map);

        return traffalarmrecordResults;
    }


   public  int  updateTraffalarmrecordById(List<Traffalarmrecord> recordlist ){

        return trafficStatisticsMapper.updateTraffalarmrecordById(recordlist);
   }

    public  int  updateVideochecktime(List<Traffalarmrecord> recordlist ){

        return trafficStatisticsMapper.updateVideochecktime(recordlist);
    }

    public List<VehiclesStatisticResult>  todayvehiclesByVideoId(Map  map) {
        return trafficStatisticsMapper.todayvehiclesByVideoId(map);
    }

    public List<VehiclesStatisticResult>  todayvehiclesByeveryhour(Map  map) {
        return trafficStatisticsMapper.todayvehiclesByeveryhour(map);
    }
    public List<RecordResult>  todaytraffRecordByeveryhour(Map  map) {
        return trafficStatisticsMapper.todaytraffRecordByeveryhour(map);
    }
    public List<RecordResult>  todaytraffRecords(Map  map) {
        return trafficStatisticsMapper.todaytraffRecords(map);
    }

    public List<Map>  todaythbtraffRecords(Map  map) {
        return trafficStatisticsMapper.todaythbtraffRecords(map);
    }

    public List<VehiclesStatisticResult>  selecthistorytraffRecords(Map  map) {
        return trafficStatisticsMapper.selecthistorytraffRecords(map);
    }
    public List<VehiclesStatisticResult>  selecthistoryvehicles(Map  map) {
        return trafficStatisticsMapper.selecthistoryvehicles(map);
    }

    public List<Traffalarmrecord>  selectPushRecordsBypage(Map  map,int page, int limit) {
        PageHelper.startPage(page,limit);
        return trafficStatisticsMapper.selectPushRecordsBypage(map);
    }

    public List<Traffalarmrecordstate>  selecteventresultBypage(TraffalarmrecordstatParams params) {
        PageHelper.startPage(params.getPage(),params.getLimit());
        return trafficStatisticsMapper.selecteventresultBypage(params);
    }

    public  int  deleteTraffalarmrecordById(String  recordid ){
        return trafficStatisticsMapper.deleteTraffalarmrecordById(recordid);
    }
    public  int  updateTraffalarmrecordPushStatusById(String  recordid ){
        return trafficStatisticsMapper.updateTraffalarmrecordPushStatusById(recordid);
    }


}