package im.zhaojun.system.mapper;

import im.zhaojun.system.model.*;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

@Mapper
public interface TrafficStatisticsMapper {
    List<Map> selectVehicles(@Param("starttime") String starttime, @Param("endtime") String endtime, @Param("deptId") String deptid);

    List<Map> selectFlowStatus(@Param("starttime") String starttime, @Param("endtime") String endtime, @Param("deptId") String videoid);

    List<Map> selectVehiclesTypes(@Param("starttime") String starttime, @Param("endtime") String endtime, @Param("deptId") String deptid);

    List<Map> selectAlarms(@Param("starttime") String starttime, @Param("endtime") String endtime, @Param("deptId") String deptid);

    List<Map> selectAlarmsTypes(@Param("starttime") String starttime, @Param("endtime") String endtime, @Param("deptId") String deptid);

    List<Map> selectAlarmsByVideoName(@Param("videoname") String videoname, @Param("starttime") String starttime, @Param("endtime") String endtime, @Param("topnum") Integer topnum);

    List<VehiclesStatistic> selectVehiclesByVideoIdAndType(Map map);

    List<VehiclesStatisticResult> selectStatisVehiclesByVideoIdAndType(Map map);

    List<VehiclesStatisticResult> selectVehiclesStatisByVideoIdAndType(Map map);

    List<VehiclesStatisticResult> selectVehiclesByMutiParam(Map map);

    List<Alarm> selectAlarmsByTime(Map map);

    Role selectByPrimaryKey(@Param("roleId") Integer roleId);

    int updateByPrimaryKey(Role role);

    List<Role> selectAll();

    List<Role> selectAllByQuery(Role roleQuery);

    int count();

    List<CodeData> selectCodeByCodeid(@Param("codeid") String codeid, @Param("level") String level);

    List<Map> selectvideoVehiclesOrAlarms(Map map);


    List<TraffalarmrecordResult> queryTraffalarmrecordByPage(Map map);

    int updateTraffalarmrecordById(@Param(value = "list") List<Traffalarmrecord> recordlist);

    List<VehiclesStatisticResult> todayvehiclesByVideoId(Map map);

    List<VehiclesStatisticResult> todayvehiclesByeveryhour(Map map);

    List<RecordResult> todaytraffRecordByeveryhour(Map map);

    List<RecordResult> todaytraffRecords(Map map);

    public List<Map> todaythbtraffRecords(Map map);

    List<VehiclesStatisticResult> selecthistorytraffRecords(Map map);

    List<VehiclesStatisticResult> selecthistoryvehicles(Map map);

    List<Traffalarmrecord> selectPushRecordsBypage(Map map);

    List<Traffalarmrecordstate> selecteventresultBypage(TraffalarmrecordstatParams params);

    List<TraffalarmrecordResult> selectTraffalarmrecordAllByPage(@Param("recordtype") String recordtype, @Param("areaid") Long areaid, @Param("checkstatus") Integer checkstatus,
                                                                 @Param("starttime") String starttime, @Param("endtime") String endtime, @Param("pushstatus") Integer pushstatus);

    int updateVideochecktime(@Param(value = "list") List<Traffalarmrecord> recordlist);

    int  deleteTraffalarmrecordById(String  recordid);

    int  updateTraffalarmrecordPushStatusById(String  recordid);
}