package com.hzjt.listener;

import com.hzjt.service.CacheLoadService;
import com.hzjt.service.FLVCacheService;
import com.hzjt.service.FtpService;
import com.hzjt.service.QingZhiLoginCacheService;
import com.hzjt.util.ThreadPoolUtil;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.boot.context.event.SpringApplicationEvent;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

import java.util.concurrent.TimeUnit;

@Slf4j
@Component
public class MyApplicationStartingEventListener implements ApplicationListener<SpringApplicationEvent>, ApplicationContextAware {

    private ApplicationContext applicationContext;
    private boolean flag = false;

    private FtpService ftpService;

    @Autowired
    public MyApplicationStartingEventListener() {

    }

    @Override
    public void onApplicationEvent(SpringApplicationEvent event) {
        if (event instanceof ApplicationReadyEvent) {
            try {
                if (!flag) {
                    ThreadPoolUtil.getSchedulePool().scheduleWithFixedDelay(() -> {
                        CacheLoadService cacheLoadService = applicationContext.getBean(CacheLoadService.class);
                        cacheLoadService.loadFtpCache();
                    }, 200, 60, TimeUnit.SECONDS);

                    //判断第三方登录是否有效
                    ThreadPoolUtil.getSchedulePool().scheduleWithFixedDelay(() -> {
                        QingZhiLoginCacheService qingZhiLoginCacheService = applicationContext.getBean(QingZhiLoginCacheService.class);
                        qingZhiLoginCacheService.keepAlive();
                    }, 3, 60, TimeUnit.SECONDS);

                    //查询flv值
                    ThreadPoolUtil.getSchedulePool().scheduleWithFixedDelay(() -> {
                        FLVCacheService flvservice = applicationContext.getBean(FLVCacheService.class);
                        flvservice.getvalue();
                    }, 3, 300, TimeUnit.SECONDS);


                }
            } catch (Exception e) {
                e.printStackTrace();
                log.error(e.toString());
                System.exit(0);
            } finally {
                flag = true;
            }
        }
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}