/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.IOException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.NTFXSEvent;
import oracle.jdbc.driver.T4CConnection;
import oracle.jdbc.driver.T4CTTIMsg;
import oracle.jdbc.driver.T4CTTIidc;
import oracle.jdbc.driver.T4CTTIkvarr;
import oracle.jdbc.driver.T4CTTIoer;
import oracle.jdbc.internal.OracleConnection;
import oracle.net.ns.BreakNetException;

abstract class T4CTTIfun
extends T4CTTIMsg {
    static final short OOPEN = 2;
    static final short OEXEC = 4;
    static final short OFETCH = 5;
    static final short OCLOSE = 8;
    static final short OLOGOFF = 9;
    static final short OCOMON = 12;
    static final short OCOMOFF = 13;
    static final short OCOMMIT = 14;
    static final short OROLLBACK = 15;
    static final short OCANCEL = 20;
    static final short ODSCRARR = 43;
    static final short OVERSION = 59;
    static final short OK2RPC = 67;
    static final short OALL7 = 71;
    static final short OSQL7 = 74;
    static final short O3LOGON = 81;
    static final short O3LOGA = 82;
    static final short OKOD = 92;
    static final short OALL8 = 94;
    static final short OLOBOPS = 96;
    static final short ODNY = 98;
    static final short OTXSE = 103;
    static final short OTXEN = 104;
    static final short OCCA = 105;
    static final short O80SES = 107;
    static final short OAUTH = 115;
    static final short OSESSKEY = 118;
    static final short OCANA = 120;
    static final short OKPN = 125;
    static final short OOTCM = 127;
    static final short OSCID = 135;
    static final short OSPFPPUT = 138;
    static final short OKPFC = 139;
    static final short OPING = 147;
    static final short OKEYVAL = 154;
    static final short OXSSCS = 155;
    static final short OXSSRO = 156;
    static final short OXSSPO = 157;
    static final short OAQEQ = 121;
    static final short OAQDQ = 122;
    static final short OAQGPS = 132;
    static final short OAQLS = 126;
    static final short OAQXQ = 145;
    static final short OXSNS = 172;
    private short funCode;
    private final byte seqNumber = 0;
    protected final T4CTTIoer oer;
    int receiveState = 0;
    static final int IDLE_RECEIVE_STATE = 0;
    static final int ACTIVE_RECEIVE_STATE = 1;
    static final int READROW_RECEIVE_STATE = 2;
    static final int STREAM_RECEIVE_STATE = 3;
    boolean rpaProcessed = false;
    boolean rxhProcessed = false;
    boolean iovProcessed = false;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Tue_Feb_23_16:42:12_PST_2010";
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;

    T4CTTIfun(T4CConnection t4CConnection, byte by) {
        super(t4CConnection, by);
        this.oer = t4CConnection.getT4CTTIoer();
    }

    final void setFunCode(short s2) {
        this.funCode = s2;
    }

    final short getFunCode() {
        return this.funCode;
    }

    private final void marshalFunHeader() throws IOException {
        this.marshalTTCcode();
        this.meg.marshalUB1(this.funCode);
        this.meg.marshalUB1((short)0);
    }

    abstract void marshal() throws IOException;

    final void doRPC() throws IOException, SQLException {
        if (this.getTTCCode() == 17) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        this.init();
        this.marshalFunHeader();
        this.marshal();
        this.receive();
    }

    final void doPigRPC() throws IOException {
        this.init();
        this.marshalFunHeader();
        this.marshal();
    }

    private void init() {
        this.rpaProcessed = false;
        this.rxhProcessed = false;
        this.iovProcessed = false;
    }

    void resumeReceive() throws SQLException, IOException {
        this.receive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void receive() throws SQLException, IOException {
        this.receiveState = 1;
        var1_1 = null;
        block28: while (true) lbl-1000:
        // 19 sources

        {
            try {
                var2_2 = this.meg.unmarshalSB1();
                switch (var2_2) {
                    case 8: {
                        if (this.rpaProcessed) {
                            var3_3 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
                            var3_3.fillInStackTrace();
                            throw var3_3;
                        }
                        this.readRPA();
                        try {
                            this.processRPA();
                        }
                        catch (SQLException var3_4) {
                            var1_1 = var3_4;
                        }
                        this.rpaProcessed = true;
                        ** break;
                    }
                    case 21: {
                        this.readBVC();
                        ** break;
                    }
                    case 11: {
                        this.readIOV();
                        this.iovProcessed = true;
                        ** break;
                    }
                    case 6: {
                        this.readRXH();
                        this.rxhProcessed = true;
                        ** break;
                    }
                    case 7: {
                        this.receiveState = 2;
                        if (this.readRXD()) {
                            this.receiveState = 3;
                            return;
                        }
                        this.receiveState = 1;
                        ** break;
                    }
                    case 16: {
                        this.readDCB();
                        ** break;
                    }
                    case 14: {
                        this.readLOBD();
                        ** break;
                    }
                    case 23: {
                        var3_5 = (byte)this.meg.unmarshalUB1();
                        var4_7 = this.meg.unmarshalUB2();
                        var5_8 = (byte)this.meg.unmarshalUB1();
                        if (var3_5 == 1) {
                            var6_9 = 0;
                            while (true) {
                                if (var6_9 >= var4_7) continue block28;
                                var7_17 = new T4CTTIidc(this.connection);
                                var7_17.unmarshal();
                                ++var6_9;
                            }
                        }
                        if (var3_5 == 2) {
                            var6_10 = 0;
                            while (true) {
                                if (var6_10 >= var4_7) continue block28;
                                var7_18 = this.meg.unmarshalUB1();
                                ++var6_10;
                            }
                        }
                        if (var3_5 == 3 || var3_5 == 4) continue block28;
                        if (var3_5 == 5) {
                            var6_11 = new T4CTTIkvarr(this.connection);
                            var6_11.unmarshal();
                            ** break;
                        }
                        if (var3_5 != 6) continue block28;
                        var6_12 = 0;
                        while (true) {
                            if (var6_12 >= var4_7) continue block28;
                            var7_17 = new NTFXSEvent(this.connection);
                            this.connection.notify((NTFXSEvent)var7_17);
                            ++var6_12;
                        }
                    }
                    case 19: {
                        this.meg.marshalUB1((short)19);
                        ** break;
                    }
                    case 15: {
                        this.oer.init();
                        this.oer.unmarshalWarning();
                        try {
                            this.oer.processWarning();
                        }
                        catch (SQLWarning var6_13) {
                            this.connection.setWarnings(DatabaseError.addSqlWarning(this.connection.getWarnings(), var6_13));
                        }
                        continue block28;
                    }
                    case 9: {
                        if (this.connection.getTTCVersion() >= 3) {
                            this.connection.endToEndECIDSequenceNumber = var6_14 = (short)this.meg.unmarshalUB2();
                        }
                        break block28;
                    }
                    case 4: {
                        this.oer.init();
                        this.oer.unmarshal();
                        try {
                            this.processError();
                        }
                        catch (SQLException var6_15) {
                            var1_1 = var6_15;
                        }
                        break block28;
                    }
                    default: {
                        var6_16 = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
                        var6_16.fillInStackTrace();
                        throw var6_16;
                    }
                }
            }
            catch (BreakNetException var3_6) {}
            continue;
            finally {
                this.meg.sentCancel = false;
                continue;
            }
            break;
        }
        this.receiveState = 0;
        if (var1_1 != null) {
            throw var1_1;
        }
    }

    void processRPA() throws SQLException {
    }

    void readRPA() throws IOException, SQLException {
    }

    void readBVC() throws IOException, SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    void readLOBD() throws IOException, SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    void readIOV() throws IOException, SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    void readRXH() throws IOException, SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    boolean readRXD() throws IOException, SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    void readDCB() throws IOException, SQLException {
        SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 401);
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    void processError() throws SQLException {
        this.oer.processError();
    }

    final int getErrorCode() throws SQLException {
        return this.oer.retCode;
    }

    @Override
    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

