/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms.plsql;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import oracle.jms.plsql.JmsPlsException;
import oracle.sql.STRUCT;
import oracle.sql.StructDescriptor;

public class ExceptionHandler {
    private static Throwable lastExp = null;
    private static Connection db_conn = null;
    private static StructDescriptor sdJmsException = null;
    private static Object[] nullAttribs = new Object[]{null, null, null, null};

    public static int get_exception(STRUCT[] exp, int[] nullInd) {
        try {
            if (sdJmsException == null) {
                db_conn = DriverManager.getConnection("jdbc:default:connection:");
                sdJmsException = StructDescriptor.createDescriptor((String)"SYS.AQ$_JMS_EXCEPTION", (Connection)db_conn);
            }
            if (lastExp == null) {
                nullInd[0] = 1;
                exp[0] = new STRUCT(sdJmsException, db_conn, nullAttribs);
            } else {
                nullInd[0] = 0;
                Integer id = new Integer(0);
                String clsName = lastExp.getClass().getName();
                String errorMsg = lastExp.getMessage();
                StringWriter sw = new StringWriter();
                lastExp.printStackTrace(new PrintWriter(sw));
                String stack = sw.toString();
                Object[] attribs = new Object[]{id, clsName, errorMsg, stack};
                exp[0] = new STRUCT(sdJmsException, db_conn, attribs);
            }
            return 0;
        }
        catch (Throwable t) {
            try {
                nullInd[0] = 1;
                exp[0] = new STRUCT(sdJmsException, db_conn, nullAttribs);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return -24197;
        }
    }

    public static int getErrorCode(Throwable t) {
        if (t instanceof JmsPlsException) {
            return ((JmsPlsException)t).getErrorCode();
        }
        lastExp = t;
        return -24197;
    }
}

