/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.Destination;
import javax.jms.InvalidDestinationException;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.MessageListener;
import javax.jms.MessageProducer;
import javax.jms.ObjectMessage;
import javax.jms.Queue;
import javax.jms.QueueBrowser;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.StreamMessage;
import javax.jms.TemporaryQueue;
import javax.jms.TemporaryTopic;
import javax.jms.TextMessage;
import javax.jms.Topic;
import javax.jms.TopicPublisher;
import javax.jms.TopicSession;
import javax.jms.TopicSubscriber;
import oracle.AQ.AQDriverManager;
import oracle.AQ.AQException;
import oracle.AQ.AQOracleAdmin;
import oracle.AQ.AQOracleAgent;
import oracle.AQ.AQOracleQueue;
import oracle.AQ.AQOracleQueueTable;
import oracle.AQ.AQOracleSession;
import oracle.AQ.AQQueueTable;
import oracle.AQ.AQQueueTableProperty;
import oracle.jdbc.OracleCallableStatement;
import oracle.jdbc.internal.OracleConnection;
import oracle.jms.AQjmsAdtMessage;
import oracle.jms.AQjmsAgent;
import oracle.jms.AQjmsBytesMessage;
import oracle.jms.AQjmsCliSubMapEntry;
import oracle.jms.AQjmsClientSubscriberMap;
import oracle.jms.AQjmsConnection;
import oracle.jms.AQjmsConstants;
import oracle.jms.AQjmsConsumer;
import oracle.jms.AQjmsDestination;
import oracle.jms.AQjmsDestinationProperty;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsGeneralDBConnection;
import oracle.jms.AQjmsInterOp;
import oracle.jms.AQjmsMapMessage;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsObject;
import oracle.jms.AQjmsObjectMessage;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsProducer;
import oracle.jms.AQjmsQueueBrowser;
import oracle.jms.AQjmsQueueSenderImpl;
import oracle.jms.AQjmsSelector;
import oracle.jms.AQjmsStreamMessage;
import oracle.jms.AQjmsTextMessage;
import oracle.jms.AQjmsTopicBrowser;
import oracle.jms.AQjmsTopicPublisherImpl;
import oracle.jms.AQjmsTopicReceiver;
import oracle.jms.AQjmsUtil;
import oracle.jms.AdtMessage;
import oracle.jms.EmulatedXAHandler;
import oracle.jms.TopicBrowser;
import oracle.sql.CustomDatum;
import oracle.sql.ORAData;
import oracle.sql.converter.CharacterSetMetaData;

public class AQjmsSession
extends AQjmsObject
implements QueueSession,
TopicSession {
    int cl_check_interval = AQjmsConstants.getCloseCheckInterval();
    AQjmsConnection jms_conn;
    int ack_mode;
    boolean transacted;
    int sess_type;
    private CallableStatement rems_stmt;
    private CallableStatement alts_stmt;
    private CallableStatement bind_stmt;
    private CallableStatement ubnd_stmt;
    private CallableStatement chks_stmt;
    private Hashtable cons_list;
    private QueueBrowser queue_browser;
    private MessageListener privileged_listener;
    long[] oci_handles = new long[3];
    long oci_aq_cntxt = 0L;
    short dbversion;
    OracleCallableStatement st_text = null;
    OracleCallableStatement st_bytes = null;
    OracleCallableStatement st_map = null;
    OracleCallableStatement st_stream = null;
    OracleCallableStatement st_object = null;
    OracleCallableStatement st_adt = null;
    OracleCallableStatement st_adt_rep = null;
    OracleCallableStatement deq_stmt = null;
    OracleCallableStatement st_array_enqueue = null;
    OracleCallableStatement st_array_text_enqueue = null;
    OracleCallableStatement st_array_bytes_enqueue = null;
    OracleCallableStatement st_array_stream_enqueue = null;
    OracleCallableStatement st_array_map_enqueue = null;
    OracleCallableStatement st_array_object_enqueue = null;
    OracleCallableStatement st_array_dequeue = null;
    OracleCallableStatement st_array_text_dequeue = null;
    OracleCallableStatement st_array_bytes_dequeue = null;
    OracleCallableStatement st_array_stream_dequeue = null;
    OracleCallableStatement st_array_map_dequeue = null;
    OracleCallableStatement st_array_object_dequeue = null;
    Connection db_conn = null;
    boolean cache_deq_stmt = false;
    static boolean loaded_library = false;
    private String clientSessionGUID = null;
    private static final Map<String, Map<String, Map<String, Topic>>> s_subt = new HashMap<String, Map<String, Map<String, Topic>>>();
    private final Object m_consync = new Object();
    private boolean compliant = AQjmsConstants.IS_COMPLIANT;
    private Thread closingThread = null;
    AQjmsGeneralDBConnection genConn = null;
    private String prevSubName = null;
    private EmulatedXAHandler xaHandler;
    private int db_max_bytes;
    private boolean sendConsistent = true;
    boolean wlsXaTopicNextDisabled;
    private Object m_lsync = new Object();
    private boolean m_inlis = false;
    private static final int MAX_SUBSCRIBER_LEN = 30;
    private static final int MAX_QUEUE_NAME_LEN = 24;
    private static final int MAX_QUEUETABLE_NAME_LEN = 24;

    AQjmsSession(AQjmsConnection jms_conn, int ack_mode, boolean transacted, int type, AQjmsGeneralDBConnection genConn) throws JMSException {
        super("Session", jms_conn);
        this.jms_conn = jms_conn;
        this.ack_mode = ack_mode;
        this.transacted = transacted;
        this.compliant = jms_conn.getCompliant();
        this.genConn = genConn;
        this.db_conn = genConn.getDBConnection();
        this.dbversion = jms_conn.getDBVersion();
        AQjmsOracleDebug.trace(5, "AQjmsSession.constructor", "dbversion=" + this.dbversion);
        this.setDBRatio();
        this.rems_stmt = null;
        this.alts_stmt = null;
        this.bind_stmt = null;
        this.ubnd_stmt = null;
        this.chks_stmt = null;
        if (type == 10 || type == 20 || type == 30) {
            this.sess_type = type;
        } else {
            AQjmsOracleDebug.trace(1, "AQjmsSession.constructor1", "Invalid type - not a Queue or Topic");
            AQjmsError.throwEx(122, "invalid type");
        }
        this.xaHandler = AQjmsConstants.useEmulatedXA() ? new EmulatedXAHandler(this.db_conn, this) : null;
        if (!this.isInTransactionRechecked() && ack_mode != 1 && ack_mode != 2 && ack_mode != 3) {
            AQjmsOracleDebug.trace(1, "AQjmsSession.constructor1", "Wrong ACKOWLEDGE MODE: ack_mode, setting it to AUTO_ACKNOWLEDGE");
            ack_mode = 1;
        }
        this.cons_list = new Hashtable();
        this.queue_browser = null;
        this.privileged_listener = null;
        this.cache_deq_stmt = false;
        AQjmsOracleDebug.trace(3, "AQjmsSession.constructor1", "oci enabled = " + AQDriverManager.isOciAQEnabled());
        this.getOCIHandles();
        if (this.hasOciAQContext() || this.getDriver().equalsIgnoreCase("thin") && AQjmsConstants.useJdbcAQ()) {
            this.setMultiRetry();
        }
        if (AQjmsConstants.ORDER_WITH_SELECTOR) {
            this.enableEventForMsgOrder();
        }
        if (!((oracle.jdbc.OracleConnection)this.db_conn).getUsingXAFlag()) {
            try {
                this.db_conn.setAutoCommit(false);
            }
            catch (SQLException sqe) {
                AQjmsError.throwEx("can not set autocommit for the db connection", (Throwable)sqe);
            }
        }
        jms_conn.attach(this);
    }

    boolean isKprb() {
        String protocol = ((OracleConnection)this.db_conn).getProtocolType();
        AQjmsOracleDebug.trace(3, "AQjmsSession.isKbrp", "protocol:" + protocol);
        return "kprb".equals(protocol);
    }

    private boolean isKnownSingleCharset(int csid) {
        return csid == 1 || csid == 2 || csid == 31;
    }

    private int getClientRatio() throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsSession.getClientRatio", "enter");
        short jdbcCsId = 0;
        try {
            jdbcCsId = ((OracleConnection)this.db_conn).getJdbcCsId();
        }
        catch (SQLException sqe) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.getClientRatio get the csid from jdbc", sqe);
            AQjmsError.throwEx("Failed to obtain the Client CSID from JDBC connection", (Throwable)sqe);
        }
        AQjmsOracleDebug.trace(5, "AQjmsSession.getClientRatio", "The Client csid = " + jdbcCsId);
        int client_max_bytes = 0;
        if (this.isKnownSingleCharset(jdbcCsId)) {
            client_max_bytes = 1;
        } else {
            int ratio = CharacterSetMetaData.getRatio((int)jdbcCsId, (int)2002);
            if (ratio == 0) {
                AQjmsError.throwEx("The Client CSID obtained from JDBC is bad", null);
            } else {
                client_max_bytes = ratio * 2;
            }
        }
        AQjmsOracleDebug.trace(5, "AQjmsSession.getClientRatio", "exit");
        return client_max_bytes;
    }

    private void setDBRatio() throws JMSException {
        AQjmsOracleDebug.trace(5, "AQjmsSession.setDBRatio", "enter");
        short dbCsId = 0;
        try {
            dbCsId = ((OracleConnection)this.db_conn).getDbCsId();
        }
        catch (SQLException sqe) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.setRatio get the csid from db", sqe);
            AQjmsError.throwEx("Failed to obtain the DB CSID from JDBC connection", (Throwable)sqe);
        }
        AQjmsOracleDebug.trace(5, "AQjmsSession.setRatio", "The DB csid = " + dbCsId);
        if (this.isKnownSingleCharset(dbCsId)) {
            this.db_max_bytes = 1;
        } else {
            int db_ratio = CharacterSetMetaData.getRatio((int)dbCsId, (int)2002);
            if (db_ratio == 0) {
                AQjmsError.throwEx("The DB CSID obtained from JDBC is bad", null);
            } else {
                this.db_max_bytes = db_ratio * 2;
            }
        }
        AQjmsOracleDebug.trace(5, "AQjmsSession.setRatio", "exit");
    }

    int maxBytes(int strlenUTF16) {
        return this.db_max_bytes * strlenUTF16;
    }

    boolean getCompliant() {
        AQjmsOracleDebug.trace(4, "AQjmsSession.getCompliant", "Session <compliant>:" + this.compliant);
        return this.compliant;
    }

    private native long ociinit(long[] var1, int var2, int var3, boolean var4, short var5, int var6, int var7) throws Exception;

    private native void ocifrctx(long[] var1, long var2, int var4) throws Exception;

    private native void ocibreak(long var1, long var3, long var5) throws Exception;

    public BytesMessage createBytesMessage() throws JMSException {
        AQjmsBytesMessage message = null;
        this.checkSessionStarted();
        message = new AQjmsBytesMessage(this);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createBytesMesage", "returning bytes message");
        return message;
    }

    public synchronized MapMessage createMapMessage() throws JMSException {
        AQjmsMapMessage message = null;
        this.checkSessionStarted();
        message = new AQjmsMapMessage(this);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createMapMessage", "returning map message");
        return message;
    }

    public synchronized Message createMessage() throws JMSException {
        AQjmsMessage message = null;
        this.checkSessionStarted();
        message = new AQjmsMessage(this, true);
        message.setHeaderOnly();
        AQjmsOracleDebug.trace(5, "AQjmsSession.createMessage", "return message");
        return message;
    }

    public synchronized ObjectMessage createObjectMessage() throws JMSException {
        AQjmsObjectMessage message = null;
        this.checkSessionStarted();
        message = new AQjmsObjectMessage(this);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createObjectMessage", "return object message");
        return message;
    }

    public synchronized ObjectMessage createObjectMessage(Serializable object) throws JMSException {
        AQjmsObjectMessage message = null;
        this.checkSessionStarted();
        message = new AQjmsObjectMessage(this);
        message.setObject(object);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createObjectMessage", "return initialized object message");
        return message;
    }

    public synchronized AdtMessage createAdtMessage() throws JMSException {
        AQjmsAdtMessage message = null;
        message = this.createAdtMessage(null);
        return message;
    }

    public synchronized AQjmsAdtMessage createAdtMessage(CustomDatum payload) throws JMSException {
        AQjmsAdtMessage message = null;
        this.checkSessionStarted();
        message = new AQjmsAdtMessage(this, payload);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createAdtMessage", "return adt message");
        return message;
    }

    public synchronized AdtMessage createORAMessage() throws JMSException {
        AQjmsAdtMessage message = null;
        message = this.createORAMessage(null);
        return message;
    }

    public synchronized AQjmsAdtMessage createORAMessage(ORAData payload) throws JMSException {
        AQjmsAdtMessage message = null;
        this.checkSessionStarted();
        message = new AQjmsAdtMessage(this, payload);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createAdtMessage", "return adt message");
        return message;
    }

    public synchronized StreamMessage createStreamMessage() throws JMSException {
        AQjmsStreamMessage message = null;
        this.checkSessionStarted();
        message = new AQjmsStreamMessage(this);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createStreamMessage", "return stream message");
        return message;
    }

    public synchronized TextMessage createTextMessage() throws JMSException {
        AQjmsTextMessage message = null;
        this.checkSessionStarted();
        message = new AQjmsTextMessage(this);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createTextMessage", "return text message");
        return message;
    }

    public synchronized TextMessage createTextMessage(StringBuffer stringBuffer) throws JMSException {
        AQjmsTextMessage message = null;
        this.checkSessionStarted();
        message = new AQjmsTextMessage(this);
        message.setText(stringBuffer.toString());
        AQjmsOracleDebug.trace(5, "AQjmsSession.createTextMessage", "return initialized text message");
        return message;
    }

    public synchronized TextMessage createTextMessage(String text) throws JMSException {
        AQjmsTextMessage message = null;
        this.checkSessionStarted();
        message = new AQjmsTextMessage(this);
        message.setText(text);
        AQjmsOracleDebug.trace(5, "AQjmsSession.createTextMessage", "return initialized text message");
        return message;
    }

    public synchronized boolean getTransacted() throws JMSException {
        this.checkSessionStarted();
        return this.transacted;
    }

    public synchronized int getAckMode() throws JMSException {
        this.checkSessionStarted();
        return this.ack_mode;
    }

    void checkConsistency() throws JMSException {
        if (!this.sendConsistent) {
            JMSException e = new JMSException("Cannot not commit in an inconsistent state, must rollback");
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.checkConsistency", e);
            throw e;
        }
    }

    void setConsistency(boolean state) {
        this.sendConsistent = state;
        if (!state && this.xaHandler != null) {
            this.xaHandler.setRollbackOnlyIfInGlobalTxn();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void commit() throws JMSException {
        this.checkSessionStarted();
        if (!this.transacted) {
            AQjmsError.throwIllegalStateEx(227, null);
        }
        if (!this.lock("commit", -1L)) {
            AQjmsError.throwEx(122);
        }
        try {
            this.commitNoCheck();
        }
        finally {
            this.unlock("commit");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forceCommit() throws JMSException {
        if (!this.lock("forceCommit", -1L)) {
            AQjmsError.throwEx(122);
        }
        try {
            this.commitNoCheck();
        }
        finally {
            this.unlock("forceCommit");
        }
    }

    synchronized void commitNoCheck() throws JMSException {
        this.checkConsistency();
        Connection db_conn = null;
        db_conn = this.getDBConnection();
        try {
            db_conn.commit();
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        if (!AQjmsConstants.ignorePriority()) {
            this.restartConsumers();
        }
    }

    public synchronized void rollback() throws JMSException {
        this.checkSessionStarted();
        if (!this.transacted) {
            AQjmsError.throwIllegalStateEx(228, null);
        }
        this.forceRollback();
    }

    synchronized void forceRollback() throws JMSException {
        Connection db_conn = null;
        db_conn = this.getDBConnection();
        try {
            db_conn.rollback();
            this.setConsistency(true);
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        this.restartConsumers();
    }

    void markClosed() {
        super.markClosed();
        if (this.lockedByReceive()) {
            this.cancelBlockingReceive();
        }
    }

    void cancelBlockingReceive() {
        try {
            if (this.oci_aq_cntxt != 0L) {
                String osName = AQjmsUtil.getSystemProperty("os.name");
                if (osName == null || !osName.toUpperCase().startsWith("WINDOWS")) {
                    AQjmsOracleDebug.trace(5, "AQjmsSession.cancelBlockingReceive", System.currentTimeMillis() + ": Calling OCIBreak");
                    this.ocibreak(this.getOCIServiceHandle(), this.getOCIErrorHandle(), this.oci_aq_cntxt);
                }
            } else {
                AQjmsOracleDebug.trace(5, "AQjmsSession.cancelBlockingReceive", System.currentTimeMillis() + ": Calling OracleConnection.cancel");
                if (this.db_conn != null) {
                    ((oracle.jdbc.OracleConnection)this.db_conn).cancel();
                }
            }
        }
        catch (Throwable t) {
            AQjmsOracleDebug.trace(4, "AQjmsSession.cancelBlockingReceive", "Got exception: " + t);
        }
    }

    protected synchronized void preClose() throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsSession.preClose", "ENTRY");
        Connection our_conn = this.getOurDBConnection();
        try {
            if (our_conn != null && !our_conn.isClosed()) {
                if (!this.isInGlobalTransactionRechecked() && !this.genConn.isExternal()) {
                    AQjmsOracleDebug.trace(4, "AQjmsSession.preClose", "abort txn");
                    our_conn.rollback();
                } else {
                    AQjmsOracleDebug.trace(4, "AQjmsSession.preClose", "not aborting txn");
                }
            }
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(1, "AQjmsSession.preClose: failed to rollback the transaction before close", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        AQjmsOracleDebug.trace(4, "AQjmsSession.preClose", "EXIT");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws JMSException {
        try {
            this.closingThread = Thread.currentThread();
            super.close();
        }
        finally {
            this.closingThread = null;
        }
    }

    protected synchronized void localClose() throws JMSException {
        Connection our_conn = null;
        AQjmsOracleDebug.trace(3, "AQjmsSession.closeSessionResources", "entry ...");
        if (this.clientSessionGUID != null) {
            try {
                this.removeAQNondurableSubscribers(this.clientSessionGUID);
            }
            catch (Throwable t) {
                AQjmsOracleDebug.traceEx(5, "AQjmsSession.close: removeAQNondurableSubscribers(" + this.clientSessionGUID + ")", t);
            }
        }
        our_conn = this.getOurDBConnection();
        try {
            if (this.oci_aq_cntxt != 0L && !our_conn.isClosed()) {
                this.freeOCIHandles();
            }
        }
        catch (Throwable t) {
            AQjmsOracleDebug.traceEx(5, "AQjmsSession.close: freeing oci handles", t);
        }
        try {
            if (this.rems_stmt != null) {
                this.rems_stmt.close();
                this.rems_stmt = null;
            }
            if (this.alts_stmt != null) {
                this.alts_stmt.close();
                this.alts_stmt = null;
            }
            if (this.bind_stmt != null) {
                this.bind_stmt.close();
                this.bind_stmt = null;
            }
            if (this.ubnd_stmt != null) {
                this.ubnd_stmt.close();
                this.ubnd_stmt = null;
            }
            if (this.chks_stmt != null) {
                this.chks_stmt.close();
                this.chks_stmt = null;
            }
        }
        catch (Throwable t) {
            AQjmsOracleDebug.traceEx(2, "AQjmsSession.close: close cached statements", t);
        }
        this.destroyStmt(this.st_text);
        this.destroyStmt(this.st_bytes);
        this.destroyStmt(this.st_map);
        this.destroyStmt(this.st_object);
        this.destroyStmt(this.st_stream);
        this.destroyStmt(this.st_adt);
        this.destroyStmt(this.st_adt_rep);
        this.destroyStmt(this.deq_stmt);
        this.destroyStmt(this.st_array_enqueue);
        this.destroyStmt(this.st_array_text_enqueue);
        this.destroyStmt(this.st_array_bytes_enqueue);
        this.destroyStmt(this.st_array_stream_enqueue);
        this.destroyStmt(this.st_array_map_enqueue);
        this.destroyStmt(this.st_array_object_enqueue);
        this.destroyStmt(this.st_array_dequeue);
        this.destroyStmt(this.st_array_text_dequeue);
        this.destroyStmt(this.st_array_bytes_dequeue);
        this.destroyStmt(this.st_array_stream_dequeue);
        this.destroyStmt(this.st_array_map_dequeue);
        this.destroyStmt(this.st_array_object_dequeue);
        try {
            AQjmsOracleDebug.trace(4, "AQjmsSession.closeSessionResources", "Closing general Connection");
            this.genConn.close();
        }
        catch (Throwable t) {
            AQjmsOracleDebug.traceEx(2, "AQjmsSession.close: close db connection", t);
        }
        this.jms_conn = null;
        this.db_conn = null;
        this.genConn = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void startListener() {
        Object object = this.m_lsync;
        synchronized (object) {
            this.m_inlis = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopListener() {
        Object object = this.m_lsync;
        synchronized (object) {
            this.m_inlis = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean inListener() {
        boolean ret = false;
        Object object = this.m_lsync;
        synchronized (object) {
            ret = this.m_inlis;
        }
        return ret;
    }

    public synchronized void recover() throws JMSException {
        this.checkSessionStarted();
        int ackMode = this.getAcknowledgeMode();
        if (ackMode == 0) {
            AQjmsError.throwIllegalStateEx(238, null);
        }
        Connection db_conn = null;
        if (ackMode == 2 || this.inListener()) {
            try {
                db_conn = this.getDBConnection();
                db_conn.rollback();
            }
            catch (SQLException sql_ex) {
                throw new AQjmsException(sql_ex);
            }
            this.restartConsumers();
        }
    }

    public synchronized MessageListener getMessageListener() throws JMSException {
        return this.privileged_listener;
    }

    public synchronized void setMessageListener(MessageListener listener) throws JMSException {
        this.privileged_listener = listener;
        Enumeration e = this.cons_list.elements();
        while (e.hasMoreElements()) {
            AQjmsConsumer cons = (AQjmsConsumer)e.nextElement();
            cons.setPrivilegedMessageListener(listener);
        }
    }

    public synchronized Queue createQueue(String queueName) throws JMSException {
        AQjmsOracleDebug.trace(3, "AQjmsSession.createQueue IN", "queuename: " + queueName);
        this.checkClosed("createQueue");
        if (this.sess_type == 20) {
            AQjmsError.throwIllegalStateEx(234, null);
        }
        String owner = this.getAQOwner(queueName);
        String name = this.getAQName(queueName);
        Queue q = null;
        try {
            q = this.getQueue(owner, name);
        }
        catch (Exception e) {
            AQjmsOracleDebug.traceEx(5, "AQjmsSession.createQueue: getQueue failed: ", e);
            AQjmsError.throwEx(190, queueName, e);
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.createQueue EXIT ", "");
        return q;
    }

    public synchronized QueueReceiver createReceiver(Queue queue) throws JMSException {
        AQjmsConsumer receiver = null;
        this.checkSessionStarted();
        if (queue == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(143));
        }
        if (!(queue instanceof AQjmsDestination) || !((AQjmsDestination)queue).isQueue()) {
            AQjmsError.throwInvalidDestEx(125);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "createReceiver after MessageListener of Session is set");
        }
        receiver = new AQjmsConsumer(this, (Destination)queue, 10, 3, null, null);
        this.cons_list.put(receiver, receiver);
        return receiver;
    }

    public synchronized QueueReceiver createReceiver(Queue queue, Object payload_factory) throws JMSException {
        AQjmsConsumer receiver = null;
        this.checkSessionStarted();
        if (queue == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(143));
        }
        if (!(queue instanceof AQjmsDestination) || !((AQjmsDestination)queue).isQueue()) {
            AQjmsError.throwInvalidDestEx(125);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "createReceiver after MessageListener of Session is set");
        }
        receiver = new AQjmsConsumer(this, (Destination)queue, 10, 3, null, payload_factory);
        this.cons_list.put(receiver, receiver);
        return receiver;
    }

    public QueueReceiver createReceiver(Queue queue, String messageSelector) throws JMSException {
        return this.createReceiver(queue, messageSelector, null);
    }

    public synchronized QueueReceiver createReceiver(Queue queue, String messageSelector, Object payload_factory) throws JMSException {
        AQjmsConsumer receiver = null;
        AQjmsSelector jms_sel = null;
        String p_data_type = null;
        this.checkSessionStarted();
        if (queue == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(143));
        }
        if (!(queue instanceof AQjmsDestination) || !((AQjmsDestination)queue).isQueue()) {
            AQjmsError.throwInvalidDestEx(125);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "createReceiver after MessageListener of Session is set");
        }
        if (messageSelector != null && !messageSelector.equals("")) {
            jms_sel = payload_factory != null ? new AQjmsSelector(messageSelector, 10, 2, this.is82compatible(), this.getCompliant()) : ((p_data_type = ((AQjmsDestination)queue).getAdtType()).equalsIgnoreCase("SYS.ANYDATA") ? new AQjmsSelector(messageSelector, 10, 3, this.is82compatible(), this.getCompliant()) : new AQjmsSelector(messageSelector, 10, 1, this.is82compatible(), this.getCompliant()));
        }
        AQjmsOracleDebug.trace(5, "AQjmsSession.createReceiver", "Selector: " + jms_sel);
        receiver = new AQjmsConsumer(this, (Destination)queue, 10, 3, null, payload_factory, jms_sel, null);
        this.cons_list.put(receiver, receiver);
        return receiver;
    }

    public synchronized QueueSender createSender(Queue queue) throws JMSException {
        AQjmsQueueSenderImpl sender = null;
        this.checkSessionStarted();
        if (!(queue == null || queue instanceof AQjmsDestination && ((AQjmsDestination)queue).isQueue())) {
            AQjmsError.throwInvalidDestEx(125);
        }
        sender = new AQjmsQueueSenderImpl(this, (AQjmsDestination)queue);
        return sender;
    }

    public QueueBrowser createBrowser(Queue queue) throws JMSException {
        return this.createBrowser(queue, null, null, false);
    }

    public QueueBrowser createBrowser(Queue queue, Object payload_factory) throws JMSException {
        return this.createBrowser(queue, null, payload_factory, false);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector) throws JMSException {
        return this.createBrowser(queue, messageSelector, null, false);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector, boolean locked) throws JMSException {
        return this.createBrowser(queue, messageSelector, null, locked);
    }

    public QueueBrowser createBrowser(Queue queue, String messageSelector, Object payload_factory) throws JMSException {
        return this.createBrowser(queue, messageSelector, payload_factory, false);
    }

    public synchronized QueueBrowser createBrowser(Queue queue, String messageSelector, Object payload_factory, boolean locked) throws JMSException {
        AQjmsQueueBrowser browser = null;
        int deq_mode = 1;
        AQjmsSelector jms_sel = null;
        String qname = null;
        String p_data_type = null;
        this.checkSessionStarted();
        if (queue == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(143));
        }
        if (this.sess_type == 20) {
            AQjmsError.throwIllegalStateEx(234, null);
        }
        if (!(queue instanceof AQjmsDestination) || !((AQjmsDestination)queue).isQueue()) {
            AQjmsError.throwInvalidDestEx(125);
        }
        qname = ((AQjmsDestination)queue).getCompleteName();
        if (locked) {
            deq_mode = 2;
        }
        if (messageSelector != null && !messageSelector.equals("")) {
            jms_sel = payload_factory != null ? new AQjmsSelector(messageSelector, 10, 2, this.is82compatible(), this.getCompliant()) : ((p_data_type = ((AQjmsDestination)queue).getAdtType()).equalsIgnoreCase("SYS.ANYDATA") ? new AQjmsSelector(messageSelector, 10, 3, this.is82compatible(), this.getCompliant()) : new AQjmsSelector(messageSelector, 10, 1, this.is82compatible(), this.getCompliant()));
        }
        browser = new AQjmsQueueBrowser((Session)this, (Destination)queue, 10, deq_mode, null, jms_sel, payload_factory);
        return browser;
    }

    public TopicBrowser createBrowser(Topic topic, String cons_name) throws JMSException {
        return this.createBrowser(topic, cons_name, null, null, false);
    }

    public TopicBrowser createBrowser(Topic topic, String cons_name, boolean locked) throws JMSException {
        return this.createBrowser(topic, cons_name, null, null, locked);
    }

    public TopicBrowser createBrowser(Topic topic, String cons_name, Object payload_factory) throws JMSException {
        return this.createBrowser(topic, cons_name, null, payload_factory, false);
    }

    public TopicBrowser createBrowser(Topic topic, String cons_name, Object payload_factory, boolean locked) throws JMSException {
        return this.createBrowser(topic, cons_name, null, payload_factory, locked);
    }

    public TopicBrowser createBrowser(Topic topic, String cons_name, String messageSelector) throws JMSException {
        return this.createBrowser(topic, cons_name, messageSelector, null, false);
    }

    public TopicBrowser createBrowser(Topic topic, String cons_name, String messageSelector, boolean locked) throws JMSException {
        return this.createBrowser(topic, cons_name, messageSelector, null, locked);
    }

    public TopicBrowser createBrowser(Topic topic, String cons_name, String messageSelector, Object payload_factory) throws JMSException {
        return this.createBrowser(topic, cons_name, messageSelector, payload_factory, false);
    }

    public synchronized TopicBrowser createBrowser(Topic topic, String cons_name, String messageSelector, Object payload_factory, boolean locked) throws JMSException {
        AQjmsTopicBrowser browser = null;
        int deq_mode = 1;
        AQjmsSelector jms_sel = null;
        String tname = null;
        String p_data_type = null;
        this.checkSessionStarted();
        if (this.dbversion < 9000) {
            AQjmsError.throwEx(102);
        }
        if (topic == null) {
            AQjmsError.throwEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        tname = ((AQjmsDestination)topic).getCompleteName();
        if (locked) {
            deq_mode = 2;
        }
        if (messageSelector != null && !messageSelector.equals("")) {
            jms_sel = payload_factory != null ? new AQjmsSelector(messageSelector, 20, 2, this.is82compatible(), this.getCompliant()) : ((p_data_type = ((AQjmsDestination)topic).getAdtType()).equalsIgnoreCase("SYS.ANYDATA") ? new AQjmsSelector(messageSelector, 20, 3, this.is82compatible(), this.getCompliant()) : new AQjmsSelector(messageSelector, 20, 1, this.is82compatible(), this.getCompliant()));
        }
        browser = new AQjmsTopicBrowser((Session)this, (Destination)topic, 20, deq_mode, cons_name, jms_sel, payload_factory);
        return browser;
    }

    public synchronized TemporaryQueue createTemporaryQueue() throws JMSException {
        this.checkSessionStarted();
        if (this.sess_type == 20) {
            AQjmsError.throwIllegalStateEx(234, null);
        }
        return this.makeTemporaryQueue(false);
    }

    public synchronized Topic createTopic(String topicName) throws JMSException {
        this.checkClosed("createQueue");
        if (this.sess_type == 10) {
            AQjmsError.throwIllegalStateEx(234, null);
        }
        String owner = this.getAQOwner(topicName);
        String name = this.getAQName(topicName);
        Topic t = null;
        try {
            t = this.getTopic(owner, name);
        }
        catch (Exception e) {
            AQjmsOracleDebug.traceEx(5, "AQjmsSession.createTopic: getTopic failed: ", e);
            AQjmsError.throwEx(243, topicName, e);
        }
        return t;
    }

    public TopicSubscriber createSubscriber(Topic topic) throws JMSException {
        this.checkSessionStarted();
        String subs_name = null;
        TopicSubscriber ret = null;
        if (AQjmsConstants.useAQNondurableSubscriber() && this.is112compatible()) {
            ret = this.addAQNondurableSubscriber(topic, null, false, null, null);
            subs_name = ((AQjmsConsumer)ret).cons_name;
        } else {
            subs_name = this.getSubsName();
            ret = this.createDurableSubscriber(topic, subs_name, null, false, null, null, true, true);
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.createSubscriber", "Created nondurable subscriber " + subs_name);
        return ret;
    }

    public TopicSubscriber createSubscriber(Topic topic, String messageSelector, boolean noLocal) throws JMSException {
        this.checkSessionStarted();
        String subs_name = null;
        TopicSubscriber ret = null;
        if (AQjmsConstants.useAQNondurableSubscriber() && this.is112compatible()) {
            ret = this.addAQNondurableSubscriber(topic, messageSelector, noLocal, null, null);
            subs_name = ((AQjmsConsumer)ret).cons_name;
        } else {
            subs_name = this.getSubsName();
            ret = this.createDurableSubscriber(topic, subs_name, messageSelector, noLocal, null, null, true, true);
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.createSubscriber", "Created nondurable subscriber " + subs_name);
        return ret;
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String subs_name) throws JMSException {
        return this.createDurableSubscriber(topic, subs_name, null, false, null, null);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String subs_name, Object payload_factory) throws JMSException {
        return this.createDurableSubscriber(topic, subs_name, null, false, payload_factory, null);
    }

    public TopicSubscriber createDurableSubscriber(Topic topic, String subs_name, String messageSelector, boolean noLocal) throws JMSException {
        return this.createDurableSubscriber(topic, subs_name, messageSelector, noLocal, null, null);
    }

    public synchronized TopicSubscriber createDurableSubscriber(Topic topic, String subs_name, String messageSelector, boolean noLocal, Object payload_factory) throws JMSException {
        return this.createDurableSubscriber(topic, subs_name, messageSelector, noLocal, payload_factory, null);
    }

    public synchronized TopicSubscriber createDurableSubscriber(Topic topic, String subs_name, String messageSelector, boolean noLocal, Object payload_factory, String transformation) throws JMSException {
        return this.createDurableSubscriber(topic, subs_name, messageSelector, noLocal, payload_factory, transformation, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized TopicSubscriber createDurableSubscriber(Topic topic, String subs_name, String messageSelector, boolean noLocal, Object payload_factory, String transformation, boolean forceOldMode, boolean emulateNondurable) throws JMSException {
        AQjmsAgent agent = null;
        TopicSubscriber subscriber = null;
        AQjmsSelector jms_sel = null;
        Connection db_conn = null;
        this.checkSessionStarted();
        if (this.sess_type == 10) {
            AQjmsError.throwIllegalStateEx(234, null);
        }
        db_conn = this.getDBConnection();
        if (subs_name == null) {
            AQjmsError.throwEx(116);
        }
        String choppedSubscription = AQjmsSession.chopit(subs_name, 30);
        if (topic == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(166));
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "createDurableSubscriber after MessageListener of Session is set");
        }
        try {
            agent = new AQjmsAgent();
            agent.setName(choppedSubscription);
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.createDurableSubscriber - error createing agent", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        jms_sel = this.getAQJmsSelector((AQjmsDestination)topic, messageSelector, noLocal, payload_factory);
        subscriber = !forceOldMode && this.getCompliant() ? this.createSubInCompliantMode(topic, choppedSubscription, messageSelector, jms_sel, noLocal, payload_factory, transformation, agent) : this.createSubInOldMode(topic, choppedSubscription, jms_sel, noLocal, payload_factory, transformation, agent);
        this.cons_list.put(subscriber, subscriber);
        AQjmsConsumer aqConsumer = (AQjmsConsumer)subscriber;
        aqConsumer.setDurable(!emulateNondurable);
        if (aqConsumer.isDurable()) {
            String clientId = this.jms_conn.getClientIDForce();
            Map<String, Map<String, Map<String, Topic>>> map = s_subt;
            synchronized (map) {
                Map<String, Topic> name2topic;
                Map<String, Map<String, Topic>> cid2subs = s_subt.get(this.genConn.providerKey);
                if (cid2subs == null) {
                    cid2subs = new HashMap<String, Map<String, Topic>>();
                    s_subt.put(this.genConn.providerKey, cid2subs);
                }
                if ((name2topic = cid2subs.get(clientId)) == null) {
                    name2topic = new HashMap<String, Topic>();
                    cid2subs.put(clientId, name2topic);
                }
                name2topic.put(subs_name, topic);
            }
        }
        return subscriber;
    }

    private AQjmsSelector getAQJmsSelector(AQjmsDestination topic, String messageSelector, boolean noLocal, Object payload_factory) throws JMSException {
        String ptype = null;
        AQjmsSelector jms_sel = null;
        ptype = topic.getAdtType();
        boolean isJMSType = ptype.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE");
        String fixedSelector = messageSelector;
        if (noLocal && isJMSType) {
            fixedSelector = messageSelector == null || messageSelector.trim().equals("") ? "JMS_OracleConnectionID <> '" + this.jms_conn.getConnectionID() + "'" : "(" + messageSelector + ") and (JMS_OracleConnectionID <> '" + this.jms_conn.getConnectionID() + "')";
            AQjmsOracleDebug.trace(5, "AQjmsSession.getAQJmsSelector", "The fixed selector for noLocal option is: " + fixedSelector);
        }
        if (fixedSelector != null && !fixedSelector.equals("")) {
            if (isJMSType) {
                jms_sel = new AQjmsSelector(fixedSelector, 20, 1, this.is82compatible(), this.getCompliant());
            } else if (ptype.equalsIgnoreCase("SYS.ANYDATA")) {
                jms_sel = new AQjmsSelector(fixedSelector, 20, 3, this.is82compatible(), this.getCompliant());
            } else {
                if (payload_factory == null) {
                    AQjmsError.throwEx(137);
                }
                jms_sel = new AQjmsSelector(fixedSelector, 20, 2, this.is82compatible(), this.getCompliant());
            }
        }
        return jms_sel;
    }

    private TopicSubscriber createSubInCompliantMode(Topic topic, String subs_name, String messageSelector, AQjmsSelector jms_sel, boolean noLocal, Object payload_factory, String transformation, AQjmsAgent agent) throws JMSException {
        TopicSubscriber subscriber = null;
        String clientID = this.jms_conn.getClientIDForce();
        AQjmsCliSubMapEntry entry = AQjmsClientSubscriberMap.createClientSubscriber(clientID, subs_name, topic, messageSelector, noLocal, this.jms_conn.getConnectionID(), transformation);
        if (entry == null) {
            AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "The subscriber " + subs_name + " is NOT in subscriber map.");
        } else {
            AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "The subscriber " + subs_name + " is in subscriber map.");
        }
        if (this.checkSubscriberExists(topic, agent)) {
            AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "The subscriber " + subs_name + " is in database.");
            if (entry == null) {
                AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "The subscriber " + subs_name + " is not in subscribers map in memory.");
                try {
                    subscriber = this.alterDurableSubscriber(topic, agent, jms_sel, noLocal, payload_factory, false, transformation);
                    AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "alterDurableSubscriber is called.");
                }
                catch (AQjmsException aq_ex) {
                    AQjmsOracleDebug.trace(3, "AQjmsSession.createSubInCompliantMode - aq_ex", "error number: " + aq_ex.getErrorNumber());
                    if (aq_ex.getErrorNumber() == 1031 && ((AQjmsDestination)topic).isSecure()) {
                        AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "secure queue - agent exists");
                        subscriber = new AQjmsConsumer(this, (Destination)topic, 20, 3, subs_name, payload_factory, jms_sel, transformation);
                    }
                    AQjmsClientSubscriberMap.removeClientSubscriber(clientID, subs_name);
                    throw aq_ex;
                }
            } else {
                AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "The subscriber " + subs_name + " is in subscribers map in memory.");
                boolean nochange = false;
                try {
                    nochange = AQjmsUtil.topicEquals((AQjmsDestination)topic, (AQjmsDestination)entry.m_topic) && AQjmsUtil.selectorEquals(messageSelector, entry.m_selector);
                }
                catch (JMSException aq_ex) {
                    AQjmsClientSubscriberMap.recoverClientSubscriber(clientID, subs_name, entry);
                    throw aq_ex;
                }
                if (nochange) {
                    AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "the topic and selector are the same for old and new subscribers");
                    AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "Always alter the subscriber.");
                    try {
                        subscriber = this.alterDurableSubscriber(topic, agent, jms_sel, noLocal, payload_factory, false, transformation);
                    }
                    catch (AQjmsException aq_ex) {
                        AQjmsOracleDebug.trace(3, "AQjmsSession.createSubInCompliantMode-2 - aq_ex", "error number: " + aq_ex.getErrorNumber());
                        if (aq_ex.getErrorNumber() == 1031 && ((AQjmsDestination)topic).isSecure()) {
                            AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "secure queue - agent exists");
                            subscriber = new AQjmsConsumer(this, (Destination)topic, 20, 3, subs_name, payload_factory, jms_sel, transformation);
                        }
                        AQjmsClientSubscriberMap.recoverClientSubscriber(clientID, subs_name, entry);
                        throw aq_ex;
                    }
                } else {
                    AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "the topic and selector are different for old and new subscribers");
                    try {
                        this.removeSubscriber(entry.m_topic, agent);
                        subscriber = this.addDurableSubscriber(topic, agent, jms_sel, noLocal, payload_factory, false, transformation, false);
                        AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "The subscriber is removed and then recreated.");
                    }
                    catch (AQjmsException aq_ex) {
                        AQjmsOracleDebug.trace(3, "AQjmsSession.createSubInCompliantMode - aq_ex", "error number: " + aq_ex.getErrorNumber());
                        AQjmsClientSubscriberMap.removeClientSubscriber(clientID, subs_name);
                        throw aq_ex;
                    }
                }
            }
        } else {
            AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "The subscriber " + subs_name + " is not in database.");
            try {
                if (entry != null && !AQjmsUtil.topicEquals((AQjmsDestination)topic, (AQjmsDestination)entry.m_topic)) {
                    AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "Recreate the subscriber with same name but different topic.");
                    try {
                        this.removeSubscriber(entry.m_topic, agent);
                    }
                    catch (AQjmsException aq_jex) {
                        if (aq_jex.getErrorNumber() == 24035) {
                            AQjmsOracleDebug.trace(3, "AQjmsSession.createSubInCompliantMode - aq_jex", "error number: " + aq_jex.getErrorNumber());
                        }
                        throw aq_jex;
                    }
                    AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInCompliantMode", "The subscriber is removed and then recreated.");
                }
                subscriber = this.addDurableSubscriber(topic, agent, jms_sel, noLocal, payload_factory, false, transformation, false);
            }
            catch (AQjmsException aq_ex) {
                AQjmsOracleDebug.trace(3, "AQjmsSession.createSubInCompliantMode - aq_ex", "error number: " + aq_ex.getErrorNumber());
                AQjmsClientSubscriberMap.removeClientSubscriber(clientID, subs_name);
                throw aq_ex;
            }
        }
        return subscriber;
    }

    private TopicSubscriber createSubInOldMode(Topic topic, String subs_name, AQjmsSelector jms_sel, boolean noLocal, Object payload_factory, String transformation, AQjmsAgent agent) throws JMSException {
        TopicSubscriber subscriber = null;
        try {
            subscriber = this.addDurableSubscriber(topic, agent, jms_sel, noLocal, payload_factory, false, transformation, false);
        }
        catch (AQjmsException aq_ex) {
            AQjmsOracleDebug.trace(3, "AQjmsSession.createSubInOldMode - aq_ex", "error number: " + aq_ex.getErrorNumber());
            if (aq_ex.getErrorNumber() == 1031 && ((AQjmsDestination)topic).isSecure()) {
                AQjmsOracleDebug.trace(5, "AQjmsSession.createSubInOldMode", "secure queue - check if agent exists");
                if (this.checkSubscriberExists(topic, agent)) {
                    subscriber = new AQjmsConsumer(this, (Destination)topic, 20, 3, subs_name, payload_factory, jms_sel, transformation);
                }
                throw aq_ex;
            }
            if (aq_ex.getErrorNumber() == 24034) {
                subscriber = this.alterDurableSubscriber(topic, agent, jms_sel, noLocal, payload_factory, false, transformation);
            }
            throw aq_ex;
        }
        return subscriber;
    }

    public TopicSubscriber forceCreateOldSubscriber(Topic topic, String subs_name) throws JMSException {
        return this.createDurableSubscriber(topic, subs_name, null, false, null, null, true, false);
    }

    public TopicSubscriber forceCreateOldSubscriber(Topic topic, String subs_name, Object payload_factory) throws JMSException {
        return this.createDurableSubscriber(topic, subs_name, null, false, payload_factory, null, true, false);
    }

    public TopicSubscriber forceCreateOldSubscriber(Topic topic, String subs_name, String selector, Object payload_factory) throws JMSException {
        return this.createDurableSubscriber(topic, subs_name, selector, false, payload_factory, null, true, false);
    }

    public TopicSubscriber forceCreateOldSubscriber(Topic topic, String subs_name, String selector, boolean noLocal) throws JMSException {
        return this.createDurableSubscriber(topic, subs_name, selector, noLocal, null, null, true, false);
    }

    public TopicSubscriber forceCreateOldSubscriber(Topic topic, String subs_name, String selector, boolean noLocal, Object payload_factory, String transformation) throws JMSException {
        return this.createDurableSubscriber(topic, subs_name, selector, noLocal, payload_factory, transformation, true, false);
    }

    public TopicSubscriber getDurableSubscriber(Topic topic, String subs_name) throws JMSException, InvalidDestinationException {
        return this.getDurableSubscriber(topic, subs_name, null);
    }

    public synchronized TopicSubscriber getDurableSubscriber(Topic topic, String subs_name, Object payload_factory) throws JMSException, InvalidDestinationException {
        AQjmsOracleDebug.trace(5, "AQjmsSession.getDurableSubscriber", "entry");
        AQjmsConsumer subscriber = null;
        this.checkSessionStarted();
        if (subs_name == null) {
            AQjmsError.throwEx(116);
        }
        if (topic == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(166));
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "getDurableSubscriber after MessageListener of Session is set");
        }
        subs_name = AQjmsSession.chopit(subs_name, 30);
        AQjmsAgent agent = null;
        try {
            agent = new AQjmsAgent();
            agent.setName(subs_name);
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.getDurableSubscriber - error createing agent", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        if (!this.checkSubscriberExists(topic, agent)) {
            AQjmsOracleDebug.trace(3, "AQjmsSession.getDurableSubscriber", "subscriber is not in database, return null!!!");
            return null;
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.getDurableSubscriber", "found the subscriber in the database");
        String clientID = this.jms_conn.getClientIDForce();
        AQjmsCliSubMapEntry entry = AQjmsClientSubscriberMap.addClientSubscriber(clientID, subs_name, topic);
        if (entry != null) {
            AQjmsOracleDebug.trace(3, "AQjmsSession.getDurableSubscriber", "found the subscriber in the map");
            AQjmsSelector jms_sel = this.getAQJmsSelector((AQjmsDestination)topic, entry.m_selector, entry.m_noLocal, payload_factory);
            subscriber = new AQjmsConsumer(this, (Destination)topic, 20, 3, subs_name, payload_factory, jms_sel, entry.m_transformation, entry.m_noLocal, true);
        } else {
            AQjmsOracleDebug.trace(3, "AQjmsSession.getDurableSubscriber", "Did not found the subscriber in the map");
            subscriber = new AQjmsConsumer(this, (Destination)topic, 20, 3, subs_name, payload_factory, null, null, false, false);
        }
        this.cons_list.put(subscriber, subscriber);
        AQjmsOracleDebug.trace(5, "AQjmsSession.getDurableSubscriber", "exit");
        return subscriber;
    }

    public synchronized void createRemoteSubscriber(Topic topic, AQjmsAgent remote_subscriber, String messageSelector) throws JMSException {
        this.createRemoteSubscriber(topic, remote_subscriber, messageSelector, null, null, false);
    }

    public synchronized void createRemoteSubscriber(Topic topic, AQjmsAgent remote_subscriber, String messageSelector, Object payload_factory) throws JMSException {
        this.createRemoteSubscriber(topic, remote_subscriber, messageSelector, payload_factory, null, false);
    }

    public synchronized void createRemoteSubscriber(Topic topic, AQjmsAgent remote_subscriber, String messageSelector, Object payload_factory, String transformation) throws JMSException {
        this.createRemoteSubscriber(topic, remote_subscriber, messageSelector, payload_factory, transformation, false);
    }

    public synchronized void createRemoteSubscriber(Topic topic, AQjmsAgent remote_subscriber, String messageSelector, Object payload_factory, String transformation, boolean queueToQueue) throws JMSException {
        AQjmsSelector jms_sel = null;
        Connection db_conn = null;
        String ptype = null;
        String remote_dest = null;
        db_conn = this.getDBConnection();
        if (remote_subscriber == null) {
            AQjmsError.throwEx(105);
        }
        try {
            remote_dest = remote_subscriber.getAddress();
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.createRemoteSubscriber1 - get address of remote subscriber", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        if (remote_dest == null || remote_dest.equals("")) {
            AQjmsError.throwEx(197);
        }
        if (topic == null) {
            AQjmsError.throwEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (messageSelector != null && !messageSelector.equals("")) {
            ptype = ((AQjmsDestination)topic).getAdtType();
            if (ptype.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                jms_sel = new AQjmsSelector(messageSelector, 20, 1, this.is82compatible(), this.getCompliant());
            } else if (ptype.equalsIgnoreCase("SYS.ANYDATA")) {
                jms_sel = new AQjmsSelector(messageSelector, 20, 3, this.is82compatible(), this.getCompliant());
            } else {
                if (payload_factory == null) {
                    AQjmsError.throwEx(137);
                }
                jms_sel = new AQjmsSelector(messageSelector, 20, 2, this.is82compatible(), this.getCompliant());
            }
        }
        try {
            this.addDurableSubscriber(topic, remote_subscriber, jms_sel, false, null, true, transformation, queueToQueue);
        }
        catch (AQjmsException aq_ex) {
            AQjmsOracleDebug.trace(3, "AQjmsSession.createRemoteSubscriber - aq_ex", "error number: " + aq_ex.getErrorNumber());
            if (aq_ex.getErrorNumber() == 24034) {
                this.alterDurableSubscriber(topic, remote_subscriber, jms_sel, false, null, true, transformation);
            }
            throw aq_ex;
        }
    }

    synchronized void removeRemoteSubscriber(Topic topic, AQjmsAgent remote_subscriber) throws JMSException {
        String remote_dest = null;
        Connection db_conn = null;
        db_conn = this.getDBConnection();
        if (remote_subscriber == null) {
            AQjmsError.throwEx(105);
        }
        try {
            remote_dest = remote_subscriber.getAddress();
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.removeRemoteSubscriber2 - get address of remote subscriber", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        if (remote_dest == null || remote_dest.equals("")) {
            AQjmsError.throwEx(197);
        }
        if (topic == null) {
            AQjmsError.throwEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        this.removeSubscriber(topic, remote_subscriber);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized boolean checkSubscriberExists(Topic topic, AQjmsAgent agent) {
        String t_name = "";
        String subs_name = "";
        AQOracleAgent agt = null;
        Map<String, Class<?>> map = null;
        String subs_addr = null;
        int subs_prot = 0;
        Connection db_conn = null;
        int s_exists = 0;
        AQjmsOracleDebug.trace(5, "AQjmsSession.checkSubscriberExists", "entry");
        try {
            if (agent == null) {
                AQjmsError.throwEx(105);
            }
            db_conn = this.getDBConnection();
            subs_name = agent.getName();
            subs_addr = agent.getAddress();
            subs_prot = agent.getProtocol();
            t_name = ((AQjmsDestination)topic).getCompleteName();
            try {
                map = db_conn.getTypeMap();
            }
            catch (Exception ex) {
                AQjmsError.throwEx(112, (Throwable)ex);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception ex) {
                AQjmsError.throwEx(146, (Throwable)ex);
            }
            agt = new AQOracleAgent(subs_name, subs_addr, subs_prot);
            AQjmsOracleDebug.trace(5, "AQjmsSession.checkSubscriberExists", "subs_name: " + subs_name + " subs_addr: " + subs_addr + " subs_prot: " + subs_prot);
            if (this.chks_stmt != null) {
                this.chks_stmt.clearParameters();
            } else {
                AQjmsOracleDebug.trace(5, "AQjmsSession.checkSubscriberExists", "before subs_exists t_name: " + t_name);
                String checkStmtStr = AQjmsInterOp.getCheckStmtByVersion(this.dbversion);
                AQjmsOracleDebug.trace(5, "AQjmsSession.checkSubscriberExists", "subscriber_exists statement: " + checkStmtStr);
                this.chks_stmt = db_conn.prepareCall(checkStmtStr);
            }
            this.chks_stmt.setString(1, t_name);
            this.chks_stmt.setObject(2, (Object)agt, 2002);
            this.chks_stmt.setObject(3, (Object)1);
            this.chks_stmt.registerOutParameter(4, 2);
            this.chks_stmt.registerOutParameter(5, 12);
            this.chks_stmt.registerOutParameter(6, 12);
            this.chks_stmt.registerOutParameter(7, 12);
            if (this.is10compatible()) {
                this.chks_stmt.registerOutParameter(8, 12);
                this.chks_stmt.registerOutParameter(9, 2);
                this.chks_stmt.executeQuery();
                s_exists = this.chks_stmt.getInt(9);
            } else {
                this.chks_stmt.registerOutParameter(8, 2);
                this.chks_stmt.executeQuery();
                s_exists = this.chks_stmt.getInt(8);
            }
        }
        catch (SQLException sqlex) {
            try {
                this.chks_stmt.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.chks_stmt = null;
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.checkSubscriberExists-sqlex", sqlex);
            s_exists = 0;
        }
        catch (Exception ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.checkSubscriberExists-ex", ex);
            s_exists = 0;
        }
        finally {
            AQjmsOracleDebug.trace(3, "AQjmsSession.checkSubscriberExists", "always close the check stmt");
            if (this.chks_stmt != null) {
                try {
                    this.chks_stmt.close();
                }
                catch (Exception ex) {}
                this.chks_stmt = null;
            }
        }
        AQjmsOracleDebug.trace(5, "AQjmsSession.checkSubscriberExists", "exit s_exists=" + s_exists);
        return s_exists == 1;
    }

    public synchronized AQjmsTopicReceiver createTopicReceiver(Topic topic, String receiver_name, String messageSelector) throws JMSException {
        return this.createTopicReceiver(topic, receiver_name, messageSelector, null);
    }

    public synchronized AQjmsTopicReceiver createTopicReceiver(Topic topic, String receiver_name, String messageSelector, Object payload_factory) throws JMSException {
        AQjmsConsumer receiver = null;
        AQjmsSelector jms_sel = null;
        String p_data_type = null;
        this.checkSessionStarted();
        if (topic == null) {
            AQjmsError.throwEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "createTopicReceiver after MessageListener is set");
        }
        if (messageSelector != null && !messageSelector.equals("")) {
            jms_sel = payload_factory != null ? new AQjmsSelector(messageSelector, 10, 2, this.is82compatible(), this.getCompliant()) : ((p_data_type = ((AQjmsDestination)topic).getAdtType()).equalsIgnoreCase("SYS.ANYDATA") ? new AQjmsSelector(messageSelector, 10, 3, this.is82compatible(), this.getCompliant()) : new AQjmsSelector(messageSelector, 10, 1, this.is82compatible(), this.getCompliant()));
        }
        receiver = new AQjmsConsumer(this, (Destination)topic, 20, 3, receiver_name, payload_factory, jms_sel, null);
        this.cons_list.put(receiver, receiver);
        return receiver;
    }

    private synchronized TopicSubscriber addDurableSubscriber(Topic topic, AQjmsAgent agent, AQjmsSelector jms_sel, boolean noLocal, Object payload_factory, boolean remote, String transformation, boolean queueToQueue) throws JMSException {
        String t_name = "";
        String subs_name = "";
        AQOracleAgent agt = null;
        Map<String, Class<?>> map = null;
        String subs_addr = null;
        int subs_prot = 0;
        String rule = null;
        AQjmsConsumer subscriber = null;
        Connection db_conn = null;
        db_conn = this.getDBConnection();
        if (topic == null) {
            AQjmsError.throwInvalidDestEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (agent == null) {
            AQjmsError.throwEx(105);
        }
        Statement adds_stmt = null;
        try {
            subs_name = agent.getName();
            subs_addr = agent.getAddress();
            subs_prot = agent.getProtocol();
            t_name = ((AQjmsDestination)topic).getCompleteName();
            try {
                map = db_conn.getTypeMap();
            }
            catch (Exception ex) {
                AQjmsError.throwEx(112, (Throwable)ex);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception ex) {
                AQjmsError.throwEx(146, (Throwable)ex);
            }
            agt = new AQOracleAgent(subs_name, subs_addr, subs_prot);
            if (jms_sel != null) {
                if (jms_sel.getSelectorType() == 10) {
                    rule = jms_sel.getRule();
                    AQjmsOracleDebug.trace(5, "AQjmsSession.addDurableSubscriber", "Rule: " + rule);
                } else if (jms_sel.getSelectorType() == 40) {
                    rule = jms_sel.getAdtRule();
                }
            }
            String addStmtStr = AQjmsInterOp.getAddSubStmtByVersion(this.dbversion, queueToQueue);
            AQjmsOracleDebug.trace(5, "AQjmsSession.addDurableSubscriber", "add_subscriber statement:" + addStmtStr);
            adds_stmt = db_conn.prepareCall(addStmtStr);
            adds_stmt.setString(1, t_name);
            adds_stmt.setObject(2, agt, 2002);
            adds_stmt.setString(3, rule);
            if (this.is82compatible()) {
                adds_stmt.setString(4, transformation);
                if (this.is92compatible()) {
                    if (((AQjmsDestination)topic).isSecure()) {
                        adds_stmt.setInt(5, 1);
                    } else {
                        adds_stmt.setInt(5, 0);
                    }
                }
            }
            adds_stmt.execute();
        }
        catch (SQLException sqlex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.addDurableSubscriber", sqlex);
            throw new AQjmsException(sqlex);
        }
        finally {
            try {
                if (adds_stmt != null) {
                    adds_stmt.close();
                }
            }
            catch (Exception ex) {}
        }
        if (!remote) {
            subscriber = new AQjmsConsumer(this, (Destination)topic, 20, 3, subs_name, payload_factory, jms_sel, transformation, noLocal);
            this.cons_list.put(subscriber, subscriber);
            return subscriber;
        }
        return null;
    }

    private synchronized TopicSubscriber addAQNondurableSubscriber(Topic topic, String messageSelector, boolean noLocal, Object payloadFactory, String transformation) throws JMSException {
        Connection dbConn = this.getDBConnection();
        if (this.sess_type == 10) {
            AQjmsError.throwIllegalStateEx(234, null);
        }
        if (topic == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(166));
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "create subscriber after MessageListener of Session is set");
        }
        AQjmsSelector jmsSelector = this.getAQJmsSelector((AQjmsDestination)topic, messageSelector, noLocal, payloadFactory);
        String addSubStmtStr = AQjmsInterOp.getAddAQNondurableSubStmtByVersion(this.dbversion);
        AQjmsOracleDebug.trace(5, "AQjmsSession.addAQNondurableSubscriber", "add nondurable subscriber statement: " + addSubStmtStr);
        String topicName = ((AQjmsDestination)topic).getCompleteName();
        String rule = null;
        if (jmsSelector != null) {
            if (jmsSelector.getSelectorType() == 10) {
                rule = jmsSelector.getRule();
            } else if (jmsSelector.getSelectorType() == 40) {
                rule = jmsSelector.getAdtRule();
            }
        }
        CallableStatement addSubStmt = null;
        String subscriberName = null;
        try {
            addSubStmt = dbConn.prepareCall(addSubStmtStr);
            addSubStmt.setString(1, topicName);
            addSubStmt.setString(2, rule);
            addSubStmt.setString(3, transformation);
            if (this.clientSessionGUID == null) {
                addSubStmt.setString(4, null);
                addSubStmt.registerOutParameter(4, 12);
            } else {
                addSubStmt.setString(4, this.clientSessionGUID);
            }
            addSubStmt.registerOutParameter(5, 12);
            addSubStmt.execute();
            subscriberName = addSubStmt.getString(5);
            AQjmsOracleDebug.trace(5, "AQjmsSession.addAQNondurableSubscriber", "subscriber name: " + subscriberName);
            if (this.clientSessionGUID == null) {
                this.clientSessionGUID = addSubStmt.getString(4);
                AQjmsOracleDebug.trace(5, "AQjmsSession.addAQNondurableSubscriber", "session GUID: " + this.clientSessionGUID);
            }
        }
        catch (SQLException sqlex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.addAQNondurableSubscriber", sqlex);
            throw new AQjmsException(sqlex);
        }
        finally {
            try {
                if (addSubStmt != null) {
                    addSubStmt.close();
                }
            }
            catch (Exception ex) {}
        }
        AQjmsConsumer subscriber = new AQjmsConsumer(this, (Destination)topic, 20, 3, subscriberName, payloadFactory, jmsSelector, transformation, noLocal);
        subscriber.setDurable(false);
        this.cons_list.put(subscriber, subscriber);
        return subscriber;
    }

    private void removeAQNondurableSubscribers(String sessGUID) throws JMSException {
        Connection dbConn = this.getOurDBConnection();
        String removeSubsStmtStr = AQjmsInterOp.getRemoveAQNondurableSubsStmtByVersion(this.dbversion);
        AQjmsOracleDebug.trace(5, "AQjmsSession.removeAQNondurableSubscribers", "remove nondurable subscribers by session GUID statement: " + removeSubsStmtStr);
        CallableStatement stmt = null;
        try {
            stmt = dbConn.prepareCall(removeSubsStmtStr);
            AQjmsOracleDebug.trace(5, "AQjmsSession.removeAQNondurableSubscribers", "session GUID : " + sessGUID);
            stmt.setString(1, sessGUID);
            stmt.execute();
        }
        catch (SQLException sqlex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.removeAQNondurableSubscribers", sqlex);
            throw new AQjmsException(sqlex);
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    private synchronized TopicSubscriber alterDurableSubscriber(Topic topic, AQjmsAgent agent, AQjmsSelector jms_sel, boolean noLocal, Object payload_factory, boolean remote, String transformation) throws JMSException {
        String t_name = "";
        String subs_name = "";
        AQOracleAgent agt = null;
        Map<String, Class<?>> map = null;
        String subs_addr = null;
        int subs_prot = 0;
        String rule = null;
        AQjmsConsumer subscriber = null;
        Connection db_conn = null;
        db_conn = this.getDBConnection();
        if (topic == null) {
            AQjmsError.throwInvalidDestEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (agent == null) {
            AQjmsError.throwEx(105);
        }
        try {
            subs_name = agent.getName();
            subs_addr = agent.getAddress();
            subs_prot = agent.getProtocol();
            t_name = ((AQjmsDestination)topic).getCompleteName();
            try {
                map = db_conn.getTypeMap();
            }
            catch (Exception ex) {
                AQjmsError.throwEx(112, (Throwable)ex);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception ex) {
                AQjmsError.throwEx(146);
            }
            agt = new AQOracleAgent(subs_name, subs_addr, subs_prot);
            if (jms_sel != null) {
                if (jms_sel.getSelectorType() == 10) {
                    rule = jms_sel.getRule();
                    AQjmsOracleDebug.trace(5, "AQjmsSession.alterDurableSubscriber", "Rule: " + rule);
                } else if (jms_sel.getSelectorType() == 40) {
                    rule = jms_sel.getAdtRule();
                    AQjmsOracleDebug.trace(5, "AQjmsSession.alterDurableSubscriber", "Alter Rule: " + rule);
                }
            }
            if (this.alts_stmt != null) {
                this.alts_stmt.clearParameters();
            } else {
                String alterStmtStr = AQjmsInterOp.getAlterSubStmtByVersion(this.dbversion);
                AQjmsOracleDebug.trace(5, "AQjmsSession.alterDurableSubscriber", "alter_subscriber statement : " + alterStmtStr);
                this.alts_stmt = db_conn.prepareCall(alterStmtStr);
            }
            this.alts_stmt.setString(1, t_name);
            this.alts_stmt.setObject(2, (Object)agt, 2002);
            this.alts_stmt.setString(3, rule);
            if (this.is82compatible()) {
                this.alts_stmt.setString(4, transformation);
                if (this.is92compatible()) {
                    if (((AQjmsDestination)topic).isSecure()) {
                        this.alts_stmt.setInt(5, 1);
                    } else {
                        this.alts_stmt.setInt(5, 0);
                    }
                }
            }
            this.alts_stmt.execute();
            AQjmsOracleDebug.trace(5, "AQjmsSession.alterDurableSubscriber", "Alter Subscriber");
        }
        catch (SQLException sqlex) {
            try {
                this.alts_stmt.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.alts_stmt = null;
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.alterDurableSubscriber", sqlex);
            throw new AQjmsException(sqlex);
        }
        if (!remote) {
            subscriber = new AQjmsConsumer(this, (Destination)topic, 20, 3, subs_name, payload_factory, jms_sel, transformation, noLocal);
            this.cons_list.put(subscriber, subscriber);
            return subscriber;
        }
        return null;
    }

    boolean diffSubName(String cons_name) {
        if (this.prevSubName == null || !this.prevSubName.equalsIgnoreCase(cons_name)) {
            this.prevSubName = cons_name;
            return true;
        }
        return false;
    }

    public synchronized TopicPublisher createPublisher(Topic topic) throws JMSException {
        AQjmsTopicPublisherImpl publisher = null;
        this.checkSessionStarted();
        if (!(topic == null || topic instanceof AQjmsDestination && ((AQjmsDestination)topic).isTopic())) {
            AQjmsError.throwInvalidDestEx(126);
        }
        publisher = new AQjmsTopicPublisherImpl(this, (AQjmsDestination)topic);
        return publisher;
    }

    public synchronized TemporaryTopic createTemporaryTopic() throws JMSException {
        this.checkSessionStarted();
        if (this.sess_type == 10) {
            AQjmsError.throwIllegalStateEx(234, null);
        }
        return this.makeTemporaryQueue(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unsubscribe(String subs_name) throws JMSException {
        this.checkSessionStarted();
        if (this.sess_type == 10) {
            AQjmsError.throwIllegalStateEx(234, null);
        }
        if (subs_name == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(235));
        }
        String clientId = this.jms_conn.getClientIDForce();
        Map<String, Map<String, Map<String, Topic>>> map = s_subt;
        synchronized (map) {
            Map<String, Map<String, Topic>> cid2subs = s_subt.get(this.genConn.providerKey);
            if (cid2subs == null) {
                throw new InvalidDestinationException(AQjmsError.getMessage(235));
            }
            Map<String, Topic> name2topic = cid2subs.get(clientId);
            if (name2topic == null) {
                throw new InvalidDestinationException(AQjmsError.getMessage(235));
            }
            Topic topic = name2topic.get(subs_name);
            if (topic == null) {
                throw new InvalidDestinationException(AQjmsError.getMessage(235));
            }
            this.unsubscribe(topic, subs_name);
            name2topic.remove(subs_name);
            if (name2topic.isEmpty()) {
                cid2subs.remove(clientId);
            }
            if (cid2subs.isEmpty()) {
                s_subt.remove(this.genConn.providerKey);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unsubscribe(Topic topic, String subs_name) throws JMSException {
        AQjmsAgent agent = null;
        Connection db_conn = null;
        AQjmsOracleDebug.trace(3, "AQjmsSession.unsubscribe", "entry");
        this.checkSessionStarted();
        db_conn = this.getDBConnection();
        if (subs_name == null) {
            AQjmsError.throwEx(116);
        }
        if (topic == null) {
            AQjmsError.throwEx(166);
        }
        subs_name = AQjmsSession.chopit(subs_name, 30);
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.unsubscribe", "subs name:" + subs_name + ", topic name:" + ((AQjmsDestination)topic).getTopicName());
        if (this.getCompliant()) {
            Object mapLock;
            AQjmsOracleDebug.trace(3, "AQjmsSession.unsubscribe", "unsubscribe in compliant mode, consult in memeory map before remove AQ subscriber.");
            Object object = mapLock = AQjmsClientSubscriberMap.getMapLock();
            synchronized (object) {
                AQjmsClientSubscriberMap.unsubscribeClientSubscriber(this.jms_conn.getClientIDForce(), subs_name);
                try {
                    agent = new AQjmsAgent();
                    agent.setName(subs_name);
                    this.removeSubscriber(topic, agent);
                }
                catch (SQLException sql_ex) {
                    throw new AQjmsException(sql_ex);
                }
            }
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.unsubscribe", "unsubscribe in old mode, just remove the AQ subscriber.");
        try {
            agent = new AQjmsAgent();
            agent.setName(subs_name);
            this.removeSubscriber(topic, agent);
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.unsubscribe", "exit");
    }

    public synchronized void unsubscribe(Topic topic, AQjmsAgent remote_subscriber) throws JMSException {
        this.checkSessionStarted();
        this.removeRemoteSubscriber(topic, remote_subscriber);
    }

    private synchronized void removeSubscriber(Topic topic, AQjmsAgent subscriber) throws JMSException {
        String t_name = "";
        String subs_name = "";
        AQOracleAgent agt = null;
        Map<String, Class<?>> map = null;
        String subs_addr = null;
        int subs_prot = 0;
        Connection db_conn = null;
        AQjmsOracleDebug.trace(3, "AQjmsSession.removeSubscriber", "enter");
        db_conn = this.getDBConnection();
        if (topic == null) {
            AQjmsError.throwInvalidDestEx(166);
        }
        if (!(topic instanceof AQjmsDestination) || !((AQjmsDestination)topic).isTopic()) {
            AQjmsError.throwInvalidDestEx(126);
        }
        if (subscriber == null) {
            AQjmsError.throwEx(105);
        }
        try {
            t_name = ((AQjmsDestination)topic).getCompleteName();
            subs_name = subscriber.getName();
            subs_addr = subscriber.getAddress();
            subs_prot = subscriber.getProtocol();
            try {
                map = db_conn.getTypeMap();
            }
            catch (Exception ex) {
                AQjmsError.throwEx(112, (Throwable)ex);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception ex) {
                AQjmsError.throwEx(146);
            }
            agt = new AQOracleAgent(subs_name, subs_addr, subs_prot);
            if (this.rems_stmt != null) {
                this.rems_stmt.clearParameters();
            } else {
                String removeStmtStr = AQjmsInterOp.getRemoveSubStmtByVersion(this.dbversion);
                AQjmsOracleDebug.trace(5, "AQjmsSession.removeSubscriber", "remove_subscriber statement: " + removeStmtStr);
                this.rems_stmt = db_conn.prepareCall(removeStmtStr);
            }
            this.rems_stmt.setString(1, t_name);
            this.rems_stmt.setObject(2, (Object)agt, 2002);
            if (this.is92compatible()) {
                if (((AQjmsDestination)topic).isSecure()) {
                    this.rems_stmt.setInt(3, 1);
                } else {
                    this.rems_stmt.setInt(3, 0);
                }
            }
            this.rems_stmt.execute();
        }
        catch (SQLException sqlex) {
            try {
                this.rems_stmt.close();
                this.rems_stmt = null;
            }
            catch (Exception ex) {
                // empty catch block
            }
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.removeSubscriber", sqlex);
            throw new AQjmsException(sqlex);
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.removeSubscriber", "exit");
    }

    public void run() {
    }

    public Connection getDBConnection() throws JMSException {
        this.checkSessionStarted();
        return this.db_conn;
    }

    private Connection getOurDBConnection() {
        return this.db_conn;
    }

    public Map getTypeMap() throws JMSException {
        Map type_map = null;
        oracle.jdbc.OracleConnection db_conn = null;
        try {
            db_conn = (oracle.jdbc.OracleConnection)this.getDBConnection();
            type_map = db_conn.getTypeMap();
            if (type_map != null) {
                AQjmsOracleDebug.trace(5, "AQjmsSession.getTypeMap", "typemap found");
            } else {
                AQjmsOracleDebug.trace(5, "AQjmsSession.getTypeMap", "typemap NULL");
            }
        }
        catch (SQLException sql_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.getTypeMap", sql_ex);
            throw new AQjmsException(sql_ex);
        }
        return type_map;
    }

    private void checkSessionStarted() throws JMSException {
        if (this.isSessionClosed() && Thread.currentThread() != this.closingThread) {
            AQjmsError.throwIllegalStateEx(131, null);
        }
    }

    public AQjmsConnection getJmsConnection() throws JMSException {
        return this.jms_conn;
    }

    public AQQueueTable createQueueTable(String owner, String name, AQQueueTableProperty property) throws JMSException {
        return this.createQueueTable(owner, name, property, false);
    }

    public synchronized AQQueueTable createQueueTable(String owner, String name, AQQueueTableProperty property, boolean autonomous) throws JMSException {
        AQOracleSession sess = null;
        AQQueueTable q_table = null;
        Connection db_conn = null;
        db_conn = this.getDBConnection();
        try {
            sess = new AQOracleSession(db_conn);
            q_table = sess.createQueueTable(owner, name, property, autonomous);
        }
        catch (AQException aq_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.createQueueTable", aq_ex);
            throw new AQjmsException(aq_ex);
        }
        return q_table;
    }

    public synchronized AQQueueTable getQueueTable(String owner, String name) throws JMSException {
        AQOracleSession sess = null;
        AQQueueTable q_table = null;
        Connection db_conn = null;
        db_conn = this.getDBConnection();
        try {
            sess = new AQOracleSession(db_conn);
            q_table = sess.getQueueTable(owner, name);
        }
        catch (AQException aq_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.getQueueTable", aq_ex);
            throw new AQjmsException(aq_ex);
        }
        return q_table;
    }

    public synchronized Queue createQueue(AQQueueTable q_table, String queue_name, AQjmsDestinationProperty dest_property) throws JMSException {
        return this.createQueue(q_table, queue_name, dest_property, false);
    }

    public synchronized Queue createQueue(AQQueueTable q_table, String queue_name, AQjmsDestinationProperty dest_property, boolean autonomous) throws JMSException {
        AQOracleSession sess = null;
        AQOracleQueue aq_queue = null;
        AQjmsDestination jms_queue = null;
        Connection db_conn = null;
        AQjmsDestinationProperty curr_dest_property = null;
        db_conn = this.getDBConnection();
        if (dest_property == null) {
            AQjmsError.throwEx(121);
        }
        if (q_table == null) {
            AQjmsError.throwEx(187);
        }
        try {
            if (((AQOracleQueueTable)q_table).isMulticonsumerEnabled()) {
                AQjmsError.throwEx(144);
            }
            sess = new AQOracleSession(db_conn);
            aq_queue = (AQOracleQueue)sess.createQueue(q_table, queue_name, dest_property, autonomous);
            curr_dest_property = new AQjmsDestinationProperty(aq_queue.getProperty(true));
            jms_queue = new AQjmsDestination(aq_queue.getOwner(), aq_queue.getName(), 10, aq_queue.getPayloadType(), aq_queue.getObjectPayloadType(), curr_dest_property, aq_queue.getQueueTableName(), q_table.isSecure());
        }
        catch (AQException aq_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.createQueue", aq_ex);
            throw new AQjmsException(aq_ex);
        }
        finally {
            try {
                if (aq_queue != null) {
                    aq_queue.close();
                }
            }
            catch (Throwable th) {}
            try {
                if (sess != null) {
                    sess.close();
                }
            }
            catch (Throwable th) {}
        }
        return jms_queue;
    }

    public Topic createTopic(AQQueueTable q_table, String topic_name, AQjmsDestinationProperty dest_property) throws JMSException {
        return this.createTopic(q_table, topic_name, dest_property, false);
    }

    public synchronized Topic createTopic(AQQueueTable q_table, String topic_name, AQjmsDestinationProperty dest_property, boolean autonomous) throws JMSException {
        AQOracleSession sess = null;
        AQOracleQueue aq_queue = null;
        AQjmsDestination jms_topic = null;
        Connection db_conn = null;
        AQjmsDestinationProperty curr_dest_property = null;
        db_conn = this.getDBConnection();
        if (q_table == null) {
            AQjmsError.throwEx(187);
        }
        if (dest_property == null) {
            AQjmsError.throwEx(121);
        }
        try {
            if (dest_property.getQueueType() == 1) {
                AQjmsError.throwEx(151);
            }
            if (!((AQOracleQueueTable)q_table).isMulticonsumerEnabled()) {
                AQjmsError.throwEx(142);
            }
            sess = new AQOracleSession(db_conn);
            aq_queue = (AQOracleQueue)sess.createQueue(q_table, topic_name, dest_property, autonomous);
            AQjmsOracleDebug.trace(5, "AQjmsSession.createTopic", "Queue table: " + aq_queue.getQueueTableName());
            curr_dest_property = new AQjmsDestinationProperty(aq_queue.getProperty(true));
            jms_topic = new AQjmsDestination(aq_queue.getOwner(), aq_queue.getName(), 20, aq_queue.getPayloadType(), aq_queue.getObjectPayloadType(), curr_dest_property, aq_queue.getQueueTableName(), q_table.isSecure());
        }
        catch (AQException aq_ex) {
            AQjmsOracleDebug.traceEx(5, "AQjmsSession.createTopic", aq_ex);
            throw new AQjmsException(aq_ex);
        }
        finally {
            try {
                if (aq_queue != null) {
                    aq_queue.close();
                }
            }
            catch (Throwable th) {}
            try {
                if (sess != null) {
                    sess.close();
                }
            }
            catch (Throwable th) {}
        }
        return jms_topic;
    }

    public synchronized Queue getQueue(String owner, String name) throws JMSException {
        AQjmsOracleDebug.trace(3, "AQjmsSession.getQueue IN", " owner: " + owner + ", name: " + name);
        AQOracleSession sess = null;
        AQOracleQueue aq_queue = null;
        AQjmsDestination jms_queue = null;
        AQjmsDestinationProperty dest_property = null;
        Connection db_conn = null;
        AQOracleQueueTable q_table = null;
        db_conn = this.getDBConnection();
        try {
            sess = new AQOracleSession(db_conn);
            AQjmsOracleDebug.trace(5, "AQjmsSession.getQueue", "created AQOracleSession");
            aq_queue = (AQOracleQueue)sess.getQueue(owner, name);
            AQjmsOracleDebug.trace(5, "AQjmsSession.getQueue", "finish AQOracleSession.getQueue()");
            dest_property = new AQjmsDestinationProperty(aq_queue.getProperty(true));
            jms_queue = new AQjmsDestination(aq_queue.getOwner(), aq_queue.getName(), 10, aq_queue.getPayloadType(), aq_queue.getObjectPayloadType(), dest_property, aq_queue.getQueueTableName(), aq_queue.isSecure());
            q_table = (AQOracleQueueTable)this.getQueueTable(aq_queue.getOwner(), aq_queue.getQueueTableName());
            if (q_table.isMulticonsumerEnabled() && dest_property.getQueueType() != 1) {
                AQjmsError.throwEx(130);
            }
        }
        catch (AQException aq_ex) {
            AQjmsOracleDebug.traceEx(5, "AQjmsSession.getQueue", aq_ex);
            throw new AQjmsException(aq_ex);
        }
        finally {
            try {
                if (aq_queue != null) {
                    aq_queue.close();
                }
            }
            catch (Throwable th) {}
            try {
                if (sess != null) {
                    sess.close();
                }
            }
            catch (Throwable th) {}
            try {
                if (q_table != null) {
                    q_table.getAQSession().close();
                }
            }
            catch (Throwable th) {}
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.getQueue EXIT", "");
        return jms_queue;
    }

    public Destination getJmsDestination(AQOracleQueue aq_queue) throws JMSException {
        AQjmsDestination jms_dest = null;
        AQjmsDestinationProperty dest_property = null;
        Connection db_conn = null;
        String ptype = null;
        db_conn = this.getDBConnection();
        try {
            ptype = aq_queue.getObjectPayloadType();
            if (ptype.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE") || ptype.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
                AQjmsOracleDebug.trace(5, "AQjmsSession.getJmsDestination", "before newAQjmsDestProp");
                dest_property = new AQjmsDestinationProperty(aq_queue.getProperty(true));
                jms_dest = !aq_queue.isMultiConsumer() || dest_property.getQueueType() == 1 ? new AQjmsDestination(aq_queue.getOwner(), aq_queue.getName(), 10, aq_queue.getPayloadType(), aq_queue.getObjectPayloadType(), dest_property, aq_queue.getQueueTableName(), aq_queue.isSecure()) : new AQjmsDestination(aq_queue.getOwner(), aq_queue.getName(), 20, aq_queue.getPayloadType(), aq_queue.getObjectPayloadType(), dest_property, aq_queue.getQueueTableName(), aq_queue.isSecure());
            } else {
                jms_dest = null;
            }
        }
        catch (AQException aq_ex) {
            AQjmsOracleDebug.traceEx(5, "AQjmsSession.geJmsDestination", aq_ex);
            throw new AQjmsException(aq_ex);
        }
        return jms_dest;
    }

    public synchronized Topic getTopic(String owner, String name) throws JMSException {
        AQOracleSession sess = null;
        AQOracleQueue aq_queue = null;
        AQjmsDestination jms_topic = null;
        AQjmsDestinationProperty dest_property = null;
        Connection db_conn = null;
        AQOracleQueueTable q_table = null;
        db_conn = this.getDBConnection();
        try {
            sess = new AQOracleSession(db_conn);
            aq_queue = (AQOracleQueue)sess.getQueue(owner, name);
            dest_property = new AQjmsDestinationProperty(aq_queue.getProperty(true));
            jms_topic = new AQjmsDestination(aq_queue.getOwner(), aq_queue.getName(), 20, aq_queue.getPayloadType(), aq_queue.getObjectPayloadType(), dest_property, aq_queue.getQueueTableName(), aq_queue.isSecure());
            q_table = (AQOracleQueueTable)this.getQueueTable(aq_queue.getOwner(), aq_queue.getQueueTableName());
            if (!q_table.isMulticonsumerEnabled()) {
                AQjmsError.throwEx(142);
            }
        }
        catch (AQException aq_ex) {
            AQjmsOracleDebug.traceEx(5, "AQjmsSession.getTopic", aq_ex);
            throw new AQjmsException(aq_ex);
        }
        finally {
            try {
                if (aq_queue != null) {
                    aq_queue.close();
                }
            }
            catch (Throwable th) {}
            try {
                if (sess != null) {
                    sess.close();
                }
            }
            catch (Throwable th) {}
            try {
                if (q_table != null) {
                    q_table.getAQSession().close();
                }
            }
            catch (Throwable th) {}
        }
        return jms_topic;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isSessionClosed() throws JMSException {
        boolean closed = false;
        if (this.isClosed()) {
            return true;
        }
        Object object = this.m_consync;
        synchronized (object) {
            if (this.jms_conn == null) {
                closed = true;
            } else {
                block12: {
                    if (this.db_conn != null) {
                        try {
                            if (!this.db_conn.isClosed()) {
                                closed = false;
                                break block12;
                            }
                            closed = true;
                        }
                        catch (Exception ex) {
                            closed = true;
                        }
                    } else {
                        closed = false;
                    }
                }
                if (closed) {
                    this.jms_conn = null;
                }
            }
        }
        return closed;
    }

    int getCloseCheckInterval() {
        return this.cl_check_interval;
    }

    public synchronized void setCloseCheckInterval(int interval) throws JMSException {
        if (interval >= 1) {
            this.cl_check_interval = interval;
        } else {
            AQjmsError.throwEx(123, Integer.toString(1));
        }
    }

    public void grantSystemPrivilege(String privilege, String grantee, boolean admin_option) throws JMSException {
        AQOracleSession sess = null;
        Connection db_conn = null;
        db_conn = this.getDBConnection();
        try {
            sess = new AQOracleSession(db_conn);
            AQOracleAdmin.grantSystemPrivilege(sess, privilege, grantee, admin_option);
            sess.close();
        }
        catch (AQException aq_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.grantSystemPrivilege", aq_ex);
            throw new AQjmsException(aq_ex);
        }
    }

    public void revokeSystemPrivilege(String privilege, String grantee) throws JMSException {
        AQOracleSession sess = null;
        Connection db_conn = null;
        db_conn = this.getDBConnection();
        try {
            sess = new AQOracleSession(db_conn);
            AQOracleAdmin.revokeSystemPrivilege(sess, privilege, grantee);
            sess.close();
        }
        catch (AQException aq_ex) {
            AQjmsOracleDebug.traceEx(3, "AQjmsSession.revokeSystemPrivilege", aq_ex);
            throw new AQjmsException(aq_ex);
        }
    }

    public void createAQAgent(String agent_name) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsSession.createAQAgent-1", "entry");
        this.createAQAgent(agent_name, false, false, null);
        AQjmsOracleDebug.trace(4, "AQjmsSession.createAQAgent-1", "exit");
    }

    public void createAQAgent(String agent_name, boolean enable_http, boolean enable_smtp, String cert_loc) throws JMSException {
        Statement ag_stmt = null;
        Connection db_conn = null;
        String http_flag = "false";
        String smtp_flag = "false";
        AQjmsOracleDebug.trace(4, "AQjmsSession.createAQAgent-2", "entry");
        if (agent_name == null) {
            AQjmsError.throwEx(229, "agent_name");
        }
        if (enable_http) {
            http_flag = "true";
        }
        if (enable_smtp) {
            smtp_flag = "true";
        }
        try {
            db_conn = this.getDBConnection();
            ag_stmt = db_conn.prepareCall("begin dbms_aqadm.create_aq_agent(agent_name=> ?, certificate_location => ?, enable_http => " + http_flag + ", enable_smtp => " + smtp_flag + "); end;");
            ag_stmt.setString(1, agent_name);
            ag_stmt.setString(2, cert_loc);
            ag_stmt.execute();
            try {
                ag_stmt.close();
            }
            catch (Exception ex) {}
        }
        catch (SQLException sqlex) {
            try {
                ag_stmt.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new AQjmsException(sqlex);
        }
        AQjmsOracleDebug.trace(4, "AQjmsSession.createAQAgent-2", "exit");
    }

    public void alterAQAgent(String agent_name, boolean enable_http, boolean enable_smtp, String cert_loc) throws JMSException {
        Statement ag_stmt = null;
        Connection db_conn = null;
        String http_flag = "false";
        String smtp_flag = "false";
        AQjmsOracleDebug.trace(4, "AQjmsSession.alterAQAgent", "entry");
        if (agent_name == null) {
            AQjmsError.throwEx(229, "agent_name");
        }
        if (enable_http) {
            http_flag = "true";
        }
        if (enable_smtp) {
            smtp_flag = "true";
        }
        try {
            db_conn = this.getDBConnection();
            ag_stmt = db_conn.prepareCall("begin dbms_aqadm.alter_aq_agent(agent_name=> ?, certificate_location => ?, enable_http => " + http_flag + ", enable_smtp => " + smtp_flag + "); end;");
            ag_stmt.setString(1, agent_name);
            ag_stmt.setString(2, cert_loc);
            ag_stmt.execute();
            try {
                ag_stmt.close();
            }
            catch (Exception ex) {}
        }
        catch (SQLException sqlex) {
            try {
                ag_stmt.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new AQjmsException(sqlex);
        }
        AQjmsOracleDebug.trace(4, "AQjmsSession.alterAQAgent", "exit");
    }

    public void dropAQAgent(String agent_name) throws JMSException {
        Statement ag_stmt = null;
        Connection db_conn = null;
        AQjmsOracleDebug.trace(4, "AQjmsSession.dropAQAgent", "entry");
        if (agent_name == null) {
            AQjmsError.throwEx(229, "agent_name");
        }
        try {
            db_conn = this.getDBConnection();
            ag_stmt = db_conn.prepareCall("begin dbms_aqadm.drop_aq_agent(agent_name=> ? ); end;");
            ag_stmt.setString(1, agent_name);
            ag_stmt.execute();
            try {
                ag_stmt.close();
            }
            catch (Exception ex) {}
        }
        catch (SQLException sqlex) {
            try {
                ag_stmt.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new AQjmsException(sqlex);
        }
        AQjmsOracleDebug.trace(4, "AQjmsSession.dropAQAgent", "exit");
    }

    public void enableDBAccess(String agent_name, String db_username) throws JMSException {
        Statement ed_stmt = null;
        Connection db_conn = null;
        AQjmsOracleDebug.trace(4, "AQjmsSession.enableDBAccess", "entry");
        if (agent_name == null) {
            AQjmsError.throwEx(229, "agent_name");
        }
        if (db_username == null) {
            AQjmsError.throwEx(229, "db_username");
        }
        try {
            db_conn = this.getDBConnection();
            ed_stmt = db_conn.prepareCall("begin dbms_aqadm.enable_db_access(agent_name=> ?, db_username => ? ); end;");
            ed_stmt.setString(1, agent_name);
            ed_stmt.setString(2, db_username);
            ed_stmt.execute();
            try {
                ed_stmt.close();
            }
            catch (Exception ex) {}
        }
        catch (SQLException sqlex) {
            try {
                ed_stmt.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new AQjmsException(sqlex);
        }
        AQjmsOracleDebug.trace(4, "AQjmsSession.enableDBAccess", "exit");
    }

    public void disableDBAccess(String agent_name, String db_username) throws JMSException {
        Statement ed_stmt = null;
        Connection db_conn = null;
        AQjmsOracleDebug.trace(4, "AQjmsSession.disableDBAccess", "entry");
        if (agent_name == null) {
            AQjmsError.throwEx(229, "agent_name");
        }
        if (db_username == null) {
            AQjmsError.throwEx(229, "db_username");
        }
        try {
            db_conn = this.getDBConnection();
            ed_stmt = db_conn.prepareCall("begin dbms_aqadm.disable_db_access(agent_name=> ?, db_username => ? ); end;");
            ed_stmt.setString(1, agent_name);
            ed_stmt.setString(2, db_username);
            ed_stmt.execute();
            try {
                ed_stmt.close();
            }
            catch (Exception ex) {}
        }
        catch (SQLException sqlex) {
            try {
                ed_stmt.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            throw new AQjmsException(sqlex);
        }
        AQjmsOracleDebug.trace(4, "AQjmsSession.disableDBAccess", "exit");
    }

    public boolean isDeqStmtCachingEnabled() {
        return this.cache_deq_stmt;
    }

    public void setDeqStmtCachingFlag(boolean value) {
        this.cache_deq_stmt = value;
    }

    public void bindAgent(AQjmsAgent agent, String certificate) throws JMSException {
        Connection db_conn = null;
        String subs_name = "";
        AQOracleAgent agt = null;
        Map<String, Class<?>> map = null;
        String subs_addr = null;
        int subs_prot = 0;
        db_conn = this.getDBConnection();
        if (agent == null) {
            AQjmsError.throwEx(105);
        }
        try {
            subs_name = agent.getName();
            subs_addr = agent.getAddress();
            subs_prot = agent.getProtocol();
            try {
                map = db_conn.getTypeMap();
            }
            catch (Exception ex) {
                AQjmsError.throwEx(112, (Throwable)ex);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception ex) {
                AQjmsError.throwEx(146, (Throwable)ex);
            }
            agt = new AQOracleAgent(subs_name, subs_addr, subs_prot);
            if (this.bind_stmt != null) {
                this.bind_stmt.clearParameters();
            } else {
                this.bind_stmt = db_conn.prepareCall("begin dbms_aq.bind_agent(agent=>?, certificate_location=>?); end;");
            }
            this.bind_stmt.setObject(1, (Object)agt, 2002);
            this.bind_stmt.setString(2, certificate);
            this.bind_stmt.execute();
        }
        catch (SQLException sqlex) {
            try {
                this.bind_stmt.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.bind_stmt = null;
            throw new AQjmsException(sqlex);
        }
    }

    public void unbindAgent(AQjmsAgent agent) throws JMSException {
        Connection db_conn = null;
        String subs_name = "";
        AQOracleAgent agt = null;
        Map<String, Class<?>> map = null;
        String subs_addr = null;
        int subs_prot = 0;
        db_conn = this.getDBConnection();
        if (agent == null) {
            AQjmsError.throwEx(105);
        }
        try {
            subs_name = agent.getName();
            subs_addr = agent.getAddress();
            subs_prot = agent.getProtocol();
            try {
                map = db_conn.getTypeMap();
            }
            catch (Exception ex) {
                AQjmsError.throwEx(112, (Throwable)ex);
            }
            try {
                map.put("SYS.AQ$_AGENT", Class.forName("oracle.AQ.AQOracleAgent"));
            }
            catch (Exception ex) {
                AQjmsError.throwEx(146, (Throwable)ex);
            }
            agt = new AQOracleAgent(subs_name, subs_addr, subs_prot);
            if (this.ubnd_stmt != null) {
                this.ubnd_stmt.clearParameters();
            } else {
                this.ubnd_stmt = db_conn.prepareCall("begin dbms_aq.unbind_agent(agent=>?); end;");
            }
            this.ubnd_stmt.setObject(1, (Object)agt, 2002);
            this.ubnd_stmt.execute();
        }
        catch (SQLException sqlex) {
            try {
                this.ubnd_stmt.close();
            }
            catch (Exception ex) {
                // empty catch block
            }
            this.ubnd_stmt = null;
            throw new AQjmsException(sqlex);
        }
    }

    OracleCallableStatement getTextStmt() throws SQLException {
        if (this.st_text == null) {
            String textStmtStr = AQjmsInterOp.getEnquTextMsgStmtByVersion(this.dbversion);
            AQjmsOracleDebug.trace(5, "AQjmsSession.getTextStmt", "enqueue_text statement: " + textStmtStr);
            this.st_text = (OracleCallableStatement)this.db_conn.prepareCall(textStmtStr);
        } else {
            this.st_text.clearParameters();
        }
        return this.st_text;
    }

    OracleCallableStatement getMapStmt() throws SQLException {
        if (this.st_map == null) {
            String mapStmtStr = AQjmsInterOp.getEnquMapMsgStmtByVersion(this.dbversion);
            AQjmsOracleDebug.trace(5, "AQjmsSession.getMapStmt", "enqueue_map statement: " + mapStmtStr);
            this.st_map = (OracleCallableStatement)this.db_conn.prepareCall(mapStmtStr);
        } else {
            this.st_map.clearParameters();
        }
        return this.st_map;
    }

    OracleCallableStatement getStreamStmt() throws SQLException {
        if (this.st_stream == null) {
            String streamStmtStr = AQjmsInterOp.getEnquStreamMsgStmtByVersion(this.dbversion);
            AQjmsOracleDebug.trace(5, "AQjmsSession.getStreamStmt", "enqueue_stream statement: " + streamStmtStr);
            this.st_stream = (OracleCallableStatement)this.db_conn.prepareCall(streamStmtStr);
        } else {
            this.st_stream.clearParameters();
        }
        return this.st_stream;
    }

    OracleCallableStatement getBytesStmt() throws SQLException {
        if (this.st_bytes == null) {
            String bytesStmtStr = AQjmsInterOp.getEnquBytesMsgStmtByVersion(this.dbversion);
            AQjmsOracleDebug.trace(5, "AQjmsSession.getBytesStmt", "enqueue_bytes statement: " + bytesStmtStr);
            this.st_bytes = (OracleCallableStatement)this.db_conn.prepareCall(bytesStmtStr);
        } else {
            this.st_bytes.clearParameters();
        }
        return this.st_bytes;
    }

    OracleCallableStatement getObjectStmt() throws SQLException {
        if (this.st_object == null) {
            String objectStmtStr = AQjmsInterOp.getEnquObjectMsgStmtByVersion(this.dbversion);
            AQjmsOracleDebug.trace(5, "AQjmsSession.getObjectStmt", "enqueue_object statement: " + objectStmtStr);
            this.st_object = (OracleCallableStatement)this.db_conn.prepareCall(objectStmtStr);
        } else {
            this.st_object.clearParameters();
        }
        return this.st_object;
    }

    OracleCallableStatement getAdtStmt() throws SQLException {
        if (this.st_adt == null) {
            String adtStmtStr = AQjmsInterOp.getEnquAdtStmtByVersion(this.dbversion);
            AQjmsOracleDebug.trace(5, "AQjmsSession.getAdtStmt", "enqueue_adt statement: " + adtStmtStr);
            this.st_adt = (OracleCallableStatement)this.db_conn.prepareCall(adtStmtStr);
        } else {
            this.st_adt.clearParameters();
        }
        return this.st_adt;
    }

    OracleCallableStatement getAdtNoRecplStmt() throws SQLException {
        if (this.st_adt_rep == null) {
            String adtRepStmtStr = AQjmsInterOp.getEnquAdtNoRecplStmtByVersion(this.dbversion);
            AQjmsOracleDebug.trace(5, "AQjmsSession.getAdtNoRecplStmt", "enqueue_adt_norecpl statement: " + adtRepStmtStr);
            this.st_adt_rep = (OracleCallableStatement)this.db_conn.prepareCall(adtRepStmtStr);
        } else {
            this.st_adt_rep.clearParameters();
        }
        return this.st_adt_rep;
    }

    OracleCallableStatement getEnqueueStmt(Message message) throws SQLException {
        if (message instanceof AQjmsTextMessage) {
            return this.getTextStmt();
        }
        if (message instanceof AQjmsBytesMessage) {
            return this.getBytesStmt();
        }
        if (message instanceof AQjmsStreamMessage) {
            return this.getStreamStmt();
        }
        if (message instanceof AQjmsMapMessage) {
            return this.getMapStmt();
        }
        if (message instanceof AQjmsObjectMessage) {
            return this.getObjectStmt();
        }
        return null;
    }

    OracleCallableStatement getDequeueStmt() throws SQLException {
        if (this.deq_stmt == null) {
            String dequStmtStr = AQjmsInterOp.getDequeueStmtByVersion(this.dbversion);
            AQjmsOracleDebug.trace(5, "AQjmsSession.getDequeueStmt", "dequeue statement: " + dequStmtStr);
            this.deq_stmt = (OracleCallableStatement)this.db_conn.prepareCall(dequStmtStr);
        } else {
            this.deq_stmt.clearParameters();
        }
        return this.deq_stmt;
    }

    OracleCallableStatement getArrayEnqueueStmt(String qtabletype) throws SQLException {
        if (qtabletype.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE")) {
            if (this.st_array_enqueue == null) {
                this.st_array_enqueue = (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqjms_internal.aq$_jms_enqueue_messages( queue_name => ?, messages => ?, num_messages => ?, message_props => ?, visibility => ?, relative_msgid => ?, sequence_deviation => ?, transformation => ?, msgids => ?, errors => ?, num_enqueued => ? ); end; ");
            } else {
                this.st_array_enqueue.clearParameters();
            }
            return this.st_array_enqueue;
        }
        if (qtabletype.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE")) {
            if (this.st_array_text_enqueue == null) {
                this.st_array_text_enqueue = (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqjms_internal.aq$_jms_enqueue_text_messages( queue_name => ?, messages => ?, num_messages => ?, message_props => ?, visibility => ?, relative_msgid => ?, sequence_deviation => ?, transformation => ?, msgids => ?, errors => ?, num_enqueued => ? ); end; ");
            } else {
                this.st_array_text_enqueue.clearParameters();
            }
            return this.st_array_text_enqueue;
        }
        if (qtabletype.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE")) {
            if (this.st_array_bytes_enqueue == null) {
                this.st_array_bytes_enqueue = (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqjms_internal.aq$_jms_enqueue_bytes_messages( queue_name => ?, messages => ?, num_messages => ?, message_props => ?, visibility => ?, relative_msgid => ?, sequence_deviation => ?, transformation => ?, msgids => ?, errors => ?, num_enqueued => ? ); end; ");
            } else {
                this.st_array_bytes_enqueue.clearParameters();
            }
            return this.st_array_bytes_enqueue;
        }
        if (qtabletype.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
            if (this.st_array_stream_enqueue == null) {
                this.st_array_stream_enqueue = (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqjms_internal.aq$_jms_enqueue_stream_messages( queue_name => ?, messages => ?, num_messages => ?, message_props => ?, visibility => ?, relative_msgid => ?, sequence_deviation => ?, transformation => ?, msgids => ?, errors => ?, num_enqueued => ? ); end; ");
            } else {
                this.st_array_stream_enqueue.clearParameters();
            }
            return this.st_array_stream_enqueue;
        }
        if (qtabletype.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE")) {
            if (this.st_array_map_enqueue == null) {
                this.st_array_map_enqueue = (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqjms_internal.aq$_jms_enqueue_map_messages( queue_name => ?, messages => ?, num_messages => ?, message_props => ?, visibility => ?, relative_msgid => ?, sequence_deviation => ?, transformation => ?, msgids => ?, errors => ?, num_enqueued => ? ); end; ");
            } else {
                this.st_array_map_enqueue.clearParameters();
            }
            return this.st_array_map_enqueue;
        }
        if (qtabletype.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE")) {
            if (this.st_array_object_enqueue == null) {
                this.st_array_object_enqueue = (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqjms_internal.aq$_jms_enqueue_object_messages( queue_name => ?, messages => ?, num_messages => ?, message_props => ?, visibility => ?, relative_msgid => ?, sequence_deviation => ?, transformation => ?, msgids => ?, errors => ?, num_enqueued => ? ); end; ");
            } else {
                this.st_array_object_enqueue.clearParameters();
            }
            return this.st_array_object_enqueue;
        }
        return null;
    }

    OracleCallableStatement getArrayDequeueStmt(String qtabletype) throws SQLException {
        if (qtabletype.equalsIgnoreCase("SYS.AQ$_JMS_MESSAGE")) {
            if (this.st_array_dequeue == null) {
                this.st_array_dequeue = (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqjms_internal.aq$_jms_dequeue_messages( queue_name => ?, num_messages => ?, consumer_name => ?, dequeue_mode => ?, navigation => ?, visibility => ?, wait => ?, correlation => ?, deq_condition => ?, signature => ?, transformation => ?, message_props => ?, messages => ?, msgids => ?, num_dequeued => ? ); end; ");
            } else {
                this.st_array_dequeue.clearParameters();
            }
            return this.st_array_dequeue;
        }
        if (qtabletype.equalsIgnoreCase("SYS.AQ$_JMS_TEXT_MESSAGE")) {
            if (this.st_array_text_dequeue == null) {
                this.st_array_text_dequeue = (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqjms_internal.aq$_jms_dequeue_text_messages( queue_name => ?, num_messages => ?, consumer_name => ?, dequeue_mode => ?, navigation => ?, visibility => ?, wait => ?, correlation => ?, deq_condition => ?, signature => ?, transformation => ?, message_props => ?, messages => ?, msgids => ?, num_dequeued => ? ); end; ");
            } else {
                this.st_array_text_dequeue.clearParameters();
            }
            return this.st_array_text_dequeue;
        }
        if (qtabletype.equalsIgnoreCase("SYS.AQ$_JMS_BYTES_MESSAGE")) {
            if (this.st_array_bytes_dequeue == null) {
                this.st_array_bytes_dequeue = (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqjms_internal.aq$_jms_dequeue_bytes_messages( queue_name => ?, num_messages => ?, consumer_name => ?, dequeue_mode => ?, navigation => ?, visibility => ?, wait => ?, correlation => ?, deq_condition => ?, signature => ?, transformation => ?, message_props => ?, messages => ?, msgids => ?, num_dequeued => ? ); end; ");
            } else {
                this.st_array_bytes_dequeue.clearParameters();
            }
            return this.st_array_bytes_dequeue;
        }
        if (qtabletype.equalsIgnoreCase("SYS.AQ$_JMS_STREAM_MESSAGE")) {
            if (this.st_array_stream_dequeue == null) {
                this.st_array_stream_dequeue = (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqjms_internal.aq$_jms_dequeue_stream_messages( queue_name => ?, num_messages => ?, consumer_name => ?, dequeue_mode => ?, navigation => ?, visibility => ?, wait => ?, correlation => ?, deq_condition => ?, signature => ?, transformation => ?, message_props => ?, messages => ?, msgids => ?, num_dequeued => ? ); end; ");
            } else {
                this.st_array_stream_dequeue.clearParameters();
            }
            return this.st_array_stream_dequeue;
        }
        if (qtabletype.equalsIgnoreCase("SYS.AQ$_JMS_MAP_MESSAGE")) {
            if (this.st_array_map_dequeue == null) {
                this.st_array_map_dequeue = (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqjms_internal.aq$_jms_dequeue_map_messages( queue_name => ?, num_messages => ?, consumer_name => ?, dequeue_mode => ?, navigation => ?, visibility => ?, wait => ?, correlation => ?, deq_condition => ?, signature => ?, transformation => ?, message_props => ?, messages => ?, msgids => ?, num_dequeued => ? ); end; ");
            } else {
                this.st_array_map_dequeue.clearParameters();
            }
            return this.st_array_map_dequeue;
        }
        if (qtabletype.equalsIgnoreCase("SYS.AQ$_JMS_OBJECT_MESSAGE")) {
            if (this.st_array_object_dequeue == null) {
                this.st_array_object_dequeue = (OracleCallableStatement)this.db_conn.prepareCall("begin dbms_aqjms_internal.aq$_jms_dequeue_object_messages( queue_name => ?, num_messages => ?, consumer_name => ?, dequeue_mode => ?, navigation => ?, visibility => ?, wait => ?, correlation => ?, deq_condition => ?, signature => ?, transformation => ?, message_props => ?, messages => ?, msgids => ?, num_dequeued => ? ); end; ");
            } else {
                this.st_array_object_dequeue.clearParameters();
            }
            return this.st_array_object_dequeue;
        }
        return null;
    }

    void destroyStmt(OracleCallableStatement stmt) {
        if (stmt == null) {
            return;
        }
        boolean del = false;
        if (stmt == this.st_text) {
            this.st_text = null;
            del = true;
        } else if (stmt == this.st_map) {
            this.st_map = null;
            del = true;
        } else if (stmt == this.st_bytes) {
            this.st_bytes = null;
            del = true;
        } else if (stmt == this.st_stream) {
            this.st_stream = null;
            del = true;
        } else if (stmt == this.st_object) {
            this.st_object = null;
            del = true;
        } else if (stmt == this.st_adt) {
            this.st_adt = null;
            del = true;
        } else if (stmt == this.st_adt_rep) {
            this.st_adt_rep = null;
            del = true;
        } else if (stmt == this.deq_stmt) {
            this.deq_stmt = null;
            del = true;
        } else if (stmt == this.st_array_enqueue) {
            this.st_array_enqueue = null;
            del = true;
        } else if (stmt == this.st_array_text_enqueue) {
            this.st_array_text_enqueue = null;
            del = true;
        } else if (stmt == this.st_array_bytes_enqueue) {
            this.st_array_bytes_enqueue = null;
            del = true;
        } else if (stmt == this.st_array_stream_enqueue) {
            this.st_array_stream_enqueue = null;
            del = true;
        } else if (stmt == this.st_array_map_enqueue) {
            this.st_array_map_enqueue = null;
            del = true;
        } else if (stmt == this.st_array_object_enqueue) {
            this.st_array_object_enqueue = null;
            del = true;
        } else if (stmt == this.st_array_dequeue) {
            this.st_array_dequeue = null;
            del = true;
        } else if (stmt == this.st_array_text_dequeue) {
            this.st_array_text_dequeue = null;
            del = true;
        } else if (stmt == this.st_array_bytes_dequeue) {
            this.st_array_bytes_dequeue = null;
            del = true;
        } else if (stmt == this.st_array_stream_dequeue) {
            this.st_array_stream_dequeue = null;
            del = true;
        } else if (stmt == this.st_array_map_dequeue) {
            this.st_array_map_dequeue = null;
            del = true;
        } else if (stmt == this.st_array_object_dequeue) {
            this.st_array_object_dequeue = null;
            del = true;
        }
        if (del) {
            try {
                stmt.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    protected long[] getOCIHandles() throws JMSException {
        String drv = this.getDriver();
        if ((drv.equalsIgnoreCase("oci8") || drv.equalsIgnoreCase("oci")) && AQDriverManager.isOciAQEnabled() && AQjmsConstants.OCI_NATIVE_PATH) {
            Properties prop = new Properties();
            Connection db_conn = this.getOurDBConnection();
            try {
                if (!loaded_library) {
                    String osName = AQjmsUtil.getSystemProperty("os.name");
                    String libName = null;
                    if (osName.toUpperCase().startsWith("WINDOWS")) {
                        libName = "oci";
                    } else if (osName.equalsIgnoreCase("OpenVMS")) {
                        libName = "libclntsh";
                    } else if (osName.toUpperCase().startsWith("MAC OS")) {
                        libName = "clntsh";
                    }
                    if (libName != null) {
                        final String finalLibName = libName;
                        AccessController.doPrivileged(new PrivilegedAction(){

                            public Object run() {
                                System.loadLibrary(finalLibName);
                                return null;
                            }
                        });
                        loaded_library = true;
                    }
                }
            }
            catch (Exception ex) {
                AQjmsOracleDebug.traceEx(3, "AQjmsSession.loadLibrary excp:", ex);
            }
            catch (Error err) {
                AQjmsOracleDebug.traceErr(3, "AQjmsSession.loadLibrary error:", err);
            }
            try {
                prop = ((OracleConnection)db_conn).getOCIHandles();
            }
            catch (Exception e) {
                AQjmsError.throwEx(122, "Properties Not Found", e);
            }
            AQjmsOracleDebug.trace(5, "AQjmsSession.getOCIHandles():", "Got DBAccess properties ");
            long h0 = Long.parseLong(prop.getProperty("OCIEnvHandle"));
            long h1 = Long.parseLong(prop.getProperty("OCIErrHandle"));
            long h2 = Long.parseLong(prop.getProperty("OCISvcCtxHandle"));
            if (h0 == this.oci_handles[0] && h1 == this.oci_handles[1] && h2 == this.oci_handles[2]) {
                return this.oci_handles;
            }
            this.freeOCIHandles();
            this.oci_handles[0] = h0;
            this.oci_handles[1] = h1;
            this.oci_handles[2] = h2;
            AQjmsOracleDebug.trace(3, "AQjmsSession.getOCIHandles():", "(Re)got oci handles ");
            String tname = Thread.currentThread().getName();
            int tid = 0;
            try {
                AQjmsOracleDebug.println("Tname.substring:" + tname.substring(7) + "::");
                tid = Integer.parseInt(tname.substring(7));
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                this.oci_aq_cntxt = this.ociinit(this.oci_handles, AQjmsOracleDebug.getTraceLevel(), tid, this.toUseTempLobs(), this.dbversion, this.db_max_bytes, this.getClientRatio());
            }
            catch (Exception e) {
                AQjmsError.throwEx(122, "OCI Init failed!", e);
            }
            AQjmsOracleDebug.trace(3, "AQjmsSession.getOCIHandles():", "(Re)initialized AQ context");
            return this.oci_handles;
        }
        return null;
    }

    private void setMultiRetry() throws JMSException {
        if ((this.sess_type == 20 || this.sess_type == 30) && this.hasGenMsgSupport()) {
            CallableStatement stmt = null;
            try {
                String text = "{call dbms_aqin.set_multi_retry(TRUE)}";
                stmt = this.db_conn.prepareCall(text);
                stmt.execute(text);
                AQjmsOracleDebug.trace(3, "AQjmsSession.setMultiRetry", "setting the multi_retry flag to true");
            }
            catch (SQLException sql_ex) {
                AQjmsOracleDebug.traceEx(3, "AQjmsSession.setMultiRetry", sql_ex);
                throw new AQjmsException(sql_ex);
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Throwable t) {}
            }
        }
    }

    private void enableEventForMsgOrder() throws JMSException {
        if (this.is11compatible()) {
            CallableStatement stmt = null;
            try {
                String text = "{call dbms_aqin.set_deq_sort(TRUE)}";
                stmt = this.db_conn.prepareCall(text);
                stmt.execute(text);
                AQjmsOracleDebug.trace(3, "AQjmsSession.enableEventForMsgOrder", "setting the multi_retry flag to true");
            }
            catch (SQLException sql_ex) {
                AQjmsOracleDebug.traceEx(3, "AQjmsSession.enableEventForMsgOrder", sql_ex);
                throw new AQjmsException(sql_ex);
            }
            finally {
                try {
                    if (stmt != null) {
                        stmt.close();
                    }
                }
                catch (Throwable t) {}
            }
        }
    }

    private long getOCIServiceHandle() {
        return this.oci_handles[2];
    }

    private long getOCIErrorHandle() {
        return this.oci_handles[1];
    }

    void freeOCIHandles() throws JMSException {
        if (this.oci_aq_cntxt != 0L) {
            Properties prop = null;
            try {
                Connection db_conn = this.getOurDBConnection();
                if (db_conn.isClosed()) {
                    return;
                }
                prop = ((OracleConnection)db_conn).getDBAccessProperties();
            }
            catch (Exception e) {
                AQjmsError.throwEx(122, "Properties Not Found", e);
            }
            if (prop != null) {
                try {
                    this.ocifrctx(this.oci_handles, this.oci_aq_cntxt, AQjmsOracleDebug.getTraceLevel());
                }
                catch (Exception ex) {
                    AQjmsOracleDebug.traceEx(3, "freeOCIHandles excp:", ex);
                    AQjmsError.throwEx(122, "Freeing OCI handles", ex);
                }
                AQjmsOracleDebug.trace(3, "AQjmsSession.freeOCIHandles():", "Freed AQ context");
            }
        }
        this.oci_aq_cntxt = 0L;
    }

    boolean is82compatible() {
        return AQjmsInterOp.is82compatible(this.dbversion);
    }

    boolean is92compatible() {
        return AQjmsInterOp.is92compatible(this.dbversion);
    }

    boolean is10compatible() {
        return AQjmsInterOp.is10compatible(this.dbversion);
    }

    boolean is102compatible() {
        return AQjmsInterOp.is102compatible(this.dbversion);
    }

    boolean is11compatible() {
        return AQjmsInterOp.is11compatible(this.dbversion);
    }

    boolean is112compatible() {
        return AQjmsInterOp.is112compatible(this.dbversion);
    }

    boolean toUseTempLobs() {
        return this.is10compatible() && this.jms_conn.isUseTempLobs();
    }

    short getDBVersion() {
        return this.dbversion;
    }

    boolean hasGenMsgSupport() {
        return AQjmsInterOp.hasGenMsgSupport(this.dbversion);
    }

    public boolean hasOciAQContext() {
        return this.oci_aq_cntxt != 0L;
    }

    String getDriver() {
        return this.jms_conn.getDriver();
    }

    public synchronized void removeConsumer(AQjmsConsumer que_con) {
        if (que_con.dest_type == 20 && !que_con.isDurable()) {
            try {
                AQjmsOracleDebug.trace(3, "AQjmsSession.removeConsumer", "Before removing nondurable subscriber " + que_con.cons_name);
                if (this.clientSessionGUID != null && this.isClosing()) {
                    AQjmsOracleDebug.trace(3, "AQjmsSession.removeConsumer", "Delay removing nondurable subscriber " + que_con.cons_name + " on server ");
                } else {
                    AQjmsAgent agent = new AQjmsAgent();
                    agent.setName(que_con.cons_name);
                    this.removeSubscriber(que_con.cons_dest, agent);
                }
                AQjmsOracleDebug.trace(3, "AQjmsSession.removeConsumer", "End removing nondurable subscriber " + que_con.cons_name);
            }
            catch (Exception ex) {
                AQjmsOracleDebug.traceEx(3, "AQjmsSession.removeConsumer", ex);
            }
        }
        this.cons_list.remove(que_con);
    }

    public void finalize() {
        AQjmsOracleDebug.println("AQjmsSession.finalize");
    }

    private String getAQOwner(String name) throws JMSException {
        if (name.indexOf(46) == -1) {
            try {
                return this.getDBConnection().getMetaData().getUserName();
            }
            catch (SQLException sql_ex) {
                throw new AQjmsException(sql_ex);
            }
        }
        return name.substring(0, name.indexOf(46));
    }

    private String getAQName(String name) {
        if (name.indexOf(46) == -1) {
            return name;
        }
        return name.substring(1 + name.indexOf(46));
    }

    private String getTempName() throws JMSException {
        String id = this.jms_conn.getConnectionID();
        int n = this.jms_conn.getTempCount();
        return "TMPQ_" + n + "_" + id;
    }

    private String getSubsName() throws JMSException {
        String id = this.jms_conn.getConnectionID();
        int n = this.jms_conn.getTempCount();
        String subs_name = AQjmsSession.chopit("TSUB_" + n + "_" + id, 30);
        return subs_name;
    }

    private static String chopit(String n, int max_len) {
        if (n != null && n.length() > max_len) {
            AQjmsOracleDebug.trace(5, "AQjmsSession.chopit", n + " -> " + n.substring(0, max_len));
            n = n.substring(0, max_len);
        }
        return n;
    }

    private AQjmsDestination makeTemporaryQueue(boolean isMulti) throws JMSException {
        String owner = this.getAQOwner("");
        String qName = AQjmsSession.chopit(this.getTempName(), 24);
        String qtName = AQjmsSession.chopit(qName, 24);
        AQQueueTableProperty qtProp = null;
        try {
            qtProp = new AQQueueTableProperty("SYS.AQ$_JMS_MESSAGE");
            qtProp.setSortOrder("priority,enq_time");
            qtProp.setMultiConsumer(isMulti);
        }
        catch (AQException e) {
            throw new AQjmsException(e);
        }
        AQQueueTable qt = this.createQueueTable(owner, qtName, qtProp, true);
        AQjmsDestination q = null;
        q = isMulti ? (AQjmsDestination)this.createTopic(qt, qName, new AQjmsDestinationProperty(), true) : (AQjmsDestination)this.createQueue(qt, qName, new AQjmsDestinationProperty(), true);
        q.start((Session)this, true, true, true);
        this.jms_conn.registerTemp(q);
        return q;
    }

    public synchronized void restartConsumers() {
        AQjmsOracleDebug.trace(5, "AQjmsSession.restartConsumers", "entry");
        Enumeration e = this.cons_list.elements();
        while (e.hasMoreElements()) {
            AQjmsConsumer cons = (AQjmsConsumer)e.nextElement();
            cons.restart();
        }
    }

    void checkForGlobalTxn() throws JMSException {
        AQjmsOracleDebug.trace(3, "AQjmsSession.checkForGlobalTxn", "entry");
        if (this.xaHandler == null) {
            AQjmsOracleDebug.trace(3, "AQjmsSession.checkForGlobalTxn", "oracle.jms.useEmulatedXA is off");
        } else {
            AQjmsOracleDebug.trace(3, "AQjmsSession.checkForGlobalTxn", "oracle.jms.useEmulatedXA is on");
            this.xaHandler.checkForGlobalTxn();
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.checkForGlobalTxn", "exit");
    }

    boolean isInGlobalTransactionRechecked() throws JMSException {
        boolean inGT = false;
        AQjmsOracleDebug.trace(3, "AQjmsSession.inGlobalTransRechecked", "entry");
        if (this.xaHandler == null) {
            AQjmsOracleDebug.trace(3, "AQjmsSession.inGlobalTransRechecked", "oracle.jms.useEmulatedXA is off");
        } else {
            AQjmsOracleDebug.trace(3, "AQjmsSession.inGlobalTransRechecked", "oracle.jms.useEmulatedXA is on");
            inGT = this.xaHandler.inGlobalTrans(true);
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.inGlobalTransRechecked", "exit");
        return inGT;
    }

    boolean isInGlobalTransaction() {
        boolean inGT = false;
        AQjmsOracleDebug.trace(3, "AQjmsSession.isInGlobalTransaction", "entry");
        if (this.xaHandler == null) {
            AQjmsOracleDebug.trace(3, "AQjmsSession.isInGlobalTransaction", "oracle.jms.useEmulatedXA is off");
        } else {
            AQjmsOracleDebug.trace(3, "AQjmsSession.isInGlobalTransaction", "oracle.jms.useEmulatedXA is on");
            inGT = this.xaHandler.globalTxnFlag;
        }
        AQjmsOracleDebug.trace(3, "AQjmsSession.isInGlobalTransaction", "exit");
        return inGT;
    }

    boolean isInTransactionRechecked() throws JMSException {
        return this.transacted || this.isInGlobalTransactionRechecked();
    }

    public int getAcknowledgeMode() throws JMSException {
        this.checkSessionStarted();
        if (this.isInTransactionRechecked()) {
            return 0;
        }
        return this.ack_mode;
    }

    public synchronized MessageProducer createProducer(Destination destination) throws JMSException {
        AQjmsProducer producer = null;
        this.checkSessionStarted();
        if (destination != null && !(destination instanceof AQjmsDestination)) {
            AQjmsError.throwInvalidDestEx(127);
        }
        producer = new AQjmsProducer(this, (AQjmsDestination)destination, 30);
        return producer;
    }

    public MessageConsumer createConsumer(Destination destination) throws JMSException {
        return this.createConsumer(destination, null, null, null, false);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector) throws JMSException {
        return this.createConsumer(destination, messageSelector, null, null, false);
    }

    public MessageConsumer createConsumer(Destination destination, String messageSelector, boolean NoLocal) throws JMSException {
        return this.createConsumer(destination, messageSelector, null, null, NoLocal);
    }

    public synchronized MessageConsumer createConsumer(Destination destination, String messageSelector, Object payload_factory, String transformation, boolean noLocal) throws JMSException {
        AQjmsConsumer consumer = null;
        AQjmsSelector jms_sel = null;
        String p_data_type = null;
        this.checkSessionStarted();
        if (destination == null) {
            throw new InvalidDestinationException(AQjmsError.getMessage(200));
        }
        if (!(destination instanceof AQjmsDestination)) {
            AQjmsError.throwInvalidDestEx(127);
        }
        if (this.getMessageListener() != null) {
            AQjmsError.throwEx(107, "createConsumer after MessageListener of Session is set");
        }
        int dest_type = ((AQjmsDestination)destination).isQueue() ? 10 : 20;
        if (messageSelector != null && !messageSelector.equals("")) {
            jms_sel = payload_factory != null ? new AQjmsSelector(messageSelector, dest_type, 2, this.is82compatible(), this.getCompliant()) : ((p_data_type = ((AQjmsDestination)destination).getAdtType()).equalsIgnoreCase("SYS.ANYDATA") ? new AQjmsSelector(messageSelector, dest_type, 3, this.is82compatible(), this.getCompliant()) : new AQjmsSelector(messageSelector, dest_type, 1, this.is82compatible(), this.getCompliant()));
        }
        AQjmsOracleDebug.trace(5, "AQjmsSession.createConsumer", "Selector: " + jms_sel);
        if (dest_type == 10) {
            consumer = new AQjmsConsumer(this, destination, dest_type, 3, null, payload_factory, jms_sel, transformation);
        } else if (AQjmsConstants.useAQNondurableSubscriber() && this.is112compatible()) {
            consumer = this.addAQNondurableSubscriber((Topic)destination, messageSelector, noLocal, payload_factory, transformation);
        } else {
            String subs_name = this.getSubsName();
            consumer = this.createDurableSubscriber((Topic)destination, subs_name, messageSelector, noLocal, payload_factory, transformation, true, true);
        }
        this.cons_list.put(consumer, consumer);
        return consumer;
    }
}

