package com.hzjt.service;

import com.hzjt.mapper.CommonMapper;
import com.hzjt.util.SeqEnum;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SeqService {

    private CommonMapper commonMapper;

    @Autowired
    public SeqService(CommonMapper commonMapper) {
        this.commonMapper = commonMapper;
    }

    public long get(String seqname) {
        return commonMapper.getSeq(seqname);
    }

    public long getTraffSeq() {
        return commonMapper.getSeq(SeqEnum.SEQ_TRAFF.getValue());
    }
}
