package com.hzjt.service;

import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.concurrent.TimeUnit;

@Service
@Slf4j
public class FLVCacheService {

    @Autowired
    private StringRedisTemplate stringRedisTemplate;

    @Value("${flv.resisvalue}")
    private String resisvalue;


    @Value("${flv.url}")
    private String url;

    public void getvalue() {
        try {
            HttpHeaders headers = getHttpHeaders();
            HttpEntity<String> requestEntity = new HttpEntity<>(null, headers);
            RestTemplate client = new RestTemplate();
            ResponseEntity<String> request = client.exchange((url), HttpMethod.GET, requestEntity, String.class);
            //解析返回结果

            if (request.getBody() != null) {
                log.info("flv response success" );
                stringRedisTemplate.opsForValue().set(resisvalue,request.getBody(), 32, TimeUnit.MINUTES);

            } else {
                log.error("flv response " + "empty...");
            }
        } catch (Exception e) {
            System.out.println(e.toString());
            log.error(e.getMessage());
        }
    }



    private HttpHeaders getHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON_UTF8);
        return headers;
    }

}
