/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.jndi;

import java.util.Properties;
import java.util.Vector;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import oracle.net.ns.NetException;

public class JndiAttrs {
    private Properties env;
    private static final String nFactory = "java.naming.factory.initial";
    private static final String nProvider = "java.naming.provider.url";
    private static final String nProfile = "ora-net-profile";
    private static final String default_nFactory = "com.sun.jndi.ldap.LdapCtxFactory";
    DirContext ctx;

    public JndiAttrs(Properties properties) throws NetException {
        Object object;
        String string = null;
        this.env = new Properties();
        if (properties.containsKey(nFactory)) {
            this.env.put(nFactory, properties.getProperty(nFactory));
        } else {
            this.env.put(nFactory, default_nFactory);
        }
        if (properties.containsKey(nProvider)) {
            string = properties.getProperty(nProvider);
            if (string.startsWith("ldaps")) {
                this.env.put("java.naming.ldap.factory.socket", "oracle.net.jndi.CustomSSLSocketFactory");
                this.env.put("java.naming.security.protocol", "ssl");
                string = "ldap:" + string.substring(6);
            }
            this.env.put(nProvider, string);
        }
        if (properties.containsKey("oracle.net.profile")) {
            this.env.put(nProfile, properties.getProperty("oracle.net.profile"));
        }
        try {
            object = Class.forName("javax.naming.directory.InitialDirContext");
            if (this.env.get(nFactory) == null) {
                this.env.put(nFactory, default_nFactory);
            }
            if (this.env.get(nProvider) == null) {
                this.env.put(nProvider, string);
            }
        }
        catch (Exception exception) {
            throw new NetException(110, exception.toString());
        }
        object = properties.get("java.naming.security.authentication");
        if (object != null) {
            this.env.put("java.naming.security.authentication", object);
        }
        if ((object = properties.get("java.naming.security.principal")) != null) {
            this.env.put("java.naming.security.principal", object);
        }
        if ((object = properties.get("java.naming.security.credentials")) != null) {
            this.env.put("java.naming.security.credentials", object);
        }
        for (int i2 = 0; i2 < 3; ++i2) {
            try {
                this.ctx = new InitialDirContext(this.env);
                break;
            }
            catch (NamingException namingException) {
                Class<?> clazz = null;
                try {
                    clazz = Class.forName("javax.net.ssl.SSLException");
                }
                catch (Exception exception) {
                    throw new NetException(108, namingException.toString());
                }
                if (clazz.isInstance(namingException.getRootCause()) && i2 < 3) continue;
                throw new NetException(108, namingException.toString());
            }
        }
    }

    public Vector getProfileAttrs(String string) throws NetException {
        String string2 = "cn=";
        Attributes attributes = null;
        try {
            string2 = string2.concat(string);
            attributes = this.ctx.getAttributes(string2);
        }
        catch (NamingException namingException) {
            throw new NetException(108, namingException.toString());
        }
        return this.setAttrs(attributes);
    }

    public Vector getAttrs(String string, String[] stringArray) throws NetException {
        String string2 = "cn=";
        Attributes attributes = null;
        try {
            string2 = string2.concat(string);
            attributes = this.ctx.getAttributes(string2, stringArray);
        }
        catch (NamingException namingException) {
            throw new NetException(108, namingException.toString());
        }
        return this.setAttrs(attributes);
    }

    private Vector setAttrs(Attributes attributes) throws NetException {
        Vector vector = new Vector(1, 1);
        if (attributes == null) {
            System.out.println("No attributes");
        } else {
            try {
                NamingEnumeration<? extends Attribute> namingEnumeration = attributes.getAll();
                while (namingEnumeration != null && namingEnumeration.hasMoreElements()) {
                    Attribute attribute = namingEnumeration.next();
                    NamingEnumeration<?> namingEnumeration2 = attribute.getAll();
                    while (namingEnumeration2.hasMoreElements()) {
                        vector.addElement(namingEnumeration2.nextElement());
                    }
                }
            }
            catch (NamingException namingException) {
                throw new NetException(108, namingException.toString());
            }
        }
        return vector;
    }

    public void setEnv(String string, String string2) {
        this.env.put(string, string2);
    }

    public void close() throws NetException {
        try {
            if (null != this.ctx) {
                this.ctx.close();
            }
        }
        catch (NamingException namingException) {
            throw new NetException(108, namingException.toString());
        }
    }

    public final String getLdapUrlUsed() throws NetException {
        String string = null;
        try {
            string = (String)this.ctx.getEnvironment().get(nProvider);
        }
        catch (NamingException namingException) {
            throw new NetException(108, namingException.toString());
        }
        return string;
    }
}

