package com.hzjt.config;

import com.hzjt.handler.WebSocket;
import com.hzjt.service.TraffFlowService;
import com.hzjt.service.TraffalarmrecordService;
import com.hzjt.util.DateUtils;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.annotation.EnableScheduling;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;

import java.net.URI;
import java.util.Calendar;

@Slf4j
@Component
@Configuration
@EnableScheduling
public class ScheduleTaskConfig {
    @Autowired
    TraffFlowService traffFlowService;

    @Autowired
    TraffalarmrecordService traffalarmrecordService;


    @Scheduled(cron = "0 0 2 * * ? ")//每天凌晨2点执行
    private void statis() {
        log.info("每天凌晨2点执行前一天数据整合");
        String date = DateUtils.getYesterday(-1);
        //抽取前一天的车流量和事件统计数据入表
        Integer result = traffFlowService.statisVehiclesByDay(date);
        //抽取前一天的事件统计到新表中
        Integer resultrecord = traffalarmrecordService.statisTraffalarmrecordstatByDay(date);

        //删除当天的数据
        traffFlowService.deleteVehiclesByDay();

    }

    @Scheduled(cron = "0 0 23 28-31 * ?")//每一个月执行一次
    private void reconnectWebsocket() {

        final Calendar c = Calendar.getInstance();
        if (c.get(Calendar.DATE) == c.getActualMaximum(Calendar.DATE)) {
            log.info("每个月最后一天执行删除前2个月车流量数据操作start");
            //删除2个月之前车流量详情的数据
            traffFlowService.deleteBeforeTwoMonthVehicles(DateUtils.getlastMonth(-2));
        }
    }

    @Scheduled(cron = "0 30/5 6-19 * * ?")//每隔5分钟统计当天目前为止的数据
    private void statistoday() {
        //判断是否为空表
        //执行查询存在更新，不存在新增
        log.info("每隔5分钟");
       Integer result= traffFlowService.insertOrUpdatevehicleTodaystatistic();
        log.info("today"+result);

    }

}
