/*
 * Decompiled with CFR 0.152.
 */
package oracle.jms;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.sql.SQLException;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import oracle.jms.AQjmsBytesMessage_C;
import oracle.jms.AQjmsError;
import oracle.jms.AQjmsException;
import oracle.jms.AQjmsGenMessage_C;
import oracle.jms.AQjmsMessage;
import oracle.jms.AQjmsOracleDebug;
import oracle.jms.AQjmsSession;
import oracle.jms.AQjmsUtil;
import oracle.sql.ORAData;

public class AQjmsBytesMessage
extends AQjmsMessage
implements BytesMessage {
    private byte[] m_bytesData = new byte[0];
    private DataInputStream m_inDataStream;
    private ByteArrayOutputStream m_outByteArrayStream;
    private DataOutputStream m_outDataStream;
    private boolean m_dirty = false;

    public AQjmsBytesMessage() {
        super(true);
        this.m_outByteArrayStream = new ByteArrayOutputStream();
        this.m_outDataStream = new DataOutputStream(this.m_outByteArrayStream);
        this.access_mode = 1;
    }

    AQjmsBytesMessage(AQjmsSession session) {
        super(session, true);
        this.m_outByteArrayStream = new ByteArrayOutputStream();
        this.m_outDataStream = new DataOutputStream(this.m_outByteArrayStream);
        this.access_mode = 1;
    }

    AQjmsBytesMessage(AQjmsMessage headerMsg) {
        super(headerMsg);
    }

    AQjmsBytesMessage(AQjmsSession session, AQjmsBytesMessage_C msgCont) throws JMSException {
        super(session, true);
        try {
            this.header_ext = msgCont.getHeader();
            this.readBytesMessageContainer(msgCont);
            this.m_inDataStream = new DataInputStream(new ByteArrayInputStream(this.m_bytesData));
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        this.access_mode = 0;
    }

    AQjmsBytesMessage(AQjmsSession session, AQjmsGenMessage_C msgCont) throws JMSException {
        super(session, true);
        try {
            this.header_ext = msgCont.getHeader();
            this.readGenMessageContainer(msgCont);
            this.m_inDataStream = new DataInputStream(new ByteArrayInputStream(this.m_bytesData));
        }
        catch (SQLException sql_ex) {
            throw new AQjmsException(sql_ex);
        }
        this.access_mode = 0;
    }

    AQjmsBytesMessage(AQjmsSession session, byte[] bdata) {
        super(session, true);
        if (bdata != null) {
            this.m_bytesData = bdata;
        }
        this.m_inDataStream = new DataInputStream(new ByteArrayInputStream(this.m_bytesData));
        this.access_mode = 0;
    }

    public byte[] getBytesData() {
        this.updateBytesDataFromStream();
        return this.m_bytesData;
    }

    public boolean readBoolean() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
        }
        try {
            return this.m_inDataStream.readBoolean();
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        return false;
    }

    public byte readByte() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
        }
        try {
            return this.m_inDataStream.readByte();
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        return 0;
    }

    public int readUnsignedByte() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
        }
        try {
            return this.m_inDataStream.readUnsignedByte();
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        return 0;
    }

    public short readShort() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
        }
        try {
            return this.m_inDataStream.readShort();
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        return 0;
    }

    public int readUnsignedShort() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
        }
        try {
            return this.m_inDataStream.readUnsignedShort();
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        return 0;
    }

    public char readChar() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
        }
        try {
            return this.m_inDataStream.readChar();
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        return '\u0000';
    }

    public int readInt() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
        }
        try {
            return this.m_inDataStream.readInt();
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        return 0;
    }

    public long readLong() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
        }
        try {
            return this.m_inDataStream.readLong();
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        return 0L;
    }

    public float readFloat() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
        }
        try {
            return this.m_inDataStream.readFloat();
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        return 0.0f;
    }

    public double readDouble() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
        }
        try {
            return this.m_inDataStream.readDouble();
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        return 0.0;
    }

    public String readUTF() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
        }
        try {
            return this.m_inDataStream.readUTF();
        }
        catch (EOFException msgeof_ex) {
            AQjmsError.throwEOFileEx(160, msgeof_ex.getMessage());
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        return null;
    }

    public int readBytes(byte[] value) throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
        }
        try {
            return this.m_inDataStream.read(value, 0, value.length);
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
            return -1;
        }
    }

    public int readBytes(byte[] value, int length) throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
        }
        try {
            return this.m_inDataStream.read(value, 0, length);
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
            return -1;
        }
    }

    public void writeBoolean(boolean value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outDataStream.writeBoolean(value);
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        this.m_dirty = true;
    }

    public void writeByte(byte value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outDataStream.writeByte(value);
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        this.m_dirty = true;
    }

    public void writeShort(short value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outDataStream.writeShort(value);
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        this.m_dirty = true;
    }

    public void writeChar(char value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outDataStream.writeChar(value);
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        this.m_dirty = true;
    }

    public void writeInt(int value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outDataStream.writeInt(value);
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        this.m_dirty = true;
    }

    public void writeLong(long value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outDataStream.writeLong(value);
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        this.m_dirty = true;
    }

    public void writeFloat(float value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outDataStream.writeFloat(value);
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        this.m_dirty = true;
    }

    public void writeDouble(double value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        try {
            this.m_outDataStream.writeDouble(value);
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        this.m_dirty = true;
    }

    public void writeUTF(String value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        if (value == null) {
            throw new NullPointerException("BytesMessage.writeUTF encounters null parameter");
        }
        try {
            this.m_outDataStream.writeUTF(value);
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        this.m_dirty = true;
    }

    public void writeBytes(byte[] value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        if (value == null) {
            throw new NullPointerException("BytesMessage.writeBytes encounters null parameter");
        }
        try {
            this.m_outDataStream.write(value, 0, value.length);
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        this.m_dirty = true;
    }

    public void writeBytes(byte[] value, int offset, int length) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        if (value == null) {
            throw new NullPointerException("BytesMessage.writeBytes encounters null parameter");
        }
        try {
            this.m_outDataStream.write(value, offset, length);
        }
        catch (IOException io_ex) {
            AQjmsError.throwEx(157, (Throwable)io_ex);
        }
        this.m_dirty = true;
    }

    public void writeObject(Object value) throws JMSException {
        if (this.isBodyReadOnly()) {
            AQjmsError.throwMsgNotWriteableEx(163);
        }
        if (value == null) {
            throw new NullPointerException(AQjmsError.getMessage(229));
        }
        if (value instanceof Integer) {
            this.writeInt((Integer)value);
        } else if (value instanceof Long) {
            this.writeLong((Long)value);
        } else if (value instanceof Float) {
            this.writeFloat(((Float)value).floatValue());
        } else if (value instanceof Short) {
            this.writeShort((Short)value);
        } else if (value instanceof Byte) {
            this.writeByte((Byte)value);
        } else if (value instanceof Double) {
            this.writeDouble((Double)value);
        } else if (value instanceof String) {
            this.writeUTF(((String)value).toString());
        } else if (value instanceof Boolean) {
            this.writeBoolean((Boolean)value);
        } else if (value instanceof byte[]) {
            this.writeBytes((byte[])value);
        } else {
            AQjmsError.throwMsgFormatEx(161, null);
        }
        this.m_dirty = true;
    }

    public void reset() throws JMSException {
        if (this.access_mode == 1) {
            this.updateBytesDataFromStream();
            this.m_outByteArrayStream = null;
            this.m_outDataStream = null;
            this.m_dirty = false;
        }
        this.m_inDataStream = new DataInputStream(new ByteArrayInputStream(this.m_bytesData));
        this.setAccessMode(0);
    }

    public void clearBody() throws JMSException {
        if (this.access_mode == 0) {
            this.m_inDataStream = null;
        }
        this.m_bytesData = new byte[0];
        this.m_dirty = false;
        this.m_outByteArrayStream = new ByteArrayOutputStream();
        this.m_outDataStream = new DataOutputStream(this.m_outByteArrayStream);
        this.setAccessMode(1);
    }

    public long getBodyLength() throws JMSException {
        if (this.isBodyWriteOnly()) {
            AQjmsError.throwMsgNotReadableEx(162);
            return 0L;
        }
        if (this.m_bytesData == null) {
            return 0L;
        }
        return this.m_bytesData.length;
    }

    ORAData getMessageCont(AQjmsSession sess, boolean useTemporaryLob) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsBytesMessage.getMessageCont", "entry");
        this.updateBytesDataFromStream();
        AQjmsBytesMessage_C cont = new AQjmsBytesMessage_C();
        boolean[] writeLobFlag = new boolean[1];
        this.m_tempLob = AQjmsUtil.populateBytesContainer(cont, 1, this.header_ext, this.m_bytesData, sess, useTemporaryLob, writeLobFlag);
        this.setWriteLobLater(writeLobFlag[0]);
        AQjmsOracleDebug.trace(4, "AQjmsBytesMessage.getMessageCont", "exit");
        return cont;
    }

    AQjmsGenMessage_C getGenMessageCont(AQjmsSession sess, boolean useTemporaryLob) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsBytesMessage.getGenMessageCont", "entry");
        this.updateBytesDataFromStream();
        AQjmsGenMessage_C cont = new AQjmsGenMessage_C();
        boolean[] writeLobFlag = new boolean[1];
        this.m_tempLob = AQjmsUtil.populateBytesContainer(cont, 1, this.header_ext, this.m_bytesData, sess, useTemporaryLob, writeLobFlag);
        this.setWriteLobLater(writeLobFlag[0]);
        AQjmsOracleDebug.trace(4, "AQjmsBytesMessage.getGenMessageCont", "exit");
        return cont;
    }

    void writeLob(AQjmsSession sess, String queueTable, byte[] msgid, boolean isAnydataDest) throws JMSException {
        AQjmsOracleDebug.trace(4, "AQjmsBytesmessage.writeLob", "entry");
        if (this.m_writeLobLater) {
            AQjmsUtil.writeBlob(this.m_bytesData, sess, queueTable, msgid, isAnydataDest);
        }
        AQjmsOracleDebug.trace(4, "AQjmsBytesmessage.writeLlob", "exit");
    }

    private void readBytesMessageContainer(AQjmsBytesMessage_C msgCont) throws JMSException {
        try {
            this.m_bytesData = AQjmsUtil.getBytesData(msgCont.getBytesLen(), msgCont.getBytesLob(), msgCont.getBytesRaw());
        }
        catch (SQLException sqe) {
            throw new AQjmsException(sqe);
        }
        if (this.m_bytesData == null) {
            this.m_bytesData = new byte[0];
        }
    }

    private void readGenMessageContainer(AQjmsGenMessage_C msgCont) throws JMSException {
        try {
            this.m_bytesData = AQjmsUtil.getBytesData(msgCont.getBytesLen(), msgCont.getBytesLob(), msgCont.getBytesRaw());
        }
        catch (SQLException sqe) {
            throw new AQjmsException(sqe);
        }
        if (this.m_bytesData == null) {
            this.m_bytesData = new byte[0];
        }
    }

    private void updateBytesDataFromStream() {
        if (this.m_dirty) {
            this.m_bytesData = this.m_outByteArrayStream.toByteArray();
            this.m_dirty = false;
        }
    }
}

