package com.hzjt.redis;

import com.hzjt.domain.Alarm;
import com.hzjt.domain.Ftp;
import com.hzjt.domain.Traffalarmrecord;
import com.hzjt.handler.DelayQueueManager;
import com.hzjt.handler.FileTransferManager;
import com.hzjt.mapper.TraffAlarmRecordMapper;
import com.hzjt.service.AlarmRecordStatisticsService;
import com.hzjt.service.FtpService;
import com.hzjt.service.ImportService;
import com.hzjt.service.SeqService;
import com.hzjt.util.*;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * @Description: 消息接收者，将其在ExcelToDbApplication.java中注入消息监听容器(MessageListenerAdapter)中
 * @Author: 杨东川【http://blog.csdn.net/yangdongchuan1995】
 * @Date: Created in  2018-2-6
 */
@Service
public class Receiverbak {
    @Autowired
    ImportService importService;

    @Autowired
    RedisDao redisDao;

    @Autowired
    private TraffAlarmRecordMapper traffAlarmRecordMapper;

    @Autowired
    FtpService ftpService;

    @Autowired
    AlarmRecordStatisticsService alarmRecordStatisticsService;


    @Value("ftpIp")
    String ftpIp;
    @Value("ftpPort")
    private String ftpPort;
    @Value("ftpUsername")
    private String ftpUsername;
    @Value("ftpPassword")
    private String ftpPassword;
    @Value("${alarmrecord.check.enable}")
    private String checkEnable;

    @Autowired
    private SeqService seqService;

    private Long delayTime = 25L;
//    @Autowired
//    FtpUtil ftpUtil;
    @Autowired
    private DelayQueueManager delayQueueManager;

    private static final Logger log = LoggerFactory.getLogger(Receiverbak.class);



    /**
     * @Description: 用于接收单个对象，将对象同步至数据库，如果同步失败，则存入redis中
     * @Param: [message] “fastjson”转换后的json字符串
     * @Retrun: void
     */
    public void receiveSinglewww(String Message) throws InterruptedException {
        // 将json字符串转换成实体对

        Alarm trffClientMessage= JsonUtil.stringToBean(Message,Alarm.class);
        List<String> imgBase64List = trffClientMessage.getImg_base64();
        Traffalarmrecord traffAlarmRecord = new Traffalarmrecord();
        String imgEnumHead = "IMG";
        //Ftp ftp = new Ftp(ftpIp,Integer.parseInt(ftpPort),ftpUsername,ftpPassword);
        Ftp ftp = ftpService.reloadFtp();
        for (int i = 0; i < imgBase64List.size(); i++) {
            /* 图片上传 */
            String path = trffClientMessage.getVideo_id() + "/" + DateUtils.formatCurrDayNoSign();
            String fileName = UUIDUtils.createuuid() + ".jpg";
            if (FTPUtil.uploadFile(ftp, path, fileName, imgBase64List.get(i))) {
                TraffAlarmRecordImgEnum.valueOf(imgEnumHead + i).setImg(traffAlarmRecord, FTPUtil.getFtpUrl(ftp) + path + "/" + fileName);
            }
        }
        List<String> imgUrls = trffClientMessage.getImg_urls();
        for (int i = 0; i < imgUrls.size(); i++) {
            TraffAlarmRecordFromImgEnum.valueOf(imgEnumHead + i).setImg(traffAlarmRecord, imgUrls.get(i));
        }
        String[] videoIdArr = trffClientMessage.getVideo_id().split("_");
        String fdid = videoIdArr[0];
        traffAlarmRecord.setFdid(fdid);
        Integer channelid = Integer.valueOf(videoIdArr[1]) + 1;
        traffAlarmRecord.setChannelid(channelid);

        if (StringEnum.ONE.getValue().equals(checkEnable)) {
            /* 9:免审 */
            traffAlarmRecord.setCheckstatus(9);
        }
        int recordid = traffAlarmRecordMapper.selectmax();
        traffAlarmRecord.setRecordid((long)recordid);

        String dept = trffClientMessage.getDept();
        traffAlarmRecord.setAreaid(Long.valueOf(dept));
        String recordtype = trffClientMessage.getIncident_type().toLowerCase();
        traffAlarmRecord.setRecordtype(recordtype);
        traffAlarmRecord.setVideourlfrom(trffClientMessage.getVideo_record_url());
        traffAlarmRecord.setRecordtime(new Date(Long.valueOf(trffClientMessage.getTs())));
        traffAlarmRecord.setCreatetime(new Date());
        traffAlarmRecordMapper.inserTraffAlarmRecord(traffAlarmRecord);

        try {
            System.out.println("fetch ftp:" + ftp.toString()+"recordId:"+traffAlarmRecord.getRecordid());
            String basepath = "gstraff/" + traffAlarmRecord.getFdid() + (traffAlarmRecord.getChannelid() < 10 ? "0" + traffAlarmRecord.getChannelid() : traffAlarmRecord.getChannelid()) + "/" + DateUtils.formatCurrDayNoSign();
            Map<String, Object> transferRecordMap = new HashMap<>();
            FileTransferManager.fetchUrlsFromRecord(traffAlarmRecord, transferRecordMap);
            FileTransferManager.transferFile(transferRecordMap, ftp, basepath);

//             Traffalarmrecord recordBak = FileTransferManager.traffAlarmRecordUrlUpdate(results);
//            traffAlarmRecord.setImg1path(recordBak.getImg1path());
//            traffAlarmRecord.setImg2path(recordBak.getImg2path());
//            traffAlarmRecord.setImg3path(recordBak.getImg3path());
//            traffAlarmRecord.setImg4path(recordBak.getImg4path());
//            traffAlarmRecord.setImg5path(recordBak.getImg5path());
//            traffAlarmRecord.setVideopath(recordBak.getVideopath());
            if (traffAlarmRecord != null && traffAlarmRecord.getRecordid() != null) {
                traffAlarmRecordMapper.updateTraffAlarmRecordUrl(traffAlarmRecord);
            }
        } catch (Exception e) {
            log.error("解析事件告警数据异常 :" + e.getMessage());
        }
//
        redisDao.incrOrDecr(Constant.succSizeTempKey, -1);


    }

}
