package com.hzjt.domain;


import java.time.LocalDateTime;
import java.util.UUID;



public class Message extends MyMessage {

    private String id = UUID.randomUUID().toString();

    private LocalDateTime date = LocalDateTime.now();

    private String sender;

    private Message() {

    }

    private Message(String content, MessageType type, String sender) {
        super(content, type);
        this.sender = sender;
        date = LocalDateTime.now();
    }

    public LocalDateTime getDate() {
        return date;
    }

    public String getSender() {
        return sender;
    }

    public String getId() {
        return id;
    }

   
    public static class MessageBuilder {

        private Message message;

        private MessageBuilder(Message message) {
            this.message = message;
        }

        public MessageBuilder withContent(String content) {
            message.setContent(content);
            return this;
        }

        public MessageBuilder withType(MessageType type) {
            message.setType(type);
            return this;
        }

        public MessageBuilder sentBy(String sender) {
            message.sender = sender;
            return this;
        }

        public static MessageBuilder empty() {
            return new MessageBuilder(new Message());
        }

        public static MessageBuilder copyOf(Message message) {
            Message newMessage = new Message();
            newMessage.setContent(message.getContent());
            newMessage.setType(message.getType());
            newMessage.date = message.getDate();
            newMessage.sender = message.getSender();
            newMessage.id = message.getId();

            return new MessageBuilder(newMessage);
        }



        public Message build() {
            return message;
        }

    }

}
