package com.hzjt.service;

import com.hzjt.domain.Traffalarmrecord;
import com.hzjt.mapper.TraffAlarmRecordMapper;
import com.hzjt.domain.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

import java.util.List;

@Service
public class TraffalarmrecordService {

    @Autowired
    private TraffAlarmRecordMapper traffalarmrecordMapper;

    private String fileagentUrl;
    @Autowired
    public TraffalarmrecordService(TraffAlarmRecordMapper traffalarmrecordMapper,
                                   @Value("${gs.traff.cloud.web.fileagent.url}") String fileagentUrl) {
        this.traffalarmrecordMapper = traffalarmrecordMapper;
        this.fileagentUrl = fileagentUrl;
    }

    public void saveTraffalarmrecord(Traffalarmrecord traffalarmrecord) {
        traffalarmrecordMapper.insertSelective(traffalarmrecord);
    }
    public void saveTraffalarmrecordList(List<Traffalarmrecord> traffalarmrecordList) {
        traffalarmrecordMapper.insertList(traffalarmrecordList);
    }
    public void deleteTraffalarmrecord(Traffalarmrecord traffalarmrecord) {
        traffalarmrecordMapper.deleteByPrimaryKey(traffalarmrecord);
    }
    public void deleteTraffalarmrecordList(List<Traffalarmrecord> traffalarmrecordList) {
        for (Traffalarmrecord traffalarmrecord:traffalarmrecordList) {
            traffalarmrecordMapper.deleteByPrimaryKey(traffalarmrecord);
        }
    }
    public void updateTraffalarmrecord(Traffalarmrecord traffalarmrecord) {
        traffalarmrecordMapper.updateByPrimaryKeySelective(traffalarmrecord);
    }

    public Traffalarmrecord queryTraffalarmrecord(Traffalarmrecord traffalarmrecord) {
        return traffalarmrecordMapper.selectOne(traffalarmrecord);
    }
    public int countTraffalarmrecord(Traffalarmrecord traffalarmrecord) {
        return traffalarmrecordMapper.selectCount(traffalarmrecord);
    }
}