package com.hzjt;

import com.hzjt.redis.Receiver;
import com.hzjt.util.Constant;
import tk.mybatis.spring.annotation.MapperScan;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.PropertySource;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.listener.PatternTopic;
import org.springframework.data.redis.listener.RedisMessageListenerContainer;
import org.springframework.data.redis.listener.adapter.MessageListenerAdapter;

@SpringBootApplication
@ServletComponentScan
@MapperScan("com.hzjt.mapper")
@PropertySource("file:${spring.profiles.path}")
public class HZJTApplication {
    @Bean
    RedisMessageListenerContainer container(RedisConnectionFactory connectionFactory, MessageListenerAdapter listenerAdapterSingle, MessageListenerAdapter listenerAdapterList) {

        RedisMessageListenerContainer container = new RedisMessageListenerContainer();
        container.setConnectionFactory(connectionFactory);
        // 注入多个消息监听器(receiveSingle/receiveList)
        container.addMessageListener(listenerAdapterSingle, new PatternTopic(Constant.receiveSingle));
        container.addMessageListener(listenerAdapterList, new PatternTopic(Constant.receiveList));
        return container;
    }


    @Bean
    MessageListenerAdapter listenerAdapterSingle(Receiver receiver) {
        return new MessageListenerAdapter(receiver, Constant.singleMethodName);
    }

    @Bean
    MessageListenerAdapter listenerAdapterList(Receiver receiver) {
        return new MessageListenerAdapter(receiver, Constant.listMethodName);
    }

    @Bean
    Receiver receiver() {
        return new Receiver();
    }

    @Value("${ip.host}")
    private String ip;
//
//    @Bean
//    public RestTemplate restTemplate(RestTemplateBuilder builder) {
//        // Do any additional configuration here
//        return builder.build();
//    }

//    @Bean
//    public WebSocketClient webSocketClient() {
//
//        List<WebSocketClient> list=new ArrayList<>();
//
//        String[] ips = iptr.split(",");
//        for (String ip : ips) {
//            try {
//                MyWebSocketClient client = new MyWebSocketClient(new URI("ws://" + ip + "8001/api/message/sub/traffic-incident/alarm"));
//                client.connect();
//                if (!client.getReadyState().equals(WebSocket.READYSTATE.OPEN)) {
//                    //连接失败,重新连接
//                    client.connect();
//                    list.add(client);
//                }
//
//            } catch (URISyntaxException e) {
//                e.printStackTrace();
//            }
//
//        }
//        return list;
//    }

//    @Bean
//    public WebSocketClient webSocketClient() {
//        try {
//           MyWebSocketClient client = new MyWebSocketClient(new URI("ws://" + ip + ":8001/api/message/sub/traffic-incident/alarm"));
////            MyWebSocketClient client = new MyWebSocketClient(new URI("ws://local" + ip + "8001/api/message/sub/traffic-incident/alarm"));
////
//            if (!client.isOpen()) {
//                if (client.getReadyState().equals(WebSocket.READYSTATE.NOT_YET_CONNECTED)) {
//                    try {
//                        client.connect();
//                    } catch (IllegalStateException e) {
//                    }
//                } else if (client.getReadyState().equals(WebSocket.READYSTATE.CLOSING) || client.getReadyState().equals(WebSocket.READYSTATE.CLOSED)) {
//                    client.reconnect();
//                }
//            }
//            return client;
//
//        } catch (URISyntaxException e) {
//            e.printStackTrace();
//        }
//        return null;
//    }
    public static void main(String[] args) {
//        ConfigurableApplicationContext applicationContext=SpringApplication.run(HZJTApplication.class,args);
//        WebSocket.setApplicationContext(applicationContext);
        SpringApplication.run(HZJTApplication.class,args);
    }


}
